# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr

from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_entity_statistics_model_organization import (
    SeasonEntityStatisticsModelOrganization,
)
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition


class SeasonEntityStatisticsModel(BaseModel):
    """
    SeasonEntityStatisticsModel
    """

    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonEntityStatisticsModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    statistics: Optional[Dict[str, Any]] = None
    __properties = [
        "entityId",
        "entity",
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "competitionId",
        "competition",
        "periodId",
        "statistics",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonEntityStatisticsModel:
        """Create an instance of SeasonEntityStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonEntityStatisticsModel:
        """Create an instance of SeasonEntityStatisticsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonEntityStatisticsModel.parse_obj(obj)

        _obj = SeasonEntityStatisticsModel.parse_obj(
            {
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonEntityStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "period_id": obj.get("periodId"),
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
