# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conint, constr, validator


class SeasonEntitiesPostBody(BaseModel):
    """
    SeasonEntitiesPostBody
    """

    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    roster_status: Optional[constr(strict=True, max_length=100)] = Field(
        "UNKNOWN",
        alias="rosterStatus",
        description="The status of the ENTITY season entities >- `APPROVED` Approved >- `PENDING` Pending >- `REJECTED` Rejected >- `SUBMITTED` Submitted >- `UNKNOWN` Unknown ",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    seed: Optional[conint(strict=True)] = Field(None, description="Initial seeding")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "seasonId",
        "entityId",
        "conferenceId",
        "divisionId",
        "rosterStatus",
        "status",
        "seed",
        "externalId",
    ]

    @validator("roster_status")
    def roster_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("UNKNOWN", "SUBMITTED", "PENDING", "APPROVED", "REJECTED"):
            raise ValueError("must be one of enum values ('UNKNOWN', 'SUBMITTED', 'PENDING', 'APPROVED', 'REJECTED')")
        return value

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonEntitiesPostBody:
        """Create an instance of SeasonEntitiesPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if conference_id (nullable) is None
        # and __fields_set__ contains the field
        if self.conference_id is None and "conference_id" in self.__fields_set__:
            _dict["conferenceId"] = None

        # set to None if division_id (nullable) is None
        # and __fields_set__ contains the field
        if self.division_id is None and "division_id" in self.__fields_set__:
            _dict["divisionId"] = None

        # set to None if seed (nullable) is None
        # and __fields_set__ contains the field
        if self.seed is None and "seed" in self.__fields_set__:
            _dict["seed"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonEntitiesPostBody:
        """Create an instance of SeasonEntitiesPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonEntitiesPostBody.parse_obj(obj)

        _obj = SeasonEntitiesPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "conference_id": obj.get("conferenceId"),
                "division_id": obj.get("divisionId"),
                "roster_status": obj.get("rosterStatus") if obj.get("rosterStatus") is not None else "UNKNOWN",
                "status": obj.get("status"),
                "seed": obj.get("seed"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
