# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.entities_model_entity_group import EntitiesModelEntityGroup
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.roles_model_organization import RolesModelOrganization


class RolesModel(BaseModel):
    """
    RolesModel
    """

    role_id: Optional[StrictStr] = Field(None, alias="roleId", description="The unique identifier of the role")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[RolesModelOrganization] = None
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    entity_group: Optional[EntitiesModelEntityGroup] = Field(None, alias="entityGroup")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    date_from: Optional[date] = Field(
        None, alias="dateFrom", description="Date the role started (Not for a role within a fixture)"
    )
    date_to: Optional[date] = Field(
        None, alias="dateTo", description="Date the role ended (Not for a role within a fixture)"
    )
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    role_number: Optional[StrictInt] = Field(
        None, alias="roleNumber", description="Number within the role. eg: Assistant Coach 2"
    )
    role: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        description="Role >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strengh and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SECRETARY` Secretary >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assitant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) ",
    )
    role_sub_type: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="roleSubType", description="Role sub type"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "roleId",
        "organizationId",
        "organization",
        "entityGroupId",
        "entityGroup",
        "entityId",
        "entity",
        "seasonId",
        "season",
        "fixtureId",
        "fixture",
        "personId",
        "person",
        "status",
        "dateFrom",
        "dateTo",
        "bib",
        "roleNumber",
        "role",
        "roleSubType",
        "externalId",
        "updated",
        "added",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("role")
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "COACH",
            "COACH_HEAD",
            "COACH_HEAD_INTERIM",
            "COACH_ASSISTANT",
            "COACH_ASSISTANT_HEAD",
            "COACH_ASSOCIATE_HEAD",
            "COACH_SC",
            "COACH_SENIOR",
            "COACH_DEVELOPMENT",
            "COACH_SPECIALIST",
            "COACH_OTHER",
            "CAPTAIN",
            "CAPTAIN_VICE",
            "DOCTOR",
            "PHYSIOTHERAPIST",
            "MEDICAL_STAFF",
            "TRAINER",
            "TRAINER_ASSISTANT",
            "MATCH_OFFICIAL",
            "COMMISSIONER",
            "STATISTICIAN",
            "SCOREKEEPER",
            "SCOREKEEPER_ASSISTANT",
            "TIMEKEEPER",
            "SCORER",
            "SCORER_ASSISTANT",
            "TIMER",
            "GROUNDSKEEPER",
            "CEO",
            "COMMITTEE",
            "PRESIDENT",
            "DIRECTOR",
            "PRESIDENT_VICE",
            "SECRETARY",
            "TREASURER",
            "MANAGER",
            "GENERAL",
            "OTHER",
            "REFEREE",
            "UMPIRE",
            "REFEREE_ASSISTANT",
            "REFEREE_RESERVE",
            "REFEREE_ASSISTANT_RESERVE",
            "CREW_CHIEF",
            "UMPIRE_RESERVE",
            "UMPIRE_VIDEO",
            "JUDGE_SCORING",
            "JUDGE_TIMING",
            "TECHNICAL_OFFICIAL",
            "VIDEO_TECHNICIAN",
            "TRANSLATOR",
            "MEDIA_OFFICER",
        ):
            raise ValueError(
                "must be one of enum values ('COACH', 'COACH_HEAD', 'COACH_HEAD_INTERIM', 'COACH_ASSISTANT', 'COACH_ASSISTANT_HEAD', 'COACH_ASSOCIATE_HEAD', 'COACH_SC', 'COACH_SENIOR', 'COACH_DEVELOPMENT', 'COACH_SPECIALIST', 'COACH_OTHER', 'CAPTAIN', 'CAPTAIN_VICE', 'DOCTOR', 'PHYSIOTHERAPIST', 'MEDICAL_STAFF', 'TRAINER', 'TRAINER_ASSISTANT', 'MATCH_OFFICIAL', 'COMMISSIONER', 'STATISTICIAN', 'SCOREKEEPER', 'SCOREKEEPER_ASSISTANT', 'TIMEKEEPER', 'SCORER', 'SCORER_ASSISTANT', 'TIMER', 'GROUNDSKEEPER', 'CEO', 'COMMITTEE', 'PRESIDENT', 'DIRECTOR', 'PRESIDENT_VICE', 'SECRETARY', 'TREASURER', 'MANAGER', 'GENERAL', 'OTHER', 'REFEREE', 'UMPIRE', 'REFEREE_ASSISTANT', 'REFEREE_RESERVE', 'REFEREE_ASSISTANT_RESERVE', 'CREW_CHIEF', 'UMPIRE_RESERVE', 'UMPIRE_VIDEO', 'JUDGE_SCORING', 'JUDGE_TIMING', 'TECHNICAL_OFFICIAL', 'VIDEO_TECHNICIAN', 'TRANSLATOR', 'MEDIA_OFFICER')"
            )
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RolesModel:
        """Create an instance of RolesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity_group
        if self.entity_group:
            _dict["entityGroup"] = self.entity_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # set to None if entity_group_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_group_id is None and "entity_group_id" in self.__fields_set__:
            _dict["entityGroupId"] = None

        # set to None if entity_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_id is None and "entity_id" in self.__fields_set__:
            _dict["entityId"] = None

        # set to None if season_id (nullable) is None
        # and __fields_set__ contains the field
        if self.season_id is None and "season_id" in self.__fields_set__:
            _dict["seasonId"] = None

        # set to None if fixture_id (nullable) is None
        # and __fields_set__ contains the field
        if self.fixture_id is None and "fixture_id" in self.__fields_set__:
            _dict["fixtureId"] = None

        # set to None if date_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_from is None and "date_from" in self.__fields_set__:
            _dict["dateFrom"] = None

        # set to None if date_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_to is None and "date_to" in self.__fields_set__:
            _dict["dateTo"] = None

        # set to None if bib (nullable) is None
        # and __fields_set__ contains the field
        if self.bib is None and "bib" in self.__fields_set__:
            _dict["bib"] = None

        # set to None if role_number (nullable) is None
        # and __fields_set__ contains the field
        if self.role_number is None and "role_number" in self.__fields_set__:
            _dict["roleNumber"] = None

        # set to None if role_sub_type (nullable) is None
        # and __fields_set__ contains the field
        if self.role_sub_type is None and "role_sub_type" in self.__fields_set__:
            _dict["roleSubType"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RolesModel:
        """Create an instance of RolesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RolesModel.parse_obj(obj)

        _obj = RolesModel.parse_obj(
            {
                "role_id": obj.get("roleId"),
                "organization_id": obj.get("organizationId"),
                "organization": RolesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "entity_group_id": obj.get("entityGroupId"),
                "entity_group": EntitiesModelEntityGroup.from_dict(obj.get("entityGroup"))
                if obj.get("entityGroup") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "status": obj.get("status"),
                "date_from": obj.get("dateFrom"),
                "date_to": obj.get("dateTo"),
                "bib": obj.get("bib"),
                "role_number": obj.get("roleNumber"),
                "role": obj.get("role"),
                "role_sub_type": obj.get("roleSubType"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
