# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr


class ResponseMetaData(BaseModel):
    """
    ResponseMetaData
    """

    version: Optional[StrictInt] = Field(None, description="The version of the API in use for this call")
    code_version: Optional[StrictStr] = Field(
        None, alias="codeVersion", description="A string indicating the version of the code that handled this request"
    )
    code: Optional[StrictInt] = Field(None, description="The HTTP response code for this request")
    time: Optional[datetime] = Field(None, description="The date/time this request was made (in UTC).")
    from_cache: Optional[StrictBool] = Field(
        None, alias="fromCache", description="Was this request served directly from the cache?"
    )
    count: Optional[StrictInt] = Field(None, description="The number of records being returned")
    limit: Optional[StrictInt] = Field(None, description="The record limit in place for this request")
    offset: Optional[StrictInt] = Field(None, description="The record offset in place for this request")
    generation_time: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="generationTime", description="The number of seconds taken to generate this request."
    )
    __properties = ["version", "codeVersion", "code", "time", "fromCache", "count", "limit", "offset", "generationTime"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResponseMetaData:
        """Create an instance of ResponseMetaData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResponseMetaData:
        """Create an instance of ResponseMetaData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResponseMetaData.parse_obj(obj)

        _obj = ResponseMetaData.parse_obj(
            {
                "version": obj.get("version"),
                "code_version": obj.get("codeVersion"),
                "code": obj.get("code"),
                "time": obj.get("time"),
                "from_cache": obj.get("fromCache"),
                "count": obj.get("count"),
                "limit": obj.get("limit"),
                "offset": obj.get("offset"),
                "generation_time": obj.get("generationTime"),
            }
        )
        return _obj
