# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class RankingRowsPostBody(BaseModel):
    """
    RankingRowsPostBody
    """

    row_id: Optional[StrictStr] = Field(None, alias="rowId", description="The unique identifier of the ranking run")
    organization_id: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        ..., alias="organizationId", description="The unique identifier of the organization"
    )
    ranking_id: Optional[StrictStr] = Field(None, alias="rankingId", description="The unique identifier of the ranking")
    ranking_run_id: Optional[StrictStr] = Field(
        None, alias="rankingRunId", description="The unique identifier of the ranking run"
    )
    entity_id: StrictStr = Field(..., alias="entityId", description="The entity that this ranking run is linked to")
    position: Optional[StrictInt] = Field(None, description="Position")
    force_order: Optional[StrictInt] = Field(None, alias="forceOrder", description="Sort order to help ties")
    points: Optional[StrictInt] = Field(None, description="Points")
    points_string: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="pointsString", description="Points String"
    )
    __properties = [
        "rowId",
        "organizationId",
        "rankingId",
        "rankingRunId",
        "entityId",
        "position",
        "forceOrder",
        "points",
        "pointsString",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RankingRowsPostBody:
        """Create an instance of RankingRowsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if organization_id (nullable) is None
        # and __fields_set__ contains the field
        if self.organization_id is None and "organization_id" in self.__fields_set__:
            _dict["organizationId"] = None

        # set to None if position (nullable) is None
        # and __fields_set__ contains the field
        if self.position is None and "position" in self.__fields_set__:
            _dict["position"] = None

        # set to None if force_order (nullable) is None
        # and __fields_set__ contains the field
        if self.force_order is None and "force_order" in self.__fields_set__:
            _dict["forceOrder"] = None

        # set to None if points (nullable) is None
        # and __fields_set__ contains the field
        if self.points is None and "points" in self.__fields_set__:
            _dict["points"] = None

        # set to None if points_string (nullable) is None
        # and __fields_set__ contains the field
        if self.points_string is None and "points_string" in self.__fields_set__:
            _dict["pointsString"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RankingRowsPostBody:
        """Create an instance of RankingRowsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RankingRowsPostBody.parse_obj(obj)

        _obj = RankingRowsPostBody.parse_obj(
            {
                "row_id": obj.get("rowId"),
                "organization_id": obj.get("organizationId"),
                "ranking_id": obj.get("rankingId"),
                "ranking_run_id": obj.get("rankingRunId"),
                "entity_id": obj.get("entityId"),
                "position": obj.get("position"),
                "force_order": obj.get("forceOrder"),
                "points": obj.get("points"),
                "points_string": obj.get("pointsString"),
            }
        )
        return _obj
