# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Dict, List, Optional

from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.person_additional_details import PersonAdditionalDetails
from atriumsports.datacore.openapi.models.person_historical_name import PersonHistoricalName
from atriumsports.datacore.openapi.models.person_post_body_additional_names_value import (
    PersonPostBodyAdditionalNamesValue,
)
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class PersonPostBody(BaseModel):
    """
    PersonPostBody
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    status: constr(strict=True, max_length=30) = Field(
        ...,
        description="Status >- `ACTIVE` Active >- `DECEASED` Deceased >- `INACTIVE` Inactive >- `PENDING` Pending >- `UNREGISTERED` UnRegistered ",
    )
    gender: StrictStr = Field(
        ..., description="The gender of the person >- `FEMALE` Female >- `MALE` Male >- `UNKNOWN` Unknown "
    )
    name_full_local: constr(strict=True, max_length=200) = Field(
        ...,
        alias="nameFullLocal",
        description="The full name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_abbreviated: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="nameAbbreviated", description="An abbreviated name for a person"
    )
    language_local: Optional[constr(strict=True, max_length=2)] = Field(
        None,
        alias="languageLocal",
        description="The language code of the full name in [local](#section/Introduction/Character-Sets-and-Names) language. This code is a two letter (lower-case) ISO 639-1 language code.",
    )
    name_given_local: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="nameGivenLocal",
        description="Given name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_family_local: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="nameFamilyLocal",
        description="Family name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_full_latin: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="nameFullLatin",
        description="The full name of the person in [latin](##section/Introduction/Character-Sets-and-Names) characters",
    )
    name_given_latin: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="nameGivenLatin",
        description="Given name of the person in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_family_latin: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="nameFamilyLatin",
        description="Family name of the person in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    dob: Optional[date] = Field(None, description="Date of Birth")
    nationality: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None, description="A 3 letter nationality code. We recommend you use ISO-3166 where available."
    )
    deceased: Optional[date] = Field(None, description="Date deceased")
    additional_names: Optional[Dict[str, PersonPostBodyAdditionalNamesValue]] = Field(
        None,
        alias="additionalNames",
        description="Additional names for the person. They are broken down by language, so you can have a different set of names per language",
    )
    additional_details: Optional[PersonAdditionalDetails] = Field(None, alias="additionalDetails")
    social: Optional[SocialMedia] = None
    historical_names: Optional[conlist(PersonHistoricalName)] = Field(
        None, alias="historicalNames", description="Array of person historical names"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "personId",
        "status",
        "gender",
        "nameFullLocal",
        "nameAbbreviated",
        "languageLocal",
        "nameGivenLocal",
        "nameFamilyLocal",
        "nameFullLatin",
        "nameGivenLatin",
        "nameFamilyLatin",
        "dob",
        "nationality",
        "deceased",
        "additionalNames",
        "additionalDetails",
        "social",
        "historicalNames",
        "externalId",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("ACTIVE", "UNREGISTERED", "PENDING", "DECEASED", "INACTIVE"):
            raise ValueError("must be one of enum values ('ACTIVE', 'UNREGISTERED', 'PENDING', 'DECEASED', 'INACTIVE')")
        return value

    @validator("gender")
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("MALE", "FEMALE", "UNKNOWN"):
            raise ValueError("must be one of enum values ('MALE', 'FEMALE', 'UNKNOWN')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PersonPostBody:
        """Create an instance of PersonPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in additional_names (dict)
        _field_dict = {}
        if self.additional_names:
            for _key in self.additional_names:
                if self.additional_names[_key]:
                    _field_dict[_key] = self.additional_names[_key].to_dict()
            _dict["additionalNames"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of additional_details
        if self.additional_details:
            _dict["additionalDetails"] = self.additional_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # set to None if name_abbreviated (nullable) is None
        # and __fields_set__ contains the field
        if self.name_abbreviated is None and "name_abbreviated" in self.__fields_set__:
            _dict["nameAbbreviated"] = None

        # set to None if language_local (nullable) is None
        # and __fields_set__ contains the field
        if self.language_local is None and "language_local" in self.__fields_set__:
            _dict["languageLocal"] = None

        # set to None if name_given_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_given_local is None and "name_given_local" in self.__fields_set__:
            _dict["nameGivenLocal"] = None

        # set to None if name_family_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_family_local is None and "name_family_local" in self.__fields_set__:
            _dict["nameFamilyLocal"] = None

        # set to None if name_full_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_latin is None and "name_full_latin" in self.__fields_set__:
            _dict["nameFullLatin"] = None

        # set to None if name_given_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_given_latin is None and "name_given_latin" in self.__fields_set__:
            _dict["nameGivenLatin"] = None

        # set to None if name_family_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_family_latin is None and "name_family_latin" in self.__fields_set__:
            _dict["nameFamilyLatin"] = None

        # set to None if dob (nullable) is None
        # and __fields_set__ contains the field
        if self.dob is None and "dob" in self.__fields_set__:
            _dict["dob"] = None

        # set to None if nationality (nullable) is None
        # and __fields_set__ contains the field
        if self.nationality is None and "nationality" in self.__fields_set__:
            _dict["nationality"] = None

        # set to None if deceased (nullable) is None
        # and __fields_set__ contains the field
        if self.deceased is None and "deceased" in self.__fields_set__:
            _dict["deceased"] = None

        # set to None if additional_names (nullable) is None
        # and __fields_set__ contains the field
        if self.additional_names is None and "additional_names" in self.__fields_set__:
            _dict["additionalNames"] = None

        # set to None if additional_details (nullable) is None
        # and __fields_set__ contains the field
        if self.additional_details is None and "additional_details" in self.__fields_set__:
            _dict["additionalDetails"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if historical_names (nullable) is None
        # and __fields_set__ contains the field
        if self.historical_names is None and "historical_names" in self.__fields_set__:
            _dict["historicalNames"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PersonPostBody:
        """Create an instance of PersonPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PersonPostBody.parse_obj(obj)

        _obj = PersonPostBody.parse_obj(
            {
                "person_id": obj.get("personId"),
                "status": obj.get("status") if obj.get("status") is not None else "ACTIVE",
                "gender": obj.get("gender"),
                "name_full_local": obj.get("nameFullLocal"),
                "name_abbreviated": obj.get("nameAbbreviated"),
                "language_local": obj.get("languageLocal"),
                "name_given_local": obj.get("nameGivenLocal"),
                "name_family_local": obj.get("nameFamilyLocal"),
                "name_full_latin": obj.get("nameFullLatin"),
                "name_given_latin": obj.get("nameGivenLatin"),
                "name_family_latin": obj.get("nameFamilyLatin"),
                "dob": obj.get("dob"),
                "nationality": obj.get("nationality"),
                "deceased": obj.get("deceased"),
                "additional_names": dict(
                    (_k, PersonPostBodyAdditionalNamesValue.from_dict(_v))
                    for _k, _v in obj.get("additionalNames").items()
                )
                if obj.get("additionalNames") is not None
                else None,
                "additional_details": PersonAdditionalDetails.from_dict(obj.get("additionalDetails"))
                if obj.get("additionalDetails") is not None
                else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "historical_names": [PersonHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
