# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class PersonHistoricalName(BaseModel):
    """
    PersonHistoricalName
    """

    date_start: Optional[date] = Field(None, alias="dateStart", description="Start date")
    date_end: Optional[date] = Field(None, alias="dateEnd", description="End date")
    name_full_local: Optional[StrictStr] = Field(
        None,
        alias="nameFullLocal",
        description="The full name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_given_local: Optional[StrictStr] = Field(
        None,
        alias="nameGivenLocal",
        description="Given name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_family_local: Optional[StrictStr] = Field(
        None,
        alias="nameFamilyLocal",
        description="Family name of the person in [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_full_latin: Optional[StrictStr] = Field(
        None,
        alias="nameFullLatin",
        description="The full name of the person in [latin](##section/Introduction/Character-Sets-and-Names) characters",
    )
    name_given_latin: Optional[StrictStr] = Field(
        None,
        alias="nameGivenLatin",
        description="Given name of the person in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_family_latin: Optional[StrictStr] = Field(
        None,
        alias="nameFamilyLatin",
        description="Family name of the person in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    __properties = [
        "dateStart",
        "dateEnd",
        "nameFullLocal",
        "nameGivenLocal",
        "nameFamilyLocal",
        "nameFullLatin",
        "nameGivenLatin",
        "nameFamilyLatin",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PersonHistoricalName:
        """Create an instance of PersonHistoricalName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if date_start (nullable) is None
        # and __fields_set__ contains the field
        if self.date_start is None and "date_start" in self.__fields_set__:
            _dict["dateStart"] = None

        # set to None if date_end (nullable) is None
        # and __fields_set__ contains the field
        if self.date_end is None and "date_end" in self.__fields_set__:
            _dict["dateEnd"] = None

        # set to None if name_full_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_local is None and "name_full_local" in self.__fields_set__:
            _dict["nameFullLocal"] = None

        # set to None if name_given_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_given_local is None and "name_given_local" in self.__fields_set__:
            _dict["nameGivenLocal"] = None

        # set to None if name_family_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_family_local is None and "name_family_local" in self.__fields_set__:
            _dict["nameFamilyLocal"] = None

        # set to None if name_full_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_latin is None and "name_full_latin" in self.__fields_set__:
            _dict["nameFullLatin"] = None

        # set to None if name_given_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_given_latin is None and "name_given_latin" in self.__fields_set__:
            _dict["nameGivenLatin"] = None

        # set to None if name_family_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_family_latin is None and "name_family_latin" in self.__fields_set__:
            _dict["nameFamilyLatin"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PersonHistoricalName:
        """Create an instance of PersonHistoricalName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PersonHistoricalName.parse_obj(obj)

        _obj = PersonHistoricalName.parse_obj(
            {
                "date_start": obj.get("dateStart"),
                "date_end": obj.get("dateEnd"),
                "name_full_local": obj.get("nameFullLocal"),
                "name_given_local": obj.get("nameGivenLocal"),
                "name_family_local": obj.get("nameFamilyLocal"),
                "name_full_latin": obj.get("nameFullLatin"),
                "name_given_latin": obj.get("nameGivenLatin"),
                "name_family_latin": obj.get("nameFamilyLatin"),
            }
        )
        return _obj
