# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator


class PersonAdditionalDetails(BaseModel):
    """
    Additional person detail fields
    """

    height: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Height in cms")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Weight in kgs")
    dominant_hand: Optional[StrictStr] = Field(None, alias="dominantHand", description="Dominant hand")
    dominant_foot: Optional[StrictStr] = Field(None, alias="dominantFoot", description="Dominant foot")
    home_town: Optional[StrictStr] = Field(None, alias="homeTown", description="Hometown")
    college: Optional[StrictStr] = Field(None, description="College")
    representation: Optional[StrictStr] = Field(None, description="Representation")
    junior_association_league: Optional[StrictStr] = Field(
        None, alias="juniorAssociationLeague", description="Junior Association / League"
    )
    __properties = [
        "height",
        "weight",
        "dominantHand",
        "dominantFoot",
        "homeTown",
        "college",
        "representation",
        "juniorAssociationLeague",
    ]

    @validator("dominant_hand")
    def dominant_hand_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("LEFT", "RIGHT"):
            raise ValueError("must be one of enum values ('LEFT', 'RIGHT')")
        return value

    @validator("dominant_foot")
    def dominant_foot_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("LEFT", "RIGHT"):
            raise ValueError("must be one of enum values ('LEFT', 'RIGHT')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PersonAdditionalDetails:
        """Create an instance of PersonAdditionalDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if height (nullable) is None
        # and __fields_set__ contains the field
        if self.height is None and "height" in self.__fields_set__:
            _dict["height"] = None

        # set to None if weight (nullable) is None
        # and __fields_set__ contains the field
        if self.weight is None and "weight" in self.__fields_set__:
            _dict["weight"] = None

        # set to None if dominant_hand (nullable) is None
        # and __fields_set__ contains the field
        if self.dominant_hand is None and "dominant_hand" in self.__fields_set__:
            _dict["dominantHand"] = None

        # set to None if dominant_foot (nullable) is None
        # and __fields_set__ contains the field
        if self.dominant_foot is None and "dominant_foot" in self.__fields_set__:
            _dict["dominantFoot"] = None

        # set to None if home_town (nullable) is None
        # and __fields_set__ contains the field
        if self.home_town is None and "home_town" in self.__fields_set__:
            _dict["homeTown"] = None

        # set to None if college (nullable) is None
        # and __fields_set__ contains the field
        if self.college is None and "college" in self.__fields_set__:
            _dict["college"] = None

        # set to None if representation (nullable) is None
        # and __fields_set__ contains the field
        if self.representation is None and "representation" in self.__fields_set__:
            _dict["representation"] = None

        # set to None if junior_association_league (nullable) is None
        # and __fields_set__ contains the field
        if self.junior_association_league is None and "junior_association_league" in self.__fields_set__:
            _dict["juniorAssociationLeague"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PersonAdditionalDetails:
        """Create an instance of PersonAdditionalDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PersonAdditionalDetails.parse_obj(obj)

        _obj = PersonAdditionalDetails.parse_obj(
            {
                "height": obj.get("height"),
                "weight": obj.get("weight"),
                "dominant_hand": obj.get("dominantHand"),
                "dominant_foot": obj.get("dominantFoot"),
                "home_town": obj.get("homeTown"),
                "college": obj.get("college"),
                "representation": obj.get("representation"),
                "junior_association_league": obj.get("juniorAssociationLeague"),
            }
        )
        return _obj
