# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class OrganizationPutBody(BaseModel):
    """
    OrganizationPutBody
    """

    abbreviation_local: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the organization in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the organization in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the organization. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    region_type: Optional[StrictStr] = Field(
        None,
        alias="regionType",
        description="How geographically relevant is this organization >- `INTERNATIONAL` Multiple countries >- `INTERSTATE` Cross state >- `LOCAL` Local area >- `NATIONAL` One country >- `STATE` One state ",
    )
    default_locale: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, alias="defaultLocale", description="The locale of the video"
    )
    __properties = [
        "abbreviationLocal",
        "nameLocal",
        "abbreviationLatin",
        "nameLatin",
        "countryCode",
        "regionType",
        "defaultLocale",
    ]

    @validator("region_type")
    def region_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("LOCAL", "STATE", "INTERSTATE", "NATIONAL", "INTERNATIONAL"):
            raise ValueError("must be one of enum values ('LOCAL', 'STATE', 'INTERSTATE', 'NATIONAL', 'INTERNATIONAL')")
        return value

    @validator("default_locale")
    def default_locale_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", value):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationPutBody:
        """Create an instance of OrganizationPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if country_code (nullable) is None
        # and __fields_set__ contains the field
        if self.country_code is None and "country_code" in self.__fields_set__:
            _dict["countryCode"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationPutBody:
        """Create an instance of OrganizationPutBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganizationPutBody.parse_obj(obj)

        _obj = OrganizationPutBody.parse_obj(
            {
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "country_code": obj.get("countryCode"),
                "region_type": obj.get("regionType"),
                "default_locale": obj.get("defaultLocale"),
            }
        )
        return _obj
