# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.images_model import ImagesModel
from atriumsports.datacore.openapi.models.leagues_model_organization import LeaguesModelOrganization
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class LeaguesModel(BaseModel):
    """
    LeaguesModel
    """

    league_id: Optional[StrictStr] = Field(None, alias="leagueId", description="The unique identifier of the league")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[LeaguesModelOrganization] = None
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the league in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the league in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the league. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    region_type: Optional[StrictStr] = Field(
        None,
        alias="regionType",
        description="How geographically relevant is this league >- `INTERNATIONAL` Multiple countries >- `INTERSTATE` Cross state >- `LOCAL` Local area >- `NATIONAL` One country >- `STATE` One state ",
    )
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    images: Optional[conlist(ImagesModel)] = None
    __properties = [
        "leagueId",
        "organizationId",
        "organization",
        "abbreviationLocal",
        "nameLocal",
        "abbreviationLatin",
        "nameLatin",
        "countryCode",
        "regionType",
        "social",
        "externalId",
        "updated",
        "added",
        "images",
    ]

    @validator("region_type")
    def region_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("LOCAL", "STATE", "INTERSTATE", "NATIONAL", "INTERNATIONAL"):
            raise ValueError("must be one of enum values ('LOCAL', 'STATE', 'INTERSTATE', 'NATIONAL', 'INTERNATIONAL')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaguesModel:
        """Create an instance of LeaguesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["images"] = _items
        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if country_code (nullable) is None
        # and __fields_set__ contains the field
        if self.country_code is None and "country_code" in self.__fields_set__:
            _dict["countryCode"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaguesModel:
        """Create an instance of LeaguesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LeaguesModel.parse_obj(obj)

        _obj = LeaguesModel.parse_obj(
            {
                "league_id": obj.get("leagueId"),
                "organization_id": obj.get("organizationId"),
                "organization": LeaguesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "country_code": obj.get("countryCode"),
                "region_type": obj.get("regionType"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "images": [ImagesModel.from_dict(_item) for _item in obj.get("images")]
                if obj.get("images") is not None
                else None,
            }
        )
        return _obj
