# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import List, Optional

from pydantic import BaseModel, Field, conlist

from atriumsports.datacore.openapi.models.season_person_statistics_model import SeasonPersonStatisticsModel


class LeaderSummaryModel(BaseModel):
    """
    LeaderSummaryModel
    """

    stat_name: Optional[conlist(SeasonPersonStatisticsModel)] = Field(
        None,
        alias="statName",
        description="There will be an element/object here for each statistic you have requested. The 'statName' key will be the name of the statistics. eg `points`",
    )
    __properties = ["statName"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaderSummaryModel:
        """Create an instance of LeaderSummaryModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "stat_name",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in stat_name (list)
        _items = []
        if self.stat_name:
            for _item in self.stat_name:
                if _item:
                    _items.append(_item.to_dict())
            _dict["statName"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaderSummaryModel:
        """Create an instance of LeaderSummaryModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LeaderSummaryModel.parse_obj(obj)

        _obj = LeaderSummaryModel.parse_obj(
            {
                "stat_name": [SeasonPersonStatisticsModel.from_dict(_item) for _item in obj.get("statName")]
                if obj.get("statName") is not None
                else None
            }
        )
        return _obj
