# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator

from atriumsports.datacore.openapi.models.leader_qualifiers_model_leaders_criteria import (
    LeaderQualifiersModelLeadersCriteria,
)
from atriumsports.datacore.openapi.models.leader_qualifiers_model_organization import LeaderQualifiersModelOrganization


class LeaderQualifiersModel(BaseModel):
    """
    LeaderQualifiersModel
    """

    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    qualifier_id: Optional[StrictStr] = Field(
        None, alias="qualifierId", description="The unique identifier of the leader qualifier"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[LeaderQualifiersModelOrganization] = None
    leader_criteria_id: Optional[StrictStr] = Field(
        None, alias="leaderCriteriaId", description="The unique identifier of the ~LeaderCriteria~"
    )
    leaders_criteria: Optional[LeaderQualifiersModelLeadersCriteria] = Field(None, alias="leadersCriteria")
    statistic_field: Optional[StrictStr] = Field(
        None, alias="statisticField", description="The statistic field that this qualifier is for."
    )
    comparison_field: Optional[StrictStr] = Field(
        None, alias="comparisonField", description="The statistic field to compare against."
    )
    comparison_type: Optional[StrictStr] = Field(
        None,
        alias="comparisonType",
        description="Comparison type for the qualifier >- `EQUAL` Equal >- `GREATER_THAN` Greater than >- `GREATER_THAN_EQUAL` Greater than or equal >- `LESS_THAN` Less than >- `LESS_THAN_EQUAL` Less than or equal ",
    )
    comparison_value: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="comparisonValue", description="Comparison value for the qualifier"
    )
    __properties = [
        "updated",
        "added",
        "qualifierId",
        "organizationId",
        "organization",
        "leaderCriteriaId",
        "leadersCriteria",
        "statisticField",
        "comparisonField",
        "comparisonType",
        "comparisonValue",
    ]

    @validator("comparison_type")
    def comparison_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("GREATER_THAN", "LESS_THAN", "EQUAL", "GREATER_THAN_EQUAL", "LESS_THAN_EQUAL"):
            raise ValueError(
                "must be one of enum values ('GREATER_THAN', 'LESS_THAN', 'EQUAL', 'GREATER_THAN_EQUAL', 'LESS_THAN_EQUAL')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaderQualifiersModel:
        """Create an instance of LeaderQualifiersModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "updated",
                "added",
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of leaders_criteria
        if self.leaders_criteria:
            _dict["leadersCriteria"] = self.leaders_criteria.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaderQualifiersModel:
        """Create an instance of LeaderQualifiersModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LeaderQualifiersModel.parse_obj(obj)

        _obj = LeaderQualifiersModel.parse_obj(
            {
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "qualifier_id": obj.get("qualifierId"),
                "organization_id": obj.get("organizationId"),
                "organization": LeaderQualifiersModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "leader_criteria_id": obj.get("leaderCriteriaId"),
                "leaders_criteria": LeaderQualifiersModelLeadersCriteria.from_dict(obj.get("leadersCriteria"))
                if obj.get("leadersCriteria") is not None
                else None,
                "statistic_field": obj.get("statisticField"),
                "comparison_field": obj.get("comparisonField"),
                "comparison_type": obj.get("comparisonType"),
                "comparison_value": obj.get("comparisonValue"),
            }
        )
        return _obj
