# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.images_model_organization import ImagesModelOrganization


class ImagesModel(BaseModel):
    """
    ImagesModel
    """

    image_id: Optional[StrictStr] = Field(
        None, alias="imageId", description="The unique identifier of the image record"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[ImagesModelOrganization] = None
    base_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="baseType",
        description="The object that this image relates to >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
    )
    base_id: Optional[StrictStr] = Field(
        None,
        alias="baseId",
        description="The unique identifier of the object associated with this image's record. If the `baseType` is `PERSON` then this would be the value of `personId`.",
    )
    file_type: Optional[constr(strict=True, max_length=3)] = Field(
        None, alias="fileType", description="The type of file >- `JPG` jpg >- `PNG` png >- `SVG` svg "
    )
    image_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="imageType",
        description="Upload Type >- `LOGO` Logo - Not valid for 'PERSON' baseType >- `LOGO_ALTERNATE` Logo (alternate) - Not valid for 'PERSON' baseType >- `LOGO_BACKGROUND` Stylised logo for background purposes - Not valid for 'PERSON' baseType >- `PERSON_HEAD` Head shot (shoulders and head) - Only valid for 'PERSON' baseType >- `PERSON_POSE` Person posing - Only valid for 'PERSON' baseType >- `PERSON_WAIST` Head shot from the waist up - Only valid for 'PERSON' baseType >- `TEAM_PHOTO` Team Photo - Only valid for 'ENTITY' baseType ",
    )
    secondary_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="secondaryType",
        description="If the image relates to a secondary object. Such as a photo of a person in an entity, then baseType would be PERSON and secondaryType would be ENTITY. >- None None >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `SEASON` Season ",
    )
    secondary_id: Optional[StrictStr] = Field(
        None, alias="secondaryId", description="The unique identifier of the object associated with the secondaryType"
    )
    rating: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        description="The rating given to the quality of the image.  All images are LOW by default but are set ad MEDIUM if they are large enough and have transparency.  Images are only marked as HIGH if they have been manually reviewed.  You should take your use-case into account when you go to use the image. >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium ",
    )
    url: Optional[StrictStr] = Field(
        None, description="The URL of the image. See [Images](#section/Introduction/Images) for more information."
    )
    maximum_height: Optional[StrictInt] = Field(
        None, alias="maximumHeight", description="The maximum height (in pixels) of this image."
    )
    maximum_width: Optional[StrictInt] = Field(
        None, alias="maximumWidth", description="The maximum width (in pixels) of this image."
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "imageId",
        "organizationId",
        "organization",
        "baseType",
        "baseId",
        "fileType",
        "imageType",
        "secondaryType",
        "secondaryId",
        "rating",
        "url",
        "maximumHeight",
        "maximumWidth",
        "updated",
        "added",
    ]

    @validator("base_type")
    def base_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "PERSON",
            "ENTITY",
            "ENTITYGROUP",
            "COMPETITION",
            "SEASON",
            "LEAGUE",
            "ORGANIZATION",
            "DIVISION",
            "CONFERENCE",
        ):
            raise ValueError(
                "must be one of enum values ('PERSON', 'ENTITY', 'ENTITYGROUP', 'COMPETITION', 'SEASON', 'LEAGUE', 'ORGANIZATION', 'DIVISION', 'CONFERENCE')"
            )
        return value

    @validator("file_type")
    def file_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("JPG", "PNG", "SVG"):
            raise ValueError("must be one of enum values ('JPG', 'PNG', 'SVG')")
        return value

    @validator("image_type")
    def image_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "LOGO",
            "LOGO_ALTERNATE",
            "LOGO_BACKGROUND",
            "PERSON_HEAD",
            "PERSON_WAIST",
            "PERSON_POSE",
            "TEAM_PHOTO",
        ):
            raise ValueError(
                "must be one of enum values ('LOGO', 'LOGO_ALTERNATE', 'LOGO_BACKGROUND', 'PERSON_HEAD', 'PERSON_WAIST', 'PERSON_POSE', 'TEAM_PHOTO')"
            )
        return value

    @validator("secondary_type")
    def secondary_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ENTITY", "ENTITYGROUP", "COMPETITION", "SEASON", "LEAGUE", "DIVISION", "CONFERENCE", "null"):
            raise ValueError(
                "must be one of enum values ('ENTITY', 'ENTITYGROUP', 'COMPETITION', 'SEASON', 'LEAGUE', 'DIVISION', 'CONFERENCE', 'null')"
            )
        return value

    @validator("rating")
    def rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("LOW", "MEDIUM", "HIGH"):
            raise ValueError("must be one of enum values ('LOW', 'MEDIUM', 'HIGH')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImagesModel:
        """Create an instance of ImagesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "image_id",
                "organization_id",
                "file_type",
                "rating",
                "url",
                "maximum_height",
                "maximum_width",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # set to None if secondary_type (nullable) is None
        # and __fields_set__ contains the field
        if self.secondary_type is None and "secondary_type" in self.__fields_set__:
            _dict["secondaryType"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImagesModel:
        """Create an instance of ImagesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImagesModel.parse_obj(obj)

        _obj = ImagesModel.parse_obj(
            {
                "image_id": obj.get("imageId"),
                "organization_id": obj.get("organizationId"),
                "organization": ImagesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "base_type": obj.get("baseType"),
                "base_id": obj.get("baseId"),
                "file_type": obj.get("fileType"),
                "image_type": obj.get("imageType"),
                "secondary_type": obj.get("secondaryType"),
                "secondary_id": obj.get("secondaryId"),
                "rating": obj.get("rating"),
                "url": obj.get("url"),
                "maximum_height": obj.get("maximumHeight"),
                "maximum_width": obj.get("maximumWidth"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
