# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.environmental_details import EnvironmentalDetails
from atriumsports.datacore.openapi.models.fixture_competitor import FixtureCompetitor
from atriumsports.datacore.openapi.models.fixture_participant import FixtureParticipant
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.fixtures_model_fixture_profile import FixturesModelFixtureProfile
from atriumsports.datacore.openapi.models.fixtures_model_organization import FixturesModelOrganization
from atriumsports.datacore.openapi.models.fixtures_model_round import FixturesModelRound
from atriumsports.datacore.openapi.models.fixtures_model_series import FixturesModelSeries
from atriumsports.datacore.openapi.models.fixtures_model_venue import FixturesModelVenue
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_pool import (
    SeasonFixtureStagesPoolsListModelPool,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class FixturesByEntityModel(BaseModel):
    """
    FixturesByEntityModel
    """

    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixturesModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    practice_drill_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="practiceDrillType",
        description="Practice types >- None None >- `DRILL` Drill >- `FITNESS` Fitness >- `GAME` Practice Game >- `OTHER` Other ",
    )
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this fixture given by the sport governing body",
    )
    status: Optional[constr(strict=True, max_length=100)] = Field(
        "SCHEDULED",
        description="Fixture status >- `ABANDONED` Abandoned - Fixture began but had to be stopped >- `BYE` Bye - Entity has 'rest' >- `CANCELLED` Cancelled - Cancelled - will not be played >- `CONFIRMED` Confirmed - Fixture officially completed >- `FINISHED` Finished - Fixture finished by not yet 'official' >- `IF_NEEDED` If Needed - Only played if needed >- `IN_PROGRESS` In Progress - Currently in play >- `PENDING` Pending - Ready to start >- `POSTPONED` Postponed - Will be played at a future time >- `SCHEDULED` Scheduled - Yet to be played ",
    )
    fixture_number: Optional[StrictInt] = Field(None, alias="fixtureNumber", description="Fixture number")
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the fixture in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the fixture in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    start_time_local: Optional[datetime] = Field(None, alias="startTimeLocal", description="Local start time")
    start_time_utc: Optional[datetime] = Field(
        None,
        alias="startTimeUTC",
        description="Start time (UTC). This is automatically generated based on the timezone of the venue.",
    )
    finish_recording_time_utc: Optional[datetime] = Field(
        None, alias="finishRecordingTimeUTC", description="(TO BE REMOVED) Start time (UTC) + durationFull"
    )
    finish_recording_time_local: Optional[datetime] = Field(
        None, alias="finishRecordingTimeLocal", description="(TO BE REMOVED) Start time (Local) + durationFull"
    )
    start_time_actual_utc: Optional[datetime] = Field(
        None, alias="startTimeActualUTC", description="Actual start time (UTC)"
    )
    end_time_actual_utc: Optional[datetime] = Field(None, alias="endTimeActualUTC", description="Actual end time (UTC)")
    times_unconfirmed: Optional[StrictBool] = Field(
        None, alias="timesUnconfirmed", description="Is the fixture time yet to be confirmed ?"
    )
    locked: Optional[StrictBool] = Field(None, description="Is the fixture locked (to prevent editing)?")
    placing_if_won: Optional[StrictInt] = Field(None, alias="placingIfWon", description="Place if Won?")
    placing_if_lost: Optional[StrictInt] = Field(None, alias="placingIfLost", description="Place if Lost?")
    attendance: Optional[StrictInt] = Field(None, description="Crowd attendance")
    sellout: Optional[StrictBool] = Field(None, description="Was the fixture a sellout?")
    social: Optional[SocialMedia] = None
    environmental: Optional[EnvironmentalDetails] = None
    duration: Optional[StrictInt] = Field(None, description="Length, in minutes, of the fixture")
    duration_full: Optional[StrictInt] = Field(None, alias="durationFull", description="Full duration including breaks")
    ticket_url: Optional[constr(strict=True, max_length=200)] = Field(None, alias="ticketURL", description="Ticket URL")
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    series_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="seriesCode", description="A unique code for the season series. (Unique for season)"
    )
    series: Optional[FixturesModelSeries] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    pool: Optional[SeasonFixtureStagesPoolsListModelPool] = None
    round_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    round: Optional[FixturesModelRound] = None
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    live_data_available: Optional[StrictBool] = Field(
        None, alias="liveDataAvailable", description="Is live data available?"
    )
    live_video_available: Optional[StrictBool] = Field(
        None, alias="liveVideoAvailable", description="Is live video available ?"
    )
    fixture_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    maximum_period_type_used: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="maximumPeriodTypeUsed",
        description="Maximum Period Type Used >- None None >- `EXTRA_TIME` Extra Time >- `OVERTIME` Overtime >- `REGULAR` Regular >- `SHOOTOUT` Shoot-Out ",
    )
    competitor_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="competitorType",
        description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person ",
    )
    participants: Optional[conlist(FixtureParticipant)] = Field(None, description="Array of fixture participants")
    competitors: Optional[conlist(FixtureCompetitor)] = Field(None, description="Array of fixture competitors")
    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    venue: Optional[FixturesModelVenue] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    profile_id: Optional[StrictStr] = Field(
        None, alias="profileId", description="The profile that this fixture belongs to"
    )
    fixture_profile: Optional[FixturesModelFixtureProfile] = Field(None, alias="fixtureProfile")
    include_in_standings: Optional[StrictBool] = Field(
        True, alias="includeInStandings", description="Include the fixture in the standings calculation?"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    estimated_finish_time_utc: Optional[datetime] = Field(
        None, alias="estimatedFinishTimeUTC", description="Estimated end of fixture"
    )
    feature_match: Optional[StrictBool] = Field(
        None, alias="featureMatch", description="Is this fixture a featured match?"
    )
    series_fixture_number: Optional[StrictInt] = Field(
        None, alias="seriesFixtureNumber", description="The number of the fixture in a series of fixtures"
    )
    __properties = [
        "fixtureId",
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "practiceDrillType",
        "internationalReference",
        "status",
        "fixtureNumber",
        "nameLocal",
        "nameLatin",
        "startTimeLocal",
        "startTimeUTC",
        "finishRecordingTimeUTC",
        "finishRecordingTimeLocal",
        "startTimeActualUTC",
        "endTimeActualUTC",
        "timesUnconfirmed",
        "locked",
        "placingIfWon",
        "placingIfLost",
        "attendance",
        "sellout",
        "social",
        "environmental",
        "duration",
        "durationFull",
        "ticketURL",
        "stageCode",
        "stage",
        "seriesCode",
        "series",
        "poolCode",
        "pool",
        "roundCode",
        "round",
        "roundNumber",
        "liveDataAvailable",
        "liveVideoAvailable",
        "fixtureType",
        "maximumPeriodTypeUsed",
        "competitorType",
        "participants",
        "competitors",
        "venueId",
        "venue",
        "externalId",
        "profileId",
        "fixtureProfile",
        "includeInStandings",
        "updated",
        "added",
        "estimatedFinishTimeUTC",
        "featureMatch",
        "seriesFixtureNumber",
    ]

    @validator("practice_drill_type")
    def practice_drill_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("DRILL", "GAME", "FITNESS", "OTHER", "null"):
            raise ValueError("must be one of enum values ('DRILL', 'GAME', 'FITNESS', 'OTHER', 'null')")
        return value

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "IF_NEEDED",
            "SCHEDULED",
            "BYE",
            "PENDING",
            "IN_PROGRESS",
            "FINISHED",
            "CONFIRMED",
            "POSTPONED",
            "CANCELLED",
            "ABANDONED",
        ):
            raise ValueError(
                "must be one of enum values ('IF_NEEDED', 'SCHEDULED', 'BYE', 'PENDING', 'IN_PROGRESS', 'FINISHED', 'CONFIRMED', 'POSTPONED', 'CANCELLED', 'ABANDONED')"
            )
        return value

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must be one of enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return value

    @validator("maximum_period_type_used")
    def maximum_period_type_used_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("REGULAR", "EXTRA_TIME", "OVERTIME", "SHOOTOUT", "null"):
            raise ValueError("must be one of enum values ('REGULAR', 'EXTRA_TIME', 'OVERTIME', 'SHOOTOUT', 'null')")
        return value

    @validator("competitor_type")
    def competitor_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("PERSON", "ENTITY"):
            raise ValueError("must be one of enum values ('PERSON', 'ENTITY')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturesByEntityModel:
        """Create an instance of FixturesByEntityModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "start_time_utc",
                "finish_recording_time_utc",
                "finish_recording_time_local",
                "updated",
                "added",
                "estimated_finish_time_utc",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of environmental
        if self.environmental:
            _dict["environmental"] = self.environmental.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of series
        if self.series:
            _dict["series"] = self.series.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict["pool"] = self.pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of round
        if self.round:
            _dict["round"] = self.round.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in participants (list)
        _items = []
        if self.participants:
            for _item in self.participants:
                if _item:
                    _items.append(_item.to_dict())
            _dict["participants"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in competitors (list)
        _items = []
        if self.competitors:
            for _item in self.competitors:
                if _item:
                    _items.append(_item.to_dict())
            _dict["competitors"] = _items
        # override the default output from pydantic by calling `to_dict()` of venue
        if self.venue:
            _dict["venue"] = self.venue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture_profile
        if self.fixture_profile:
            _dict["fixtureProfile"] = self.fixture_profile.to_dict()
        # set to None if practice_drill_type (nullable) is None
        # and __fields_set__ contains the field
        if self.practice_drill_type is None and "practice_drill_type" in self.__fields_set__:
            _dict["practiceDrillType"] = None

        # set to None if international_reference (nullable) is None
        # and __fields_set__ contains the field
        if self.international_reference is None and "international_reference" in self.__fields_set__:
            _dict["internationalReference"] = None

        # set to None if fixture_number (nullable) is None
        # and __fields_set__ contains the field
        if self.fixture_number is None and "fixture_number" in self.__fields_set__:
            _dict["fixtureNumber"] = None

        # set to None if name_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_local is None and "name_local" in self.__fields_set__:
            _dict["nameLocal"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if start_time_local (nullable) is None
        # and __fields_set__ contains the field
        if self.start_time_local is None and "start_time_local" in self.__fields_set__:
            _dict["startTimeLocal"] = None

        # set to None if start_time_utc (nullable) is None
        # and __fields_set__ contains the field
        if self.start_time_utc is None and "start_time_utc" in self.__fields_set__:
            _dict["startTimeUTC"] = None

        # set to None if start_time_actual_utc (nullable) is None
        # and __fields_set__ contains the field
        if self.start_time_actual_utc is None and "start_time_actual_utc" in self.__fields_set__:
            _dict["startTimeActualUTC"] = None

        # set to None if end_time_actual_utc (nullable) is None
        # and __fields_set__ contains the field
        if self.end_time_actual_utc is None and "end_time_actual_utc" in self.__fields_set__:
            _dict["endTimeActualUTC"] = None

        # set to None if placing_if_won (nullable) is None
        # and __fields_set__ contains the field
        if self.placing_if_won is None and "placing_if_won" in self.__fields_set__:
            _dict["placingIfWon"] = None

        # set to None if placing_if_lost (nullable) is None
        # and __fields_set__ contains the field
        if self.placing_if_lost is None and "placing_if_lost" in self.__fields_set__:
            _dict["placingIfLost"] = None

        # set to None if attendance (nullable) is None
        # and __fields_set__ contains the field
        if self.attendance is None and "attendance" in self.__fields_set__:
            _dict["attendance"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if environmental (nullable) is None
        # and __fields_set__ contains the field
        if self.environmental is None and "environmental" in self.__fields_set__:
            _dict["environmental"] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict["duration"] = None

        # set to None if duration_full (nullable) is None
        # and __fields_set__ contains the field
        if self.duration_full is None and "duration_full" in self.__fields_set__:
            _dict["durationFull"] = None

        # set to None if ticket_url (nullable) is None
        # and __fields_set__ contains the field
        if self.ticket_url is None and "ticket_url" in self.__fields_set__:
            _dict["ticketURL"] = None

        # set to None if stage_code (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_code is None and "stage_code" in self.__fields_set__:
            _dict["stageCode"] = None

        # set to None if series_code (nullable) is None
        # and __fields_set__ contains the field
        if self.series_code is None and "series_code" in self.__fields_set__:
            _dict["seriesCode"] = None

        # set to None if pool_code (nullable) is None
        # and __fields_set__ contains the field
        if self.pool_code is None and "pool_code" in self.__fields_set__:
            _dict["poolCode"] = None

        # set to None if round_code (nullable) is None
        # and __fields_set__ contains the field
        if self.round_code is None and "round_code" in self.__fields_set__:
            _dict["roundCode"] = None

        # set to None if round_number (nullable) is None
        # and __fields_set__ contains the field
        if self.round_number is None and "round_number" in self.__fields_set__:
            _dict["roundNumber"] = None

        # set to None if maximum_period_type_used (nullable) is None
        # and __fields_set__ contains the field
        if self.maximum_period_type_used is None and "maximum_period_type_used" in self.__fields_set__:
            _dict["maximumPeriodTypeUsed"] = None

        # set to None if participants (nullable) is None
        # and __fields_set__ contains the field
        if self.participants is None and "participants" in self.__fields_set__:
            _dict["participants"] = None

        # set to None if competitors (nullable) is None
        # and __fields_set__ contains the field
        if self.competitors is None and "competitors" in self.__fields_set__:
            _dict["competitors"] = None

        # set to None if venue_id (nullable) is None
        # and __fields_set__ contains the field
        if self.venue_id is None and "venue_id" in self.__fields_set__:
            _dict["venueId"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        # set to None if profile_id (nullable) is None
        # and __fields_set__ contains the field
        if self.profile_id is None and "profile_id" in self.__fields_set__:
            _dict["profileId"] = None

        # set to None if series_fixture_number (nullable) is None
        # and __fields_set__ contains the field
        if self.series_fixture_number is None and "series_fixture_number" in self.__fields_set__:
            _dict["seriesFixtureNumber"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturesByEntityModel:
        """Create an instance of FixturesByEntityModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixturesByEntityModel.parse_obj(obj)

        _obj = FixturesByEntityModel.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "organization_id": obj.get("organizationId"),
                "organization": FixturesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "practice_drill_type": obj.get("practiceDrillType"),
                "international_reference": obj.get("internationalReference"),
                "status": obj.get("status") if obj.get("status") is not None else "SCHEDULED",
                "fixture_number": obj.get("fixtureNumber"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "start_time_local": obj.get("startTimeLocal"),
                "start_time_utc": obj.get("startTimeUTC"),
                "finish_recording_time_utc": obj.get("finishRecordingTimeUTC"),
                "finish_recording_time_local": obj.get("finishRecordingTimeLocal"),
                "start_time_actual_utc": obj.get("startTimeActualUTC"),
                "end_time_actual_utc": obj.get("endTimeActualUTC"),
                "times_unconfirmed": obj.get("timesUnconfirmed"),
                "locked": obj.get("locked"),
                "placing_if_won": obj.get("placingIfWon"),
                "placing_if_lost": obj.get("placingIfLost"),
                "attendance": obj.get("attendance"),
                "sellout": obj.get("sellout"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "environmental": EnvironmentalDetails.from_dict(obj.get("environmental"))
                if obj.get("environmental") is not None
                else None,
                "duration": obj.get("duration"),
                "duration_full": obj.get("durationFull"),
                "ticket_url": obj.get("ticketURL"),
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "series_code": obj.get("seriesCode"),
                "series": FixturesModelSeries.from_dict(obj.get("series")) if obj.get("series") is not None else None,
                "pool_code": obj.get("poolCode"),
                "pool": SeasonFixtureStagesPoolsListModelPool.from_dict(obj.get("pool"))
                if obj.get("pool") is not None
                else None,
                "round_code": obj.get("roundCode"),
                "round": FixturesModelRound.from_dict(obj.get("round")) if obj.get("round") is not None else None,
                "round_number": obj.get("roundNumber"),
                "live_data_available": obj.get("liveDataAvailable"),
                "live_video_available": obj.get("liveVideoAvailable"),
                "fixture_type": obj.get("fixtureType"),
                "maximum_period_type_used": obj.get("maximumPeriodTypeUsed"),
                "competitor_type": obj.get("competitorType"),
                "participants": [FixtureParticipant.from_dict(_item) for _item in obj.get("participants")]
                if obj.get("participants") is not None
                else None,
                "competitors": [FixtureCompetitor.from_dict(_item) for _item in obj.get("competitors")]
                if obj.get("competitors") is not None
                else None,
                "venue_id": obj.get("venueId"),
                "venue": FixturesModelVenue.from_dict(obj.get("venue")) if obj.get("venue") is not None else None,
                "external_id": obj.get("externalId"),
                "profile_id": obj.get("profileId"),
                "fixture_profile": FixturesModelFixtureProfile.from_dict(obj.get("fixtureProfile"))
                if obj.get("fixtureProfile") is not None
                else None,
                "include_in_standings": obj.get("includeInStandings")
                if obj.get("includeInStandings") is not None
                else True,
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "estimated_finish_time_utc": obj.get("estimatedFinishTimeUTC"),
                "feature_match": obj.get("featureMatch"),
                "series_fixture_number": obj.get("seriesFixtureNumber"),
            }
        )
        return _obj
