# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator


class FixtureProgressionPostBody(BaseModel):
    """
    FixtureProgressionPostBody
    """

    fixture_id: StrictStr = Field(..., alias="fixtureId", description="Source fixtureId")
    to_fixture_id: StrictStr = Field(..., alias="toFixtureId", description="Destination fixtureId")
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    placing: Optional[StrictInt] = Field(None, description="Place after source fixture completion")
    is_home: Optional[StrictBool] = Field(
        None, alias="isHome", description="Will this competitor be the 'home' entity in the target fixture?"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = ["fixtureId", "toFixtureId", "seasonId", "placing", "isHome", "externalId"]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureProgressionPostBody:
        """Create an instance of FixtureProgressionPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureProgressionPostBody:
        """Create an instance of FixtureProgressionPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureProgressionPostBody.parse_obj(obj)

        _obj = FixtureProgressionPostBody.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "to_fixture_id": obj.get("toFixtureId"),
                "season_id": obj.get("seasonId"),
                "placing": obj.get("placing"),
                "is_home": obj.get("isHome"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
