# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr

from atriumsports.datacore.openapi.models.fixture_profiles_model_organization import FixtureProfilesModelOrganization


class FixtureProfilesModel(BaseModel):
    """
    FixtureProfilesModel
    """

    profile_id: Optional[StrictStr] = Field(None, alias="profileId", description="The unique identifier of the profile")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixtureProfilesModelOrganization] = None
    name: Optional[StrictStr] = Field(None, description="Name of the fixture profile")
    profile: Optional[Any] = None
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    default_profile: Optional[StrictBool] = Field(
        None, alias="defaultProfile", description="Is this the default profile for the organization?"
    )
    __properties = [
        "profileId",
        "organizationId",
        "organization",
        "name",
        "profile",
        "updated",
        "added",
        "defaultProfile",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureProfilesModel:
        """Create an instance of FixtureProfilesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # set to None if profile (nullable) is None
        # and __fields_set__ contains the field
        if self.profile is None and "profile" in self.__fields_set__:
            _dict["profile"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureProfilesModel:
        """Create an instance of FixtureProfilesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureProfilesModel.parse_obj(obj)

        _obj = FixtureProfilesModel.parse_obj(
            {
                "profile_id": obj.get("profileId"),
                "organization_id": obj.get("organizationId"),
                "organization": FixtureProfilesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "name": obj.get("name"),
                "profile": obj.get("profile"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "default_profile": obj.get("defaultProfile"),
            }
        )
        return _obj
