# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator


class FixturePersonsPostBody(BaseModel):
    """
    FixturePersonsPostBody
    """

    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    person_id: StrictStr = Field(..., alias="personId", description="The unique identifier of the person")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    is_home: Optional[StrictBool] = Field(None, alias="isHome", description="Is competitor the home person ?")
    draw: Optional[StrictBool] = Field(None, description="Result for this competitor was a draw ?")
    result_status: constr(strict=True, max_length=100) = Field(
        ...,
        alias="resultStatus",
        description="Result status >- `CONFIRMED` Confirmed >- `DID_NOT_FINISH` Did Not Finish >- `DID_NOT_START` Did Not Start >- `DISQUALIFIED` Disqualified >- `FORFEITED` Forfeited >- `IN_PROGRESS` In Progress >- `SCHEDULED` Scheduled >- `WITHDRAWN` Withdrawn >- `WON_BY_FORFEIT` Won By Forfeit ",
    )
    result_place: Optional[conint(strict=True)] = Field(
        None, alias="resultPlace", description="Result placing (1=Won, 2=Lost)"
    )
    starting_number: Optional[conint(strict=True)] = Field(None, alias="startingNumber", description="Starting number")
    score: Optional[constr(strict=True, max_length=100)] = Field(None, description="Score for competitor in fixture")
    secondary_score: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="secondaryScore", description="Secondary score"
    )
    is_neutral_venue: Optional[StrictBool] = Field(
        None, alias="isNeutralVenue", description="Competitor is playing at a neutral venue ?"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "fixtureId",
        "personId",
        "entityGroupId",
        "isHome",
        "draw",
        "resultStatus",
        "resultPlace",
        "startingNumber",
        "score",
        "secondaryScore",
        "isNeutralVenue",
        "externalId",
    ]

    @validator("result_status")
    def result_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "SCHEDULED",
            "IN_PROGRESS",
            "CONFIRMED",
            "DISQUALIFIED",
            "FORFEITED",
            "WON_BY_FORFEIT",
            "DID_NOT_FINISH",
            "WITHDRAWN",
            "DID_NOT_START",
        ):
            raise ValueError(
                "must be one of enum values ('SCHEDULED', 'IN_PROGRESS', 'CONFIRMED', 'DISQUALIFIED', 'FORFEITED', 'WON_BY_FORFEIT', 'DID_NOT_FINISH', 'WITHDRAWN', 'DID_NOT_START')"
            )
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePersonsPostBody:
        """Create an instance of FixturePersonsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if entity_group_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_group_id is None and "entity_group_id" in self.__fields_set__:
            _dict["entityGroupId"] = None

        # set to None if result_place (nullable) is None
        # and __fields_set__ contains the field
        if self.result_place is None and "result_place" in self.__fields_set__:
            _dict["resultPlace"] = None

        # set to None if starting_number (nullable) is None
        # and __fields_set__ contains the field
        if self.starting_number is None and "starting_number" in self.__fields_set__:
            _dict["startingNumber"] = None

        # set to None if score (nullable) is None
        # and __fields_set__ contains the field
        if self.score is None and "score" in self.__fields_set__:
            _dict["score"] = None

        # set to None if secondary_score (nullable) is None
        # and __fields_set__ contains the field
        if self.secondary_score is None and "secondary_score" in self.__fields_set__:
            _dict["secondaryScore"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePersonsPostBody:
        """Create an instance of FixturePersonsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixturePersonsPostBody.parse_obj(obj)

        _obj = FixturePersonsPostBody.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "is_home": obj.get("isHome"),
                "draw": obj.get("draw"),
                "result_status": obj.get("resultStatus"),
                "result_place": obj.get("resultPlace"),
                "starting_number": obj.get("startingNumber"),
                "score": obj.get("score"),
                "secondary_score": obj.get("secondaryScore"),
                "is_neutral_venue": obj.get("isNeutralVenue"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
