# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr

from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_person_statistics_periods_model_organization import (
    FixturePersonStatisticsPeriodsModelOrganization,
)
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture


class FixturePersonStatisticsPeriodsModel(BaseModel):
    """
    FixturePersonStatisticsPeriodsModel
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixturePersonStatisticsPeriodsModelOrganization] = None
    statistics: Optional[Dict[str, Any]] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "personId",
        "person",
        "entityId",
        "entity",
        "fixtureId",
        "fixture",
        "organizationId",
        "organization",
        "statistics",
        "periodId",
        "section",
        "updated",
        "added",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePersonStatisticsPeriodsModel:
        """Create an instance of FixturePersonStatisticsPeriodsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # set to None if entity_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_id is None and "entity_id" in self.__fields_set__:
            _dict["entityId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePersonStatisticsPeriodsModel:
        """Create an instance of FixturePersonStatisticsPeriodsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixturePersonStatisticsPeriodsModel.parse_obj(obj)

        _obj = FixturePersonStatisticsPeriodsModel.parse_obj(
            {
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": FixturePersonStatisticsPeriodsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "statistics": obj.get("statistics"),
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
