# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, validator


class FixtureParticipant(BaseModel):
    """
    FixtureParticipant
    """

    person_id: StrictStr = Field(..., alias="personId", description="The uuid of the person")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The uuid of the entity group"
    )
    is_home: Optional[StrictBool] = Field(None, alias="isHome", description="Is participant the home person ?")
    draw: Optional[StrictBool] = Field(None, description="Result for this participant was a draw ?")
    result_status: Optional[StrictStr] = Field(None, alias="resultStatus", description="Result status")
    result_place: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="resultPlace", description="Result placing (1=Won, 2=Lost)"
    )
    starting_number: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="startingNumber", description="Starting number"
    )
    score: Optional[StrictStr] = Field(None, description="Score for participant in fixture")
    secondary_score: Optional[StrictStr] = Field(None, alias="secondaryScore", description="Secondary score")
    is_neutral_venue: Optional[StrictBool] = Field(
        None, alias="isNeutralVenue", description="Participant is playing at a neutral venue ?"
    )
    external_id: Optional[StrictStr] = Field(None, alias="externalId", description="externalId")
    __properties = [
        "personId",
        "entityGroupId",
        "isHome",
        "draw",
        "resultStatus",
        "resultPlace",
        "startingNumber",
        "score",
        "secondaryScore",
        "isNeutralVenue",
        "externalId",
    ]

    @validator("result_status")
    def result_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "SCHEDULED",
            "IN_PROGRESS",
            "CONFIRMED",
            "DISQUALIFIED",
            "FORFEITED",
            "WON_BY_FORFEIT",
            "DID_NOT_FINISH",
            "WITHDRAWN",
            "DID_NOT_START",
        ):
            raise ValueError(
                "must be one of enum values ('SCHEDULED', 'IN_PROGRESS', 'CONFIRMED', 'DISQUALIFIED', 'FORFEITED', 'WON_BY_FORFEIT', 'DID_NOT_FINISH', 'WITHDRAWN', 'DID_NOT_START')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureParticipant:
        """Create an instance of FixtureParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if result_place (nullable) is None
        # and __fields_set__ contains the field
        if self.result_place is None and "result_place" in self.__fields_set__:
            _dict["resultPlace"] = None

        # set to None if starting_number (nullable) is None
        # and __fields_set__ contains the field
        if self.starting_number is None and "starting_number" in self.__fields_set__:
            _dict["startingNumber"] = None

        # set to None if score (nullable) is None
        # and __fields_set__ contains the field
        if self.score is None and "score" in self.__fields_set__:
            _dict["score"] = None

        # set to None if secondary_score (nullable) is None
        # and __fields_set__ contains the field
        if self.secondary_score is None and "secondary_score" in self.__fields_set__:
            _dict["secondaryScore"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureParticipant:
        """Create an instance of FixtureParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureParticipant.parse_obj(obj)

        _obj = FixtureParticipant.parse_obj(
            {
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "is_home": obj.get("isHome"),
                "draw": obj.get("draw"),
                "result_status": obj.get("resultStatus"),
                "result_place": obj.get("resultPlace"),
                "starting_number": obj.get("startingNumber"),
                "score": obj.get("score"),
                "secondary_score": obj.get("secondaryScore"),
                "is_neutral_venue": obj.get("isNeutralVenue"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
