# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, constr


class FixtureLiveSummaryModel(BaseModel):
    """
    FixtureLiveSummaryModel
    """

    organization_id: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    entities: Optional[Dict[str, Any]] = Field(None, description="Entity information: scores, person information, etc.")
    clock: Optional[Dict[str, Any]] = Field(None, description="Clock information")
    status: Optional[Dict[str, Any]] = Field(None, description="Status information")
    __properties = ["organizationId", "fixtureId", "entities", "clock", "status"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureLiveSummaryModel:
        """Create an instance of FixtureLiveSummaryModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureLiveSummaryModel:
        """Create an instance of FixtureLiveSummaryModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureLiveSummaryModel.parse_obj(obj)

        _obj = FixtureLiveSummaryModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "fixture_id": obj.get("fixtureId"),
                "entities": obj.get("entities"),
                "clock": obj.get("clock"),
                "status": obj.get("status"),
            }
        )
        return _obj
