# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class FixtureEntityPeriodStatisticsPostBody(BaseModel):
    """
    FixtureEntityPeriodStatisticsPostBody
    """

    entity_id: StrictStr = Field(..., alias="entityId", description="The unique identifier of the entity")
    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    statistics: Optional[Dict[str, Any]] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    __properties = ["entityId", "fixtureId", "statistics", "periodId", "section"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureEntityPeriodStatisticsPostBody:
        """Create an instance of FixtureEntityPeriodStatisticsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureEntityPeriodStatisticsPostBody:
        """Create an instance of FixtureEntityPeriodStatisticsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureEntityPeriodStatisticsPostBody.parse_obj(obj)

        _obj = FixtureEntityPeriodStatisticsPostBody.parse_obj(
            {
                "entity_id": obj.get("entityId"),
                "fixture_id": obj.get("fixtureId"),
                "statistics": obj.get("statistics"),
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
            }
        )
        return _obj
