# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_conference import FixtureEntitiesModelConference
from atriumsports.datacore.openapi.models.fixture_entities_model_division import FixtureEntitiesModelDivision
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_entities_model_organization import FixtureEntitiesModelOrganization
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture


class FixtureEntitiesModel(BaseModel):
    """
    FixtureEntitiesModel
    """

    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixtureEntitiesModelOrganization] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    conference: Optional[FixtureEntitiesModelConference] = None
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    division: Optional[FixtureEntitiesModelDivision] = None
    include_in_conference_statistics: Optional[StrictBool] = Field(
        None,
        alias="includeInConferenceStatistics",
        description="Include the statistics for this competitors in the conference statistics?",
    )
    is_home: Optional[StrictBool] = Field(None, alias="isHome", description="Is competitor the home entity ?")
    draw: Optional[StrictBool] = Field(None, description="Result for this competitor was a draw ?")
    result_status: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="resultStatus",
        description="Result status >- `CONFIRMED` Confirmed >- `DID_NOT_FINISH` Did Not Finish >- `DID_NOT_START` Did Not Start >- `DISQUALIFIED` Disqualified >- `FORFEITED` Forfeited >- `IN_PROGRESS` In Progress >- `SCHEDULED` Scheduled >- `WITHDRAWN` Withdrawn >- `WON_BY_FORFEIT` Won By Forfeit ",
    )
    result_place: Optional[conint(strict=True)] = Field(
        None, alias="resultPlace", description="Result placing (1=Won, 2=Lost)"
    )
    starting_number: Optional[conint(strict=True)] = Field(None, alias="startingNumber", description="Starting number")
    score: Optional[constr(strict=True, max_length=100)] = Field(None, description="Score for competitor in fixture")
    secondary_score: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="secondaryScore", description="Secondary score (used for shoot-outs)"
    )
    shoot_out_attempts: Optional[constr(strict=True, max_length=200)] = Field(
        None, alias="shootOutAttempts", description="Result of shoot-out attempts (1 or 0 per attempt)."
    )
    is_neutral_venue: Optional[StrictBool] = Field(
        None, alias="isNeutralVenue", description="Competitor is playing at a neutral venue ?"
    )
    roster_status: Optional[constr(strict=True, max_length=100)] = Field(
        "UNKNOWN",
        alias="rosterStatus",
        description="The status of the ENTITY fixture entities >- `APPROVED` Approved >- `PENDING` Pending >- `REJECTED` Rejected >- `SUBMITTED` Submitted >- `UNKNOWN` Unknown ",
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "fixtureId",
        "fixture",
        "organizationId",
        "organization",
        "entityId",
        "entity",
        "conferenceId",
        "conference",
        "divisionId",
        "division",
        "includeInConferenceStatistics",
        "isHome",
        "draw",
        "resultStatus",
        "resultPlace",
        "startingNumber",
        "score",
        "secondaryScore",
        "shootOutAttempts",
        "isNeutralVenue",
        "rosterStatus",
        "externalId",
        "updated",
        "added",
    ]

    @validator("result_status")
    def result_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "SCHEDULED",
            "IN_PROGRESS",
            "CONFIRMED",
            "DISQUALIFIED",
            "FORFEITED",
            "WON_BY_FORFEIT",
            "DID_NOT_FINISH",
            "WITHDRAWN",
            "DID_NOT_START",
        ):
            raise ValueError(
                "must be one of enum values ('SCHEDULED', 'IN_PROGRESS', 'CONFIRMED', 'DISQUALIFIED', 'FORFEITED', 'WON_BY_FORFEIT', 'DID_NOT_FINISH', 'WITHDRAWN', 'DID_NOT_START')"
            )
        return value

    @validator("roster_status")
    def roster_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("UNKNOWN", "SUBMITTED", "PENDING", "APPROVED", "REJECTED"):
            raise ValueError("must be one of enum values ('UNKNOWN', 'SUBMITTED', 'PENDING', 'APPROVED', 'REJECTED')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureEntitiesModel:
        """Create an instance of FixtureEntitiesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference
        if self.conference:
            _dict["conference"] = self.conference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of division
        if self.division:
            _dict["division"] = self.division.to_dict()
        # set to None if conference_id (nullable) is None
        # and __fields_set__ contains the field
        if self.conference_id is None and "conference_id" in self.__fields_set__:
            _dict["conferenceId"] = None

        # set to None if division_id (nullable) is None
        # and __fields_set__ contains the field
        if self.division_id is None and "division_id" in self.__fields_set__:
            _dict["divisionId"] = None

        # set to None if result_place (nullable) is None
        # and __fields_set__ contains the field
        if self.result_place is None and "result_place" in self.__fields_set__:
            _dict["resultPlace"] = None

        # set to None if starting_number (nullable) is None
        # and __fields_set__ contains the field
        if self.starting_number is None and "starting_number" in self.__fields_set__:
            _dict["startingNumber"] = None

        # set to None if score (nullable) is None
        # and __fields_set__ contains the field
        if self.score is None and "score" in self.__fields_set__:
            _dict["score"] = None

        # set to None if secondary_score (nullable) is None
        # and __fields_set__ contains the field
        if self.secondary_score is None and "secondary_score" in self.__fields_set__:
            _dict["secondaryScore"] = None

        # set to None if shoot_out_attempts (nullable) is None
        # and __fields_set__ contains the field
        if self.shoot_out_attempts is None and "shoot_out_attempts" in self.__fields_set__:
            _dict["shootOutAttempts"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureEntitiesModel:
        """Create an instance of FixtureEntitiesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FixtureEntitiesModel.parse_obj(obj)

        _obj = FixtureEntitiesModel.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": FixtureEntitiesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "conference_id": obj.get("conferenceId"),
                "conference": FixtureEntitiesModelConference.from_dict(obj.get("conference"))
                if obj.get("conference") is not None
                else None,
                "division_id": obj.get("divisionId"),
                "division": FixtureEntitiesModelDivision.from_dict(obj.get("division"))
                if obj.get("division") is not None
                else None,
                "include_in_conference_statistics": obj.get("includeInConferenceStatistics"),
                "is_home": obj.get("isHome"),
                "draw": obj.get("draw"),
                "result_status": obj.get("resultStatus"),
                "result_place": obj.get("resultPlace"),
                "starting_number": obj.get("startingNumber"),
                "score": obj.get("score"),
                "secondary_score": obj.get("secondaryScore"),
                "shoot_out_attempts": obj.get("shootOutAttempts"),
                "is_neutral_venue": obj.get("isNeutralVenue"),
                "roster_status": obj.get("rosterStatus") if obj.get("rosterStatus") is not None else "UNKNOWN",
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
