# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import List, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist

from atriumsports.datacore.openapi.models.error_list_model import ErrorListModel


class ErrorModel(BaseModel):
    """
    ErrorModel
    """

    code: Optional[StrictInt] = Field(
        None,
        description="HTTP Error code indicating the type of error.  If there are multiple errors, then this will be the code of the first one.",
    )
    message: Optional[StrictStr] = Field(
        None,
        description="A message indicating the reason for the error. If there are multiple errors, then this is the message for the first one.",
    )
    errors: Optional[conlist(ErrorListModel)] = None
    __properties = ["code", "message", "errors"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorModel:
        """Create an instance of ErrorModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item in self.errors:
                if _item:
                    _items.append(_item.to_dict())
            _dict["errors"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorModel:
        """Create an instance of ErrorModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorModel.parse_obj(obj)

        _obj = ErrorModel.parse_obj(
            {
                "code": obj.get("code"),
                "message": obj.get("message"),
                "errors": [ErrorListModel.from_dict(_item) for _item in obj.get("errors")]
                if obj.get("errors") is not None
                else None,
            }
        )
        return _obj
