# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.contact_details import ContactDetails
from atriumsports.datacore.openapi.models.entity_additional_details import EntityAdditionalDetails
from atriumsports.datacore.openapi.models.entity_group_address import EntityGroupAddress
from atriumsports.datacore.openapi.models.entity_group_historical_name import EntityGroupHistoricalName
from atriumsports.datacore.openapi.models.entity_group_post_body_additional_names import (
    EntityGroupPostBodyAdditionalNames,
)
from atriumsports.datacore.openapi.models.entity_group_post_body_colors import EntityGroupPostBodyColors
from atriumsports.datacore.openapi.models.entity_groups_model_organization import EntityGroupsModelOrganization
from atriumsports.datacore.openapi.models.images_model import ImagesModel
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class EntityGroupsModel(BaseModel):
    """
    EntityGroupsModel
    """

    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The unique identifier of the entity group"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[EntityGroupsModelOrganization] = None
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this entity group given by the sport governing body",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    name_full_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameFullLocal",
        description="The full name of the entity group in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    additional_names: Optional[EntityGroupPostBodyAdditionalNames] = Field(None, alias="additionalNames")
    name_full_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameFullLatin",
        description="The full name of the entity group in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    code_local: Optional[constr(strict=True, max_length=5)] = Field(
        None,
        alias="codeLocal",
        description="The code of the entity group in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    code_latin: Optional[constr(strict=True, max_length=5)] = Field(
        None,
        alias="codeLatin",
        description="The code of the entity group in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    address: Optional[EntityGroupAddress] = None
    social: Optional[SocialMedia] = None
    details: Optional[EntityAdditionalDetails] = None
    contacts: Optional[ContactDetails] = None
    colors: Optional[EntityGroupPostBodyColors] = None
    historical_names: Optional[conlist(EntityGroupHistoricalName)] = Field(
        None, alias="historicalNames", description="Array of entity group historical names"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    default_venue_id: Optional[StrictStr] = Field(
        None, alias="defaultVenueId", description="The unique identifier of the default venue"
    )
    images: Optional[conlist(ImagesModel)] = None
    __properties = [
        "entityGroupId",
        "organizationId",
        "organization",
        "internationalReference",
        "status",
        "nameFullLocal",
        "additionalNames",
        "nameFullLatin",
        "codeLocal",
        "codeLatin",
        "address",
        "social",
        "details",
        "contacts",
        "colors",
        "historicalNames",
        "externalId",
        "updated",
        "added",
        "defaultVenueId",
        "images",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityGroupsModel:
        """Create an instance of EntityGroupsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of additional_names
        if self.additional_names:
            _dict["additionalNames"] = self.additional_names.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict["details"] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contacts
        if self.contacts:
            _dict["contacts"] = self.contacts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of colors
        if self.colors:
            _dict["colors"] = self.colors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["images"] = _items
        # set to None if international_reference (nullable) is None
        # and __fields_set__ contains the field
        if self.international_reference is None and "international_reference" in self.__fields_set__:
            _dict["internationalReference"] = None

        # set to None if name_full_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_latin is None and "name_full_latin" in self.__fields_set__:
            _dict["nameFullLatin"] = None

        # set to None if code_local (nullable) is None
        # and __fields_set__ contains the field
        if self.code_local is None and "code_local" in self.__fields_set__:
            _dict["codeLocal"] = None

        # set to None if code_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.code_latin is None and "code_latin" in self.__fields_set__:
            _dict["codeLatin"] = None

        # set to None if address (nullable) is None
        # and __fields_set__ contains the field
        if self.address is None and "address" in self.__fields_set__:
            _dict["address"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if details (nullable) is None
        # and __fields_set__ contains the field
        if self.details is None and "details" in self.__fields_set__:
            _dict["details"] = None

        # set to None if contacts (nullable) is None
        # and __fields_set__ contains the field
        if self.contacts is None and "contacts" in self.__fields_set__:
            _dict["contacts"] = None

        # set to None if historical_names (nullable) is None
        # and __fields_set__ contains the field
        if self.historical_names is None and "historical_names" in self.__fields_set__:
            _dict["historicalNames"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        # set to None if default_venue_id (nullable) is None
        # and __fields_set__ contains the field
        if self.default_venue_id is None and "default_venue_id" in self.__fields_set__:
            _dict["defaultVenueId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityGroupsModel:
        """Create an instance of EntityGroupsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EntityGroupsModel.parse_obj(obj)

        _obj = EntityGroupsModel.parse_obj(
            {
                "entity_group_id": obj.get("entityGroupId"),
                "organization_id": obj.get("organizationId"),
                "organization": EntityGroupsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "international_reference": obj.get("internationalReference"),
                "status": obj.get("status"),
                "name_full_local": obj.get("nameFullLocal"),
                "additional_names": EntityGroupPostBodyAdditionalNames.from_dict(obj.get("additionalNames"))
                if obj.get("additionalNames") is not None
                else None,
                "name_full_latin": obj.get("nameFullLatin"),
                "code_local": obj.get("codeLocal"),
                "code_latin": obj.get("codeLatin"),
                "address": EntityGroupAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "details": EntityAdditionalDetails.from_dict(obj.get("details"))
                if obj.get("details") is not None
                else None,
                "contacts": ContactDetails.from_dict(obj.get("contacts")) if obj.get("contacts") is not None else None,
                "colors": EntityGroupPostBodyColors.from_dict(obj.get("colors"))
                if obj.get("colors") is not None
                else None,
                "historical_names": [EntityGroupHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "default_venue_id": obj.get("defaultVenueId"),
                "images": [ImagesModel.from_dict(_item) for _item in obj.get("images")]
                if obj.get("images") is not None
                else None,
            }
        )
        return _obj
