# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class EntityGroupHistoricalName(BaseModel):
    """
    EntityGroupHistoricalName
    """

    date_start: Optional[date] = Field(None, alias="dateStart", description="Start date")
    date_end: Optional[date] = Field(None, alias="dateEnd", description="End date")
    name_full_local: Optional[StrictStr] = Field(None, alias="nameFullLocal", description="Full name in local language")
    name_full_latin: Optional[StrictStr] = Field(
        None, alias="nameFullLatin", description="Full name in latin characters"
    )
    name_short_local: Optional[StrictStr] = Field(
        None, alias="nameShortLocal", description="Short name in local language"
    )
    name_short_latin: Optional[StrictStr] = Field(
        None, alias="nameShortLatin", description="Short name in latin characters"
    )
    name_place_local: Optional[StrictStr] = Field(
        None, alias="namePlaceLocal", description="Place name in latin characters"
    )
    __properties = [
        "dateStart",
        "dateEnd",
        "nameFullLocal",
        "nameFullLatin",
        "nameShortLocal",
        "nameShortLatin",
        "namePlaceLocal",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityGroupHistoricalName:
        """Create an instance of EntityGroupHistoricalName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if date_start (nullable) is None
        # and __fields_set__ contains the field
        if self.date_start is None and "date_start" in self.__fields_set__:
            _dict["dateStart"] = None

        # set to None if date_end (nullable) is None
        # and __fields_set__ contains the field
        if self.date_end is None and "date_end" in self.__fields_set__:
            _dict["dateEnd"] = None

        # set to None if name_full_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_local is None and "name_full_local" in self.__fields_set__:
            _dict["nameFullLocal"] = None

        # set to None if name_full_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_full_latin is None and "name_full_latin" in self.__fields_set__:
            _dict["nameFullLatin"] = None

        # set to None if name_short_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_short_local is None and "name_short_local" in self.__fields_set__:
            _dict["nameShortLocal"] = None

        # set to None if name_short_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_short_latin is None and "name_short_latin" in self.__fields_set__:
            _dict["nameShortLatin"] = None

        # set to None if name_place_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_place_local is None and "name_place_local" in self.__fields_set__:
            _dict["namePlaceLocal"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityGroupHistoricalName:
        """Create an instance of EntityGroupHistoricalName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EntityGroupHistoricalName.parse_obj(obj)

        _obj = EntityGroupHistoricalName.parse_obj(
            {
                "date_start": obj.get("dateStart"),
                "date_end": obj.get("dateEnd"),
                "name_full_local": obj.get("nameFullLocal"),
                "name_full_latin": obj.get("nameFullLatin"),
                "name_short_local": obj.get("nameShortLocal"),
                "name_short_latin": obj.get("nameShortLatin"),
                "name_place_local": obj.get("namePlaceLocal"),
            }
        )
        return _obj
