# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt


class EntityAdditionalDetails(BaseModel):
    """
    Additional detail fields
    """

    founded: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Year Founded")
    squad_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="squadValue", description="Value of Squad")
    __properties = ["founded", "squadValue"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityAdditionalDetails:
        """Create an instance of EntityAdditionalDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if founded (nullable) is None
        # and __fields_set__ contains the field
        if self.founded is None and "founded" in self.__fields_set__:
            _dict["founded"] = None

        # set to None if squad_value (nullable) is None
        # and __fields_set__ contains the field
        if self.squad_value is None and "squad_value" in self.__fields_set__:
            _dict["squadValue"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityAdditionalDetails:
        """Create an instance of EntityAdditionalDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EntityAdditionalDetails.parse_obj(obj)

        _obj = EntityAdditionalDetails.parse_obj({"founded": obj.get("founded"), "squad_value": obj.get("squadValue")})
        return _obj
