# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, constr, validator


class ConductPenaltyResult(BaseModel):
    """
    ConductPenaltyResult
    """

    penalty_type: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="penaltyType", description="Penalty type"
    )
    penalty_value: Optional[StrictInt] = Field(None, alias="penaltyValue", description="Penalty value")
    __properties = ["penaltyType", "penaltyValue"]

    @validator("penalty_type")
    def penalty_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("FINANCIAL", "WEEKS", "GAMES", "MONTHS", "YEARS"):
            raise ValueError("must be one of enum values ('FINANCIAL', 'WEEKS', 'GAMES', 'MONTHS', 'YEARS')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConductPenaltyResult:
        """Create an instance of ConductPenaltyResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if penalty_type (nullable) is None
        # and __fields_set__ contains the field
        if self.penalty_type is None and "penalty_type" in self.__fields_set__:
            _dict["penaltyType"] = None

        # set to None if penalty_value (nullable) is None
        # and __fields_set__ contains the field
        if self.penalty_value is None and "penalty_value" in self.__fields_set__:
            _dict["penaltyValue"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConductPenaltyResult:
        """Create an instance of ConductPenaltyResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConductPenaltyResult.parse_obj(obj)

        _obj = ConductPenaltyResult.parse_obj(
            {"penalty_type": obj.get("penaltyType"), "penalty_value": obj.get("penaltyValue")}
        )
        return _obj
