# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.competition_historical_name import CompetitionHistoricalName
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class CompetitionPostBody(BaseModel):
    """
    CompetitionPostBody
    """

    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    league_id: Optional[StrictStr] = Field(None, alias="leagueId", description="The unique identifier of the league")
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this competition given by the sport governing body",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: constr(strict=True, max_length=150) = Field(
        ...,
        alias="nameLocal",
        description="The name of the competition in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    event_type: Optional[constr(strict=True, max_length=30)] = Field(
        "FIXTURE",
        alias="eventType",
        description="Primary Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice ",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the competition in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    historical_names: Optional[conlist(CompetitionHistoricalName)] = Field(
        None, alias="historicalNames", description="Array of competition historical names"
    )
    age_group: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="ageGroup",
        description="The age group of the competition >- None None >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth ",
    )
    __properties = [
        "competitionId",
        "leagueId",
        "internationalReference",
        "abbreviationLocal",
        "nameLocal",
        "eventType",
        "abbreviationLatin",
        "nameLatin",
        "social",
        "externalId",
        "historicalNames",
        "ageGroup",
    ]

    @validator("event_type")
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("FIXTURE", "PRACTICE"):
            raise ValueError("must be one of enum values ('FIXTURE', 'PRACTICE')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    @validator("age_group")
    def age_group_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "JUNIOR",
            "YOUTH",
            "UNDER_15",
            "UNDER_16",
            "UNDER_17",
            "UNDER_18",
            "UNDER_19",
            "UNDER_20",
            "UNDER_21",
            "UNDER_22",
            "UNDER_23",
            "SENIOR",
            "MASTERS",
            "null",
        ):
            raise ValueError(
                "must be one of enum values ('JUNIOR', 'YOUTH', 'UNDER_15', 'UNDER_16', 'UNDER_17', 'UNDER_18', 'UNDER_19', 'UNDER_20', 'UNDER_21', 'UNDER_22', 'UNDER_23', 'SENIOR', 'MASTERS', 'null')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompetitionPostBody:
        """Create an instance of CompetitionPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # set to None if international_reference (nullable) is None
        # and __fields_set__ contains the field
        if self.international_reference is None and "international_reference" in self.__fields_set__:
            _dict["internationalReference"] = None

        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        # set to None if historical_names (nullable) is None
        # and __fields_set__ contains the field
        if self.historical_names is None and "historical_names" in self.__fields_set__:
            _dict["historicalNames"] = None

        # set to None if age_group (nullable) is None
        # and __fields_set__ contains the field
        if self.age_group is None and "age_group" in self.__fields_set__:
            _dict["ageGroup"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompetitionPostBody:
        """Create an instance of CompetitionPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompetitionPostBody.parse_obj(obj)

        _obj = CompetitionPostBody.parse_obj(
            {
                "competition_id": obj.get("competitionId"),
                "league_id": obj.get("leagueId"),
                "international_reference": obj.get("internationalReference"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "event_type": obj.get("eventType") if obj.get("eventType") is not None else "FIXTURE",
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
                "historical_names": [CompetitionHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "age_group": obj.get("ageGroup"),
            }
        )
        return _obj
