# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class CompetitionHistoricalName(BaseModel):
    """
    CompetitionHistoricalName
    """

    date_start: Optional[date] = Field(None, alias="dateStart", description="Start date")
    date_end: Optional[date] = Field(None, alias="dateEnd", description="End date")
    name_local: Optional[StrictStr] = Field(None, alias="nameLocal", description="Full name in local language")
    name_latin: Optional[StrictStr] = Field(None, alias="nameLatin", description="Full name in latin characters")
    abbreviation_local: Optional[StrictStr] = Field(
        None, alias="abbreviationLocal", description="Abbreviation in local lanuage"
    )
    abbreviation_latin: Optional[StrictStr] = Field(
        None, alias="abbreviationLatin", description="Abbreviation in latin characters"
    )
    __properties = ["dateStart", "dateEnd", "nameLocal", "nameLatin", "abbreviationLocal", "abbreviationLatin"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompetitionHistoricalName:
        """Create an instance of CompetitionHistoricalName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if date_start (nullable) is None
        # and __fields_set__ contains the field
        if self.date_start is None and "date_start" in self.__fields_set__:
            _dict["dateStart"] = None

        # set to None if date_end (nullable) is None
        # and __fields_set__ contains the field
        if self.date_end is None and "date_end" in self.__fields_set__:
            _dict["dateEnd"] = None

        # set to None if name_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_local is None and "name_local" in self.__fields_set__:
            _dict["nameLocal"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompetitionHistoricalName:
        """Create an instance of CompetitionHistoricalName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompetitionHistoricalName.parse_obj(obj)

        _obj = CompetitionHistoricalName.parse_obj(
            {
                "date_start": obj.get("dateStart"),
                "date_end": obj.get("dateEnd"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
            }
        )
        return _obj
