# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.change_log_model_organization import ChangeLogModelOrganization


class ChangeLogModel(BaseModel):
    """
    ChangeLogModel
    """

    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[ChangeLogModelOrganization] = None
    change_type: Optional[StrictStr] = Field(
        None,
        alias="changeType",
        description="The type of change >- `delete` Record Deleted >- `update` Record Updated ",
    )
    primary_type: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="primaryType", description="The primary table changed"
    )
    primary_id: Optional[StrictStr] = Field(
        None, alias="primaryId", description="The unique identifier of the primaryType"
    )
    child_type: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="childType", description="The child table changed"
    )
    change_message: Optional[Any] = Field(None, alias="changeMessage")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "organizationId",
        "organization",
        "changeType",
        "primaryType",
        "primaryId",
        "childType",
        "changeMessage",
        "added",
    ]

    @validator("change_type")
    def change_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("delete", "update"):
            raise ValueError("must be one of enum values ('delete', 'update')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChangeLogModel:
        """Create an instance of ChangeLogModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # set to None if change_message (nullable) is None
        # and __fields_set__ contains the field
        if self.change_message is None and "change_message" in self.__fields_set__:
            _dict["changeMessage"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChangeLogModel:
        """Create an instance of ChangeLogModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChangeLogModel.parse_obj(obj)

        _obj = ChangeLogModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "organization": ChangeLogModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "change_type": obj.get("changeType"),
                "primary_type": obj.get("primaryType"),
                "primary_id": obj.get("primaryId"),
                "child_type": obj.get("childType"),
                "change_message": obj.get("changeMessage"),
                "added": obj.get("added"),
            }
        )
        return _obj
