# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr

from atriumsports.datacore.openapi.models.career_person_statistics_model_organization import (
    CareerPersonStatisticsModelOrganization,
)
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson


class CareerPersonStatisticsModel(BaseModel):
    """
    CareerPersonStatisticsModel
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[CareerPersonStatisticsModelOrganization] = None
    statistics: Optional[Dict[str, Any]] = None
    __properties = ["personId", "person", "organizationId", "organization", "statistics"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CareerPersonStatisticsModel:
        """Create an instance of CareerPersonStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CareerPersonStatisticsModel:
        """Create an instance of CareerPersonStatisticsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CareerPersonStatisticsModel.parse_obj(obj)

        _obj = CareerPersonStatisticsModel.parse_obj(
            {
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": CareerPersonStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
