# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.awards_model_organization import AwardsModelOrganization
from atriumsports.datacore.openapi.models.entities_model_entity_group import EntitiesModelEntityGroup
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition


class AwardsModel(BaseModel):
    """
    AwardsModel
    """

    award_id: Optional[StrictStr] = Field(None, alias="awardId", description="The unique identifier of the award")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[AwardsModelOrganization] = None
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The person that this award is for")
    person: Optional[FixturePersonsModelPerson] = None
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this award is linked to"
    )
    entity_group: Optional[EntitiesModelEntityGroup] = Field(None, alias="entityGroup")
    entity_id: Optional[StrictStr] = Field(
        None, alias="entityId", description="The entity that this award is linked to"
    )
    entity: Optional[FixtureEntitiesModelEntity] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The competition that this award is linked to"
    )
    competition: Optional[SeasonsModelCompetition] = None
    season_id: Optional[StrictStr] = Field(
        None, alias="seasonId", description="The season that this award is linked to"
    )
    season: Optional[FixtureProgressionsModelSeason] = None
    fixture_id: Optional[StrictStr] = Field(
        None, alias="fixtureId", description="The fixture that this award is linked to"
    )
    fixture: Optional[FixtureProgressionsModelFixture] = None
    votes: Optional[StrictInt] = Field(None, description="Number of votes")
    date_from: Optional[date] = Field(None, alias="dateFrom", description="Date the award is from")
    date_to: Optional[date] = Field(None, alias="dateTo", description="Date the award is until")
    award: Optional[constr(strict=True, max_length=100)] = Field(None, description="Award")
    award_sub_type: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="awardSubType", description="Award sub type"
    )
    notes: Optional[constr(strict=True, max_length=500)] = Field(None, description="Award Notes")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "awardId",
        "organizationId",
        "organization",
        "personId",
        "person",
        "entityGroupId",
        "entityGroup",
        "entityId",
        "entity",
        "competitionId",
        "competition",
        "seasonId",
        "season",
        "fixtureId",
        "fixture",
        "votes",
        "dateFrom",
        "dateTo",
        "award",
        "awardSubType",
        "notes",
        "externalId",
        "updated",
        "added",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AwardsModel:
        """Create an instance of AwardsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity_group
        if self.entity_group:
            _dict["entityGroup"] = self.entity_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # set to None if votes (nullable) is None
        # and __fields_set__ contains the field
        if self.votes is None and "votes" in self.__fields_set__:
            _dict["votes"] = None

        # set to None if date_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_from is None and "date_from" in self.__fields_set__:
            _dict["dateFrom"] = None

        # set to None if date_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_to is None and "date_to" in self.__fields_set__:
            _dict["dateTo"] = None

        # set to None if award_sub_type (nullable) is None
        # and __fields_set__ contains the field
        if self.award_sub_type is None and "award_sub_type" in self.__fields_set__:
            _dict["awardSubType"] = None

        # set to None if notes (nullable) is None
        # and __fields_set__ contains the field
        if self.notes is None and "notes" in self.__fields_set__:
            _dict["notes"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AwardsModel:
        """Create an instance of AwardsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AwardsModel.parse_obj(obj)

        _obj = AwardsModel.parse_obj(
            {
                "award_id": obj.get("awardId"),
                "organization_id": obj.get("organizationId"),
                "organization": AwardsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "entity_group_id": obj.get("entityGroupId"),
                "entity_group": EntitiesModelEntityGroup.from_dict(obj.get("entityGroup"))
                if obj.get("entityGroup") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "votes": obj.get("votes"),
                "date_from": obj.get("dateFrom"),
                "date_to": obj.get("dateTo"),
                "award": obj.get("award"),
                "award_sub_type": obj.get("awardSubType"),
                "notes": obj.get("notes"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
