# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator


class AwardPostBody(BaseModel):
    """
    AwardPostBody
    """

    award_id: Optional[StrictStr] = Field(None, alias="awardId", description="The unique identifier of the award")
    person_id: StrictStr = Field(..., alias="personId", description="The person that this award is for")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this award is linked to"
    )
    entity_id: Optional[StrictStr] = Field(
        None, alias="entityId", description="The entity that this award is linked to"
    )
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The competition that this award is linked to"
    )
    season_id: Optional[StrictStr] = Field(
        None, alias="seasonId", description="The season that this award is linked to"
    )
    fixture_id: Optional[StrictStr] = Field(
        None, alias="fixtureId", description="The fixture that this award is linked to"
    )
    votes: Optional[StrictInt] = Field(None, description="Number of votes")
    date_from: Optional[date] = Field(None, alias="dateFrom", description="Date the award is from")
    date_to: Optional[date] = Field(None, alias="dateTo", description="Date the award is until")
    award: constr(strict=True, max_length=100) = Field(..., description="Award")
    award_sub_type: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="awardSubType", description="Award sub type"
    )
    notes: Optional[constr(strict=True, max_length=500)] = Field(None, description="Award Notes")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "awardId",
        "personId",
        "entityGroupId",
        "entityId",
        "competitionId",
        "seasonId",
        "fixtureId",
        "votes",
        "dateFrom",
        "dateTo",
        "award",
        "awardSubType",
        "notes",
        "externalId",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AwardPostBody:
        """Create an instance of AwardPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if votes (nullable) is None
        # and __fields_set__ contains the field
        if self.votes is None and "votes" in self.__fields_set__:
            _dict["votes"] = None

        # set to None if date_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_from is None and "date_from" in self.__fields_set__:
            _dict["dateFrom"] = None

        # set to None if date_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_to is None and "date_to" in self.__fields_set__:
            _dict["dateTo"] = None

        # set to None if award_sub_type (nullable) is None
        # and __fields_set__ contains the field
        if self.award_sub_type is None and "award_sub_type" in self.__fields_set__:
            _dict["awardSubType"] = None

        # set to None if notes (nullable) is None
        # and __fields_set__ contains the field
        if self.notes is None and "notes" in self.__fields_set__:
            _dict["notes"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AwardPostBody:
        """Create an instance of AwardPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AwardPostBody.parse_obj(obj)

        _obj = AwardPostBody.parse_obj(
            {
                "award_id": obj.get("awardId"),
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "entity_id": obj.get("entityId"),
                "competition_id": obj.get("competitionId"),
                "season_id": obj.get("seasonId"),
                "fixture_id": obj.get("fixtureId"),
                "votes": obj.get("votes"),
                "date_from": obj.get("dateFrom"),
                "date_to": obj.get("dateTo"),
                "award": obj.get("award"),
                "award_sub_type": obj.get("awardSubType"),
                "notes": obj.get("notes"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
