# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import date, datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.season_post_body import SeasonPostBody
from atriumsports.datacore.openapi.models.season_put_body import SeasonPutBody
from atriumsports.datacore.openapi.models.seasons_response import SeasonsResponse

logger = logging.getLogger("openapi")


class SeasonsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def season_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Delete a season  # noqa: E501

        Delete a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_delete(organization_id, season_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_delete_with_http_info(
                organization_id, season_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_delete: %s\n" % e)
            raise

    @validate_arguments
    def season_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a season  # noqa: E501

        Delete a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_delete_with_http_info(organization_id, season_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Get a season  # noqa: E501

        Return detailed information about a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_detail(organization_id, season_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_detail_with_http_info(
                organization_id, season_id, sport, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_detail: %s\n" % e)
            raise

    @validate_arguments
    def season_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a season  # noqa: E501

        Return detailed information about a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_detail_with_http_info(organization_id, season_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_insert(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_post_body: SeasonPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Create a new season  # noqa: E501

        Add a new season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_insert(competition_id, organization_id, sport, season_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_post_body: (required)
        :type season_post_body: SeasonPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_insert_with_http_info(
                competition_id, organization_id, sport, season_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_insert: %s\n" % e)
            raise

    @validate_arguments
    def season_insert_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_post_body: SeasonPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a new season  # noqa: E501

        Add a new season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_insert_with_http_info(competition_id, organization_id, sport, season_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_post_body: (required)
        :type season_post_body: SeasonPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "organization_id",
            "sport",
            "season_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["season_post_body"] is not None:
            _body_params = _params["season_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/competitions/{competitionId}/seasons",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_list(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        end_date: Annotated[Optional[date], Field(description="endDate on or before this date")] = None,
        event_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        gender: Annotated[
            Optional[StrictStr],
            Field(
                description="The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        name_latin_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match"
            ),
        ] = None,
        name_local_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match"
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        start_date: Annotated[Optional[date], Field(description="startDate on or after this date")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_production: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None "
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Get a list of seasons  # noqa: E501

        Return a list of seasons in the competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_list(competition_id, organization_id, sport, added, age_group, end_date, event_type, external, fields, gender, hide_null, include, limit, name_latin_contains, name_local_contains, offset, representation, season_type, sort_by, standard, start_date, status, updated, video_production, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param end_date: endDate on or before this date
        :type end_date: date
        :param event_type: Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice
        :type event_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param gender: The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown
        :type gender: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param name_latin_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match
        :type name_latin_contains: str
        :param name_local_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match
        :type name_local_contains: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param start_date: startDate on or after this date
        :type start_date: date
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_production: Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None
        :type video_production: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_list_with_http_info(
                competition_id,
                organization_id,
                sport,
                added,
                age_group,
                end_date,
                event_type,
                external,
                fields,
                gender,
                hide_null,
                include,
                limit,
                name_latin_contains,
                name_local_contains,
                offset,
                representation,
                season_type,
                sort_by,
                standard,
                start_date,
                status,
                updated,
                video_production,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_list: %s\n" % e)
            raise

    @validate_arguments
    def season_list_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        end_date: Annotated[Optional[date], Field(description="endDate on or before this date")] = None,
        event_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        gender: Annotated[
            Optional[StrictStr],
            Field(
                description="The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        name_latin_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match"
            ),
        ] = None,
        name_local_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match"
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        start_date: Annotated[Optional[date], Field(description="startDate on or after this date")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_production: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None "
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of seasons  # noqa: E501

        Return a list of seasons in the competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_list_with_http_info(competition_id, organization_id, sport, added, age_group, end_date, event_type, external, fields, gender, hide_null, include, limit, name_latin_contains, name_local_contains, offset, representation, season_type, sort_by, standard, start_date, status, updated, video_production, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param end_date: endDate on or before this date
        :type end_date: date
        :param event_type: Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice
        :type event_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param gender: The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown
        :type gender: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param name_latin_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match
        :type name_latin_contains: str
        :param name_local_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match
        :type name_local_contains: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param start_date: startDate on or after this date
        :type start_date: date
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_production: Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None
        :type video_production: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "organization_id",
            "sport",
            "added",
            "age_group",
            "end_date",
            "event_type",
            "external",
            "fields",
            "gender",
            "hide_null",
            "include",
            "limit",
            "name_latin_contains",
            "name_local_contains",
            "offset",
            "representation",
            "season_type",
            "sort_by",
            "standard",
            "start_date",
            "status",
            "updated",
            "video_production",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("age_group") is not None:  # noqa: E501
            _query_params.append(("ageGroup", _params["age_group"].value))

        if _params.get("end_date") is not None:  # noqa: E501
            if isinstance(_params["end_date"], datetime):
                _query_params.append(
                    ("endDate", _params["end_date"].strftime(self.api_client.configuration.date_format))
                )
            else:
                _query_params.append(("endDate", _params["end_date"]))

        if _params.get("event_type") is not None:  # noqa: E501
            _query_params.append(("eventType", _params["event_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("gender") is not None:  # noqa: E501
            _query_params.append(("gender", _params["gender"].value))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("name_latin_contains") is not None:  # noqa: E501
            _query_params.append(("nameLatinContains", _params["name_latin_contains"]))

        if _params.get("name_local_contains") is not None:  # noqa: E501
            _query_params.append(("nameLocalContains", _params["name_local_contains"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("representation") is not None:  # noqa: E501
            _query_params.append(("representation", _params["representation"].value))

        if _params.get("season_type") is not None:  # noqa: E501
            _query_params.append(("seasonType", _params["season_type"].value))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("standard") is not None:  # noqa: E501
            _query_params.append(("standard", _params["standard"].value))

        if _params.get("start_date") is not None:  # noqa: E501
            if isinstance(_params["start_date"], datetime):
                _query_params.append(
                    ("startDate", _params["start_date"].strftime(self.api_client.configuration.date_format))
                )
            else:
                _query_params.append(("startDate", _params["start_date"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("video_production") is not None:  # noqa: E501
            _query_params.append(("videoProduction", _params["video_production"].value))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/competitions/{competitionId}/seasons",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_list_by_organization(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        end_date: Annotated[Optional[date], Field(description="endDate on or before this date")] = None,
        event_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        gender: Annotated[
            Optional[StrictStr],
            Field(
                description="The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        name_latin_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match"
            ),
        ] = None,
        name_local_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match"
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        start_date: Annotated[Optional[date], Field(description="startDate on or after this date")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_production: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None "
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Get a list of seasons for an organization  # noqa: E501

        Return a list of seasons in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_list_by_organization(organization_id, sport, added, age_group, competition_id, end_date, event_type, external, fields, gender, hide_null, include, limit, name_latin_contains, name_local_contains, offset, representation, season_type, sort_by, standard, start_date, status, updated, video_production, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param end_date: endDate on or before this date
        :type end_date: date
        :param event_type: Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice
        :type event_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param gender: The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown
        :type gender: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param name_latin_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match
        :type name_latin_contains: str
        :param name_local_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match
        :type name_local_contains: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param start_date: startDate on or after this date
        :type start_date: date
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_production: Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None
        :type video_production: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_list_by_organization_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_list_by_organization_with_http_info(
                organization_id,
                sport,
                added,
                age_group,
                competition_id,
                end_date,
                event_type,
                external,
                fields,
                gender,
                hide_null,
                include,
                limit,
                name_latin_contains,
                name_local_contains,
                offset,
                representation,
                season_type,
                sort_by,
                standard,
                start_date,
                status,
                updated,
                video_production,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_list_by_organization: %s\n" % e)
            raise

    @validate_arguments
    def season_list_by_organization_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        end_date: Annotated[Optional[date], Field(description="endDate on or before this date")] = None,
        event_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        gender: Annotated[
            Optional[StrictStr],
            Field(
                description="The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        name_latin_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match"
            ),
        ] = None,
        name_local_contains: Annotated[
            Optional[constr(strict=True, max_length=50, min_length=2)],
            Field(
                description="Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match"
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        start_date: Annotated[Optional[date], Field(description="startDate on or after this date")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_production: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None "
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of seasons for an organization  # noqa: E501

        Return a list of seasons in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_list_by_organization_with_http_info(organization_id, sport, added, age_group, competition_id, end_date, event_type, external, fields, gender, hide_null, include, limit, name_latin_contains, name_local_contains, offset, representation, season_type, sort_by, standard, start_date, status, updated, video_production, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param end_date: endDate on or before this date
        :type end_date: date
        :param event_type: Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice
        :type event_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param gender: The gender of the season or entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown
        :type gender: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param name_latin_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLatin=David Johnson nameLatinContains=Dav will match nameLatinContains=John will match nameLatinContains=son will not match
        :type name_latin_contains: str
        :param name_local_contains: Fields that allow a 'Contains' query string parameter search for words separated by a space, matching characters left to right. Example: nameLocal=David Johnson nameLocalContains=Dav will match nameLocalContains=John will match nameLocalContains=son will not match
        :type name_local_contains: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param start_date: startDate on or after this date
        :type start_date: date
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_production: Data synchronization strategy with video production systems. Multiple allowed (comma-delimited). >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None
        :type video_production: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "age_group",
            "competition_id",
            "end_date",
            "event_type",
            "external",
            "fields",
            "gender",
            "hide_null",
            "include",
            "limit",
            "name_latin_contains",
            "name_local_contains",
            "offset",
            "representation",
            "season_type",
            "sort_by",
            "standard",
            "start_date",
            "status",
            "updated",
            "video_production",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_list_by_organization" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("age_group") is not None:  # noqa: E501
            _query_params.append(("ageGroup", _params["age_group"].value))

        if _params.get("competition_id") is not None:  # noqa: E501
            _query_params.append(("competitionId", _params["competition_id"]))

        if _params.get("end_date") is not None:  # noqa: E501
            if isinstance(_params["end_date"], datetime):
                _query_params.append(
                    ("endDate", _params["end_date"].strftime(self.api_client.configuration.date_format))
                )
            else:
                _query_params.append(("endDate", _params["end_date"]))

        if _params.get("event_type") is not None:  # noqa: E501
            _query_params.append(("eventType", _params["event_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("gender") is not None:  # noqa: E501
            _query_params.append(("gender", _params["gender"].value))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("name_latin_contains") is not None:  # noqa: E501
            _query_params.append(("nameLatinContains", _params["name_latin_contains"]))

        if _params.get("name_local_contains") is not None:  # noqa: E501
            _query_params.append(("nameLocalContains", _params["name_local_contains"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("representation") is not None:  # noqa: E501
            _query_params.append(("representation", _params["representation"].value))

        if _params.get("season_type") is not None:  # noqa: E501
            _query_params.append(("seasonType", _params["season_type"].value))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("standard") is not None:  # noqa: E501
            _query_params.append(("standard", _params["standard"].value))

        if _params.get("start_date") is not None:  # noqa: E501
            if isinstance(_params["start_date"], datetime):
                _query_params.append(
                    ("startDate", _params["start_date"].strftime(self.api_client.configuration.date_format))
                )
            else:
                _query_params.append(("startDate", _params["start_date"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("video_production") is not None:  # noqa: E501
            _query_params.append(("videoProduction", _params["video_production"].value))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_put_body: SeasonPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SeasonsResponse:  # noqa: E501
        """Update a season  # noqa: E501

        Change the information of a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_update(organization_id, season_id, sport, season_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_put_body: (required)
        :type season_put_body: SeasonPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_update_with_http_info(
                organization_id, season_id, sport, season_put_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonsApi->season_update: %s\n" % e)
            raise

    @validate_arguments
    def season_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_put_body: SeasonPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update a season  # noqa: E501

        Change the information of a specific season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_update_with_http_info(organization_id, season_id, sport, season_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_put_body: (required)
        :type season_put_body: SeasonPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "season_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["season_put_body"] is not None:
            _body_params = _params["season_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
