# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.role_post_body import RolePostBody
from atriumsports.datacore.openapi.models.role_put_body import RolePutBody
from atriumsports.datacore.openapi.models.roles_response import RolesResponse

logger = logging.getLogger("openapi")


class RolesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def role_all_delete(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Delete all a role  # noqa: E501

        Delete all role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.role_all_delete(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the role_all_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.role_all_delete_with_http_info(
                fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->role_all_delete: %s\n" % e)
            raise

    @validate_arguments
    def role_all_delete_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete all a role  # noqa: E501

        Delete all role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.role_all_delete_with_http_info(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method role_all_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/roles",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def role_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Delete a role  # noqa: E501

        Delete a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.role_delete(organization_id, role_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the role_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.role_delete_with_http_info(
                organization_id, role_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->role_delete: %s\n" % e)
            raise

    @validate_arguments
    def role_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a role  # noqa: E501

        Delete a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.role_delete_with_http_info(organization_id, role_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "role_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method role_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["role_id"]:
            _path_params["roleId"] = _params["role_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles/{roleId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Get a role  # noqa: E501

        Return detailed information about a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_detail(organization_id, role_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_detail_with_http_info(
                organization_id, role_id, sport, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_detail: %s\n" % e)
            raise

    @validate_arguments
    def roles_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a role  # noqa: E501

        Return detailed information about a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_detail_with_http_info(organization_id, role_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "role_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method roles_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["role_id"]:
            _path_params["roleId"] = _params["role_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles/{roleId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        role_post_body: RolePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Create a role  # noqa: E501

        Add a new role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_insert(organization_id, sport, role_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param role_post_body: (required)
        :type role_post_body: RolePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_insert_with_http_info(
                organization_id, sport, role_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_insert: %s\n" % e)
            raise

    @validate_arguments
    def roles_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        role_post_body: RolePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a role  # noqa: E501

        Add a new role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_insert_with_http_info(organization_id, sport, role_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param role_post_body: (required)
        :type role_post_body: RolePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "sport", "role_post_body", "external", "fields", "hide_null", "include"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method roles_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["role_post_body"] is not None:
            _body_params = _params["role_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_list_by_fixture(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Get a list of roles in a fixture  # noqa: E501

        Return a list of roles for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_by_fixture(fixture_id, organization_id, sport, added, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, status, updated, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_list_by_fixture_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_list_by_fixture_with_http_info(
                fixture_id,
                organization_id,
                sport,
                added,
                entity_id,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                role,
                status,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_list_by_fixture: %s\n" % e)
            raise

    @validate_arguments
    def roles_list_by_fixture_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of roles in a fixture  # noqa: E501

        Return a list of roles for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_by_fixture_with_http_info(fixture_id, organization_id, sport, added, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, status, updated, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "added",
            "entity_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "role",
            "status",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method roles_list_by_fixture" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("role") is not None:  # noqa: E501
            _query_params.append(("role", _params["role"].value))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/roles",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_list_fixtures(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Get a list of fixture roles  # noqa: E501

        Return a list of roles for the organization (linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_fixtures(organization_id, sport, added, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, season_id, status, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_list_fixtures_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_list_fixtures_with_http_info(
                organization_id,
                sport,
                added,
                entity_id,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                role,
                season_id,
                status,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_list_fixtures: %s\n" % e)
            raise

    @validate_arguments
    def roles_list_fixtures_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixture roles  # noqa: E501

        Return a list of roles for the organization (linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_fixtures_with_http_info(organization_id, sport, added, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, season_id, status, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "entity_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "role",
            "season_id",
            "status",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method roles_list_fixtures" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("role") is not None:  # noqa: E501
            _query_params.append(("role", _params["role"].value))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles/in/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_list_non_fixtures(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Get a list of non-fixture roles  # noqa: E501

        Return a list of roles for the organization (not linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_non_fixtures(organization_id, sport, added, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, season_id, status, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_list_non_fixtures_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_list_non_fixtures_with_http_info(
                organization_id,
                sport,
                added,
                date_from_end,
                date_from_start,
                date_to_end,
                date_to_start,
                entity_id,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                role,
                season_id,
                status,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_list_non_fixtures: %s\n" % e)
            raise

    @validate_arguments
    def roles_list_non_fixtures_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        role: Annotated[
            Optional[StrictStr],
            Field(
                description="Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        status: Annotated[
            Optional[StrictStr],
            Field(description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of non-fixture roles  # noqa: E501

        Return a list of roles for the organization (not linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_list_non_fixtures_with_http_info(organization_id, sport, added, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, role, season_id, status, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param role: Role. Can specify multiple values delimited by comma. >- `ASSISTANT_REFEREE_1` Assistant Referee 1 >- `ASSISTANT_REFEREE_2` Assistant Referee 2 >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strength and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DELEGATE` Delegate >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MATCH_SUPERVISOR` Match Supervisor >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_OBSERVER` Referee Observer >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SCORER` Scorer >- `SCORER_ASSISTANT` Assistant Scorer >- `SCOUT_1` Scout 1 >- `SCOUT_2` Scout 2 >- `SCOUT_SUPERVISOR` Scout Supervisor >- `SECRETARY` Secretary >- `SHOT_CLOCK_OPERATOR` Shot Clock Operator >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TIMER` Timer >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assistant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_1` Umpire 1 >- `UMPIRE_2` Umpire 2 >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT)
        :type role: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param status: Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending
        :type status: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "date_from_end",
            "date_from_start",
            "date_to_end",
            "date_to_start",
            "entity_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "role",
            "season_id",
            "status",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method roles_list_non_fixtures" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("date_from_end") is not None:  # noqa: E501
            if isinstance(_params["date_from_end"], datetime):
                _query_params.append(
                    ("dateFromEnd", _params["date_from_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateFromEnd", _params["date_from_end"]))

        if _params.get("date_from_start") is not None:  # noqa: E501
            if isinstance(_params["date_from_start"], datetime):
                _query_params.append(
                    (
                        "dateFromStart",
                        _params["date_from_start"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("dateFromStart", _params["date_from_start"]))

        if _params.get("date_to_end") is not None:  # noqa: E501
            if isinstance(_params["date_to_end"], datetime):
                _query_params.append(
                    ("dateToEnd", _params["date_to_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToEnd", _params["date_to_end"]))

        if _params.get("date_to_start") is not None:  # noqa: E501
            if isinstance(_params["date_to_start"], datetime):
                _query_params.append(
                    ("dateToStart", _params["date_to_start"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToStart", _params["date_to_start"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("role") is not None:  # noqa: E501
            _query_params.append(("role", _params["role"].value))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def roles_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        role_put_body: RolePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> RolesResponse:  # noqa: E501
        """Update a role  # noqa: E501

        Change the information of a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_update(organization_id, role_id, sport, role_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param role_put_body: (required)
        :type role_put_body: RolePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RolesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the roles_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.roles_update_with_http_info(
                organization_id, role_id, sport, role_put_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling RolesApi->roles_update: %s\n" % e)
            raise

    @validate_arguments
    def roles_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        role_id: Annotated[StrictStr, Field(..., description="The unique identifier of the role")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        role_put_body: RolePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update a role  # noqa: E501

        Change the information of a specific role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.roles_update_with_http_info(organization_id, role_id, sport, role_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param role_id: The unique identifier of the role (required)
        :type role_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param role_put_body: (required)
        :type role_put_body: RolePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RolesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "role_id",
            "sport",
            "role_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method roles_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["role_id"]:
            _path_params["roleId"] = _params["role_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["role_put_body"] is not None:
            _body_params = _params["role_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "RolesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/roles/{roleId}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
