# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.game_log_person_response import GameLogPersonResponse

logger = logging.getLogger("openapi")


class PersonFixtureHistoryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def gamelog_listperson(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> GameLogPersonResponse:  # noqa: E501
        """Fixture History for a person  # noqa: E501

        Return the Fixture History (based on statistics present) for a specific person in a season.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gamelog_listperson(organization_id, person_id, season_id, sport, added, entity_id, external, fields, fixture_type, hide_null, home_away, include, is_player, is_team_official, limit, offset, starter, updated, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GameLogPersonResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the gamelog_listperson_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.gamelog_listperson_with_http_info(
                organization_id,
                person_id,
                season_id,
                sport,
                added,
                entity_id,
                external,
                fields,
                fixture_type,
                hide_null,
                home_away,
                include,
                is_player,
                is_team_official,
                limit,
                offset,
                starter,
                updated,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling PersonFixtureHistoryApi->gamelog_listperson: %s\n" % e)
            raise

    @validate_arguments
    def gamelog_listperson_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Fixture History for a person  # noqa: E501

        Return the Fixture History (based on statistics present) for a specific person in a season.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gamelog_listperson_with_http_info(organization_id, person_id, season_id, sport, added, entity_id, external, fields, fixture_type, hide_null, home_away, include, is_player, is_team_official, limit, offset, starter, updated, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GameLogPersonResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "person_id",
            "season_id",
            "sport",
            "added",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "home_away",
            "include",
            "is_player",
            "is_team_official",
            "limit",
            "offset",
            "starter",
            "updated",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method gamelog_listperson" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["person_id"]:
            _path_params["personId"] = _params["person_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("is_player") is not None:  # noqa: E501
            _query_params.append(("isPlayer", _params["is_player"]))

        if _params.get("is_team_official") is not None:  # noqa: E501
            _query_params.append(("isTeamOfficial", _params["is_team_official"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("starter") is not None:  # noqa: E501
            _query_params.append(("starter", _params["starter"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"].value))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "GameLogPersonResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/{personId}/in/fixtures/seasons/{seasonId}/history",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
