# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional, Union

from pydantic import (
    Field,
    StrictBool,
    StrictBytes,
    StrictInt,
    StrictStr,
    ValidationError,
    conint,
    constr,
    validate_arguments,
)
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.images_post_body import ImagesPostBody
from atriumsports.datacore.openapi.models.images_put_body import ImagesPutBody
from atriumsports.datacore.openapi.models.images_response import ImagesResponse

logger = logging.getLogger("openapi")


class ImagesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def images_delete(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Delete an image  # noqa: E501

        Delete an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_delete(image_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_delete_with_http_info(
                image_id, organization_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_delete: %s\n" % e)
            raise

    @validate_arguments
    def images_delete_with_http_info(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete an image  # noqa: E501

        Delete an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_delete_with_http_info(image_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "image_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["image_id"]:
            _path_params["imageId"] = _params["image_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/{imageId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_detail(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get an image  # noqa: E501

        Return detailed information about a specific image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_detail(image_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_detail_with_http_info(
                image_id, organization_id, sport, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_detail: %s\n" % e)
            raise

    @validate_arguments
    def images_detail_with_http_info(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get an image  # noqa: E501

        Return detailed information about a specific image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_detail_with_http_info(image_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "image_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["image_id"]:
            _path_params["imageId"] = _params["image_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/{imageId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image  # noqa: E501

         You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert(base_id, base_type, image_type, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_with_http_info(
                base_id,
                base_type,
                image_type,
                organization_id,
                sport,
                body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image  # noqa: E501

         You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_with_http_info(base_id, base_type, image_type, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "image_type",
            "organization_id",
            "sport",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}/{imageType}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert_from_url(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image from a URL  # noqa: E501

        This method allows a new image to uploaded by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_from_url(base_id, base_type, image_type, organization_id, sport, images_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_from_url_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_from_url_with_http_info(
                base_id,
                base_type,
                image_type,
                organization_id,
                sport,
                images_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert_from_url: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_from_url_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image from a URL  # noqa: E501

        This method allows a new image to uploaded by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_from_url_with_http_info(base_id, base_type, image_type, organization_id, sport, images_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "image_type",
            "organization_id",
            "sport",
            "images_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_insert_from_url" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["images_post_body"] is not None:
            _body_params = _params["images_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}/{imageType}/fromURL",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert_organization(
        self,
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image for the organization  # noqa: E501

        Add a new image for the organization. You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_organization(image_type, organization_id, sport, body, base_type, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_organization_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_organization_with_http_info(
                image_type, organization_id, sport, body, base_type, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert_organization: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_organization_with_http_info(
        self,
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image for the organization  # noqa: E501

        Add a new image for the organization. You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_organization_with_http_info(image_type, organization_id, sport, body, base_type, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "image_type",
            "organization_id",
            "sport",
            "body",
            "base_type",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_insert_organization" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("base_type") is not None:  # noqa: E501
            _query_params.append(("baseType", _params["base_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/ORGANIZATION/{imageType}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert_organization_from_url(
        self,
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image for the organization from a URL  # noqa: E501

        This method allows a new image to be uploaded against the organization type by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_organization_from_url(image_type, organization_id, sport, images_post_body, base_type, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_organization_from_url_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_organization_from_url_with_http_info(
                image_type,
                organization_id,
                sport,
                images_post_body,
                base_type,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert_organization_from_url: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_organization_from_url_with_http_info(
        self,
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image for the organization from a URL  # noqa: E501

        This method allows a new image to be uploaded against the organization type by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_organization_from_url_with_http_info(image_type, organization_id, sport, images_post_body, base_type, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "image_type",
            "organization_id",
            "sport",
            "images_post_body",
            "base_type",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_insert_organization_from_url" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("base_type") is not None:  # noqa: E501
            _query_params.append(("baseType", _params["base_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["images_post_body"] is not None:
            _body_params = _params["images_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/ORGANIZATION/{imageType}/fromURL",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert_secondary(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image in a secondary type  # noqa: E501

        Add a new image for a type in a secondary type. You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_secondary(base_id, base_type, image_type, organization_id, secondary_id, secondary_type, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_secondary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_secondary_with_http_info(
                base_id,
                base_type,
                image_type,
                organization_id,
                secondary_id,
                secondary_type,
                sport,
                body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert_secondary: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_secondary_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Union[StrictBytes, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image in a secondary type  # noqa: E501

        Add a new image for a type in a secondary type. You can upload the image in one of two ways:  - A binary blob in the POST data - A 'file' field in a multipart/form-data   **Binary Blob**  Upload the image by supplying the image as binary in the POST data.  The HTTP request would look like      POST /v1/basketball/o/b1a23/images/for/PERSON/81814d2c-d640-11e8-9f8b-f2801f1b9fd1/PERSON_HEAD     Host: example.com     Authorization: Bearer some-token     Content-Length: 808     Content-Type: image/png      [file content goes there]   **Multi-part form**  Upload the image by supplying it as a 'file' field in a multipart form. The file field must be called `filedata` and the content-type must be set to `multipart/form-data`  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_secondary_with_http_info(base_id, base_type, image_type, organization_id, secondary_id, secondary_type, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: bytearray
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "image_type",
            "organization_id",
            "secondary_id",
            "secondary_type",
            "sport",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_insert_secondary" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["secondary_id"]:
            _path_params["secondaryId"] = _params["secondary_id"]

        if _params["secondary_type"]:
            _path_params["secondaryType"] = _params["secondary_type"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}/in/{secondaryType}/{secondaryId}/{imageType}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_insert_secondary_from_url(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Upload a new image in a secondary type from a URL  # noqa: E501

        This method allows a new image to be uploaded against a secondary type by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_secondary_from_url(base_id, base_type, image_type, organization_id, secondary_id, secondary_type, sport, images_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_insert_secondary_from_url_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_insert_secondary_from_url_with_http_info(
                base_id,
                base_type,
                image_type,
                organization_id,
                secondary_id,
                secondary_type,
                sport,
                images_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_insert_secondary_from_url: %s\n" % e)
            raise

    @validate_arguments
    def images_insert_secondary_from_url_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        image_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_post_body: ImagesPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Upload a new image in a secondary type from a URL  # noqa: E501

        This method allows a new image to be uploaded against a secondary type by providing a URL where the image can be downloaded from.  **Note**: By uploading the image you confirm that you have the legal right to do so and to allow this image to be distributed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_insert_secondary_from_url_with_http_info(base_id, base_type, image_type, organization_id, secondary_id, secondary_type, sport, images_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo  (required)
        :type image_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_post_body: (required)
        :type images_post_body: ImagesPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "image_type",
            "organization_id",
            "secondary_id",
            "secondary_type",
            "sport",
            "images_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_insert_secondary_from_url" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["image_type"]:
            _path_params["imageType"] = _params["image_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["secondary_id"]:
            _path_params["secondaryId"] = _params["secondary_id"]

        if _params["secondary_type"]:
            _path_params["secondaryType"] = _params["secondary_type"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["images_post_body"] is not None:
            _body_params = _params["images_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}/in/{secondaryType}/{secondaryId}/{imageType}/fromURL",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_list(
        self,
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get a list of images  # noqa: E501

        Return a list of images for the type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list(base_type, organization_id, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_list_with_http_info(
                base_type,
                organization_id,
                sport,
                added,
                external,
                fields,
                hide_null,
                image_type,
                include,
                limit,
                offset,
                rating,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_list: %s\n" % e)
            raise

    @validate_arguments
    def images_list_with_http_info(
        self,
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of images  # noqa: E501

        Return a list of images for the type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_with_http_info(base_type, organization_id, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_type",
            "organization_id",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "image_type",
            "include",
            "limit",
            "offset",
            "rating",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("image_type") is not None:  # noqa: E501
            _query_params.append(("imageType", _params["image_type"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("rating") is not None:  # noqa: E501
            _query_params.append(("rating", _params["rating"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_list_id(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get a list of images for a specific type and id  # noqa: E501

        Return a list of images for the type and id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_id(base_id, base_type, organization_id, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_list_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_list_id_with_http_info(
                base_id,
                base_type,
                organization_id,
                sport,
                added,
                external,
                fields,
                hide_null,
                image_type,
                include,
                limit,
                offset,
                rating,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_list_id: %s\n" % e)
            raise

    @validate_arguments
    def images_list_id_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of images for a specific type and id  # noqa: E501

        Return a list of images for the type and id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_id_with_http_info(base_id, base_type, organization_id, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "organization_id",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "image_type",
            "include",
            "limit",
            "offset",
            "rating",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_list_id" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("image_type") is not None:  # noqa: E501
            _query_params.append(("imageType", _params["image_type"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("rating") is not None:  # noqa: E501
            _query_params.append(("rating", _params["rating"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_list_id_secondary(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get a list of images for a specific base and secondary id  # noqa: E501

        Return a list of images for the base id for a secondary id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_id_secondary(base_id, base_type, organization_id, secondary_id, secondary_type, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_list_id_secondary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_list_id_secondary_with_http_info(
                base_id,
                base_type,
                organization_id,
                secondary_id,
                secondary_type,
                sport,
                added,
                external,
                fields,
                hide_null,
                image_type,
                include,
                limit,
                offset,
                rating,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_list_id_secondary: %s\n" % e)
            raise

    @validate_arguments
    def images_list_id_secondary_with_http_info(
        self,
        base_id: Annotated[
            StrictStr, Field(..., description="The unique identifier of the object associated with this image record")
        ],
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of images for a specific base and secondary id  # noqa: E501

        Return a list of images for the base id for a secondary id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_id_secondary_with_http_info(base_id, base_type, organization_id, secondary_id, secondary_type, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_id: The unique identifier of the object associated with this image record (required)
        :type base_id: str
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_id",
            "base_type",
            "organization_id",
            "secondary_id",
            "secondary_type",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "image_type",
            "include",
            "limit",
            "offset",
            "rating",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_list_id_secondary" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_id"]:
            _path_params["baseId"] = _params["base_id"]

        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["secondary_id"]:
            _path_params["secondaryId"] = _params["secondary_id"]

        if _params["secondary_type"]:
            _path_params["secondaryType"] = _params["secondary_type"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("image_type") is not None:  # noqa: E501
            _query_params.append(("imageType", _params["image_type"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("rating") is not None:  # noqa: E501
            _query_params.append(("rating", _params["rating"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/{baseId}/in/{secondaryType}/{secondaryId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_list_organization(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get a list of images for the Organization  # noqa: E501

        Return a list of images for the Organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_organization(organization_id, sport, added, base_type, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_list_organization_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_list_organization_with_http_info(
                organization_id,
                sport,
                added,
                base_type,
                external,
                fields,
                hide_null,
                image_type,
                include,
                limit,
                offset,
                rating,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_list_organization: %s\n" % e)
            raise

    @validate_arguments
    def images_list_organization_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        base_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of images for the Organization  # noqa: E501

        Return a list of images for the Organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_organization_with_http_info(organization_id, sport, added, base_type, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season
        :type base_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "base_type",
            "external",
            "fields",
            "hide_null",
            "image_type",
            "include",
            "limit",
            "offset",
            "rating",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method images_list_organization" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("base_type") is not None:  # noqa: E501
            _query_params.append(("baseType", _params["base_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("image_type") is not None:  # noqa: E501
            _query_params.append(("imageType", _params["image_type"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("rating") is not None:  # noqa: E501
            _query_params.append(("rating", _params["rating"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/ORGANIZATION",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_list_secondary(
        self,
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Get a list of images for a type in a secondary Type  # noqa: E501

        Return a list of images assigned to type for a secondary type and Id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_secondary(base_type, organization_id, secondary_id, secondary_type, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_list_secondary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_list_secondary_with_http_info(
                base_type,
                organization_id,
                secondary_id,
                secondary_type,
                sport,
                added,
                external,
                fields,
                hide_null,
                image_type,
                include,
                limit,
                offset,
                rating,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_list_secondary: %s\n" % e)
            raise

    @validate_arguments
    def images_list_secondary_with_http_info(
        self,
        base_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season ",
            ),
        ],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        secondary_id: Annotated[
            StrictStr,
            Field(..., description="The unique identifier of the secondary object associated with this image record"),
        ],
        secondary_type: Annotated[
            constr(strict=True, max_length=100),
            Field(
                ...,
                description="Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season ",
            ),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        image_type: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo "
            ),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        rating: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(description="Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown "),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of images for a type in a secondary Type  # noqa: E501

        Return a list of images assigned to type for a secondary type and Id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_list_secondary_with_http_info(base_type, organization_id, secondary_id, secondary_type, sport, added, external, fields, hide_null, image_type, include, limit, offset, rating, updated, async_req=True)
        >>> result = thread.get()

        :param base_type: Media Base Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `PERSON` Person >- `SEASON` Season  (required)
        :type base_type: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param secondary_id: The unique identifier of the secondary object associated with this image record (required)
        :type secondary_id: str
        :param secondary_type: Media Secondary Type >- `COMPETITION` Competition >- `CONFERENCE` Conference >- `DIVISION` Division >- `ENTITY` Entity >- `ENTITYGROUP` Entity Group >- `LEAGUE` League >- `ORGANIZATION` Organization >- `SEASON` Season  (required)
        :type secondary_type: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param image_type: Upload Type >- `LOGO` Logo >- `LOGO_ALTERNATE` Logo - Alternate >- `LOGO_BACKGROUND` Logo Background >- `PERSON_HEAD` Head photo >- `PERSON_POSE` Posing photo >- `PERSON_WAIST` Waist and Head photo >- `TEAM_PHOTO` Team Photo
        :type image_type: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param rating: Media Rating >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium >- `UNKNOWN` Uknown
        :type rating: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "base_type",
            "organization_id",
            "secondary_id",
            "secondary_type",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "image_type",
            "include",
            "limit",
            "offset",
            "rating",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_list_secondary" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["base_type"]:
            _path_params["baseType"] = _params["base_type"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["secondary_id"]:
            _path_params["secondaryId"] = _params["secondary_id"]

        if _params["secondary_type"]:
            _path_params["secondaryType"] = _params["secondary_type"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("image_type") is not None:  # noqa: E501
            _query_params.append(("imageType", _params["image_type"].value))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("rating") is not None:  # noqa: E501
            _query_params.append(("rating", _params["rating"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/for/{baseType}/in/{secondaryType}/{secondaryId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def images_update(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_put_body: ImagesPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ImagesResponse:  # noqa: E501
        """Update the rating for an image  # noqa: E501

        Set the rating for an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_update(image_id, organization_id, sport, images_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_put_body: (required)
        :type images_put_body: ImagesPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the images_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.images_update_with_http_info(
                image_id, organization_id, sport, images_put_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling ImagesApi->images_update: %s\n" % e)
            raise

    @validate_arguments
    def images_update_with_http_info(
        self,
        image_id: Annotated[StrictStr, Field(..., description="The unique identifier of the image record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        images_put_body: ImagesPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update the rating for an image  # noqa: E501

        Set the rating for an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.images_update_with_http_info(image_id, organization_id, sport, images_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param image_id: The unique identifier of the image record (required)
        :type image_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param images_put_body: (required)
        :type images_put_body: ImagesPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "image_id",
            "organization_id",
            "sport",
            "images_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method images_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["image_id"]:
            _path_params["imageId"] = _params["image_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["images_put_body"] is not None:
            _body_params = _params["images_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "ImagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/images/{imageId}/rating",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
