# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.fixture_post_body import FixturePostBody
from atriumsports.datacore.openapi.models.fixture_put_body import FixturePutBody
from atriumsports.datacore.openapi.models.fixture_videosteam_post_body import FixtureVideosteamPostBody
from atriumsports.datacore.openapi.models.fixtures_by_competition_response import FixturesByCompetitionResponse
from atriumsports.datacore.openapi.models.fixtures_by_entity_response import FixturesByEntityResponse
from atriumsports.datacore.openapi.models.fixtures_response import FixturesResponse
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_response import (
    SeasonFixtureStagesPoolsListResponse,
)
from atriumsports.datacore.openapi.models.success_response import SuccessResponse

logger = logging.getLogger("openapi")


class FixturesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def fixture_by_competition_list(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesByCompetitionResponse:  # noqa: E501
        """Get a list of fixtures for a Competition  # noqa: E501

        Return a list of fixtures, for a specific Competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_competition_list(competition_id, organization_id, sport, added, competitor_type, external, fields, fixture_id, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesByCompetitionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_by_competition_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_by_competition_list_with_http_info(
                competition_id,
                organization_id,
                sport,
                added,
                competitor_type,
                external,
                fields,
                fixture_id,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                season_id,
                sort_by,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_by_competition_list: %s\n" % e)
            raise

    @validate_arguments
    def fixture_by_competition_list_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures for a Competition  # noqa: E501

        Return a list of fixtures, for a specific Competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_competition_list_with_http_info(competition_id, organization_id, sport, added, competitor_type, external, fields, fixture_id, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesByCompetitionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "organization_id",
            "sport",
            "added",
            "competitor_type",
            "external",
            "fields",
            "fixture_id",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "season_id",
            "sort_by",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_by_competition_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_id") is not None:  # noqa: E501
            _query_params.append(("fixtureId", _params["fixture_id"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesByCompetitionResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/competitions/{competitionId}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_by_entity_all_seasons_list(
        self,
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_home: Annotated[Optional[StrictBool], Field(description="Is competitor the home entity ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesByEntityResponse:  # noqa: E501
        """Get a list of fixtures for an Entity  # noqa: E501

        Return a list of fixtures, for a specific Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_entity_all_seasons_list(entity_id, organization_id, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, is_home, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_home: Is competitor the home entity ?
        :type is_home: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesByEntityResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_by_entity_all_seasons_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_by_entity_all_seasons_list_with_http_info(
                entity_id,
                organization_id,
                sport,
                added,
                competitor_type,
                external,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                is_home,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                season_id,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_by_entity_all_seasons_list: %s\n" % e)
            raise

    @validate_arguments
    def fixture_by_entity_all_seasons_list_with_http_info(
        self,
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_home: Annotated[Optional[StrictBool], Field(description="Is competitor the home entity ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures for an Entity  # noqa: E501

        Return a list of fixtures, for a specific Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_entity_all_seasons_list_with_http_info(entity_id, organization_id, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, is_home, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_home: Is competitor the home entity ?
        :type is_home: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesByEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "entity_id",
            "organization_id",
            "sport",
            "added",
            "competitor_type",
            "external",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "is_home",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "season_id",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_by_entity_all_seasons_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["entity_id"]:
            _path_params["entityId"] = _params["entity_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("is_home") is not None:  # noqa: E501
            _query_params.append(("isHome", _params["is_home"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesByEntityResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/entities/{entityId}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_by_entity_list(
        self,
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_home: Annotated[Optional[StrictBool], Field(description="Is competitor the home entity ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesByEntityResponse:  # noqa: E501
        """Get a list of fixtures for an Entity  # noqa: E501

        Return a list of fixtures, within ~seasonprefix~ season, for a specific Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_entity_list(entity_id, organization_id, season_id, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, is_home, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, series_code, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_home: Is competitor the home entity ?
        :type is_home: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesByEntityResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_by_entity_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_by_entity_list_with_http_info(
                entity_id,
                organization_id,
                season_id,
                sport,
                added,
                competitor_type,
                external,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                is_home,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                series_code,
                sort_by,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_by_entity_list: %s\n" % e)
            raise

    @validate_arguments
    def fixture_by_entity_list_with_http_info(
        self,
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_home: Annotated[Optional[StrictBool], Field(description="Is competitor the home entity ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures for an Entity  # noqa: E501

        Return a list of fixtures, within ~seasonprefix~ season, for a specific Entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_by_entity_list_with_http_info(entity_id, organization_id, season_id, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, is_home, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, series_code, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_home: Is competitor the home entity ?
        :type is_home: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesByEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "entity_id",
            "organization_id",
            "season_id",
            "sport",
            "added",
            "competitor_type",
            "external",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "is_home",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "series_code",
            "sort_by",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_by_entity_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["entity_id"]:
            _path_params["entityId"] = _params["entity_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("is_home") is not None:  # noqa: E501
            _query_params.append(("isHome", _params["is_home"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("series_code") is not None:  # noqa: E501
            _query_params.append(("seriesCode", _params["series_code"]))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesByEntityResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/entities/{entityId}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_delete(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Delete a fixture  # noqa: E501

        Delete a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_delete(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_delete_with_http_info(
                fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_delete: %s\n" % e)
            raise

    @validate_arguments
    def fixture_delete_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a fixture  # noqa: E501

        Delete a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_delete_with_http_info(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_detail(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Get a fixture  # noqa: E501

        Return detailed information about a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_detail(fixture_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_detail_with_http_info(
                fixture_id, organization_id, sport, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_detail: %s\n" % e)
            raise

    @validate_arguments
    def fixture_detail_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a fixture  # noqa: E501

        Return detailed information about a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_detail_with_http_info(fixture_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_post_body: FixturePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Create a fixture  # noqa: E501

        Add a new fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_insert(organization_id, season_id, sport, fixture_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_post_body: (required)
        :type fixture_post_body: FixturePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_insert_with_http_info(
                organization_id, season_id, sport, fixture_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_insert: %s\n" % e)
            raise

    @validate_arguments
    def fixture_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_post_body: FixturePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a fixture  # noqa: E501

        Add a new fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_insert_with_http_info(organization_id, season_id, sport, fixture_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_post_body: (required)
        :type fixture_post_body: FixturePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "fixture_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_post_body"] is not None:
            _body_params = _params["fixture_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/fixtures",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_insert_base_route(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_post_body: FixturePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Create a fixture base route  # noqa: E501

        Add a new fixture, allowing seasonId to be in payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_insert_base_route(organization_id, sport, fixture_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_post_body: (required)
        :type fixture_post_body: FixturePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_insert_base_route_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_insert_base_route_with_http_info(
                organization_id, sport, fixture_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_insert_base_route: %s\n" % e)
            raise

    @validate_arguments
    def fixture_insert_base_route_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_post_body: FixturePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a fixture base route  # noqa: E501

        Add a new fixture, allowing seasonId to be in payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_insert_base_route_with_http_info(organization_id, sport, fixture_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_post_body: (required)
        :type fixture_post_body: FixturePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "sport", "fixture_post_body", "external", "fields", "hide_null", "include"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_insert_base_route" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_post_body"] is not None:
            _body_params = _params["fixture_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feature_match: Annotated[Optional[StrictBool], Field(description="Is this fixture a featured match?")] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        series_fixture_number: Annotated[
            Optional[StrictInt], Field(description="The number of the fixture in a series of fixtures")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Get a list of fixtures  # noqa: E501

        Return a list of fixtures for the season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_list(organization_id, season_id, sport, added, competitor_type, external, feature_match, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, series_code, series_fixture_number, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feature_match: Is this fixture a featured match?
        :type feature_match: bool
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param series_fixture_number: The number of the fixture in a series of fixtures
        :type series_fixture_number: int
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_list_with_http_info(
                organization_id,
                season_id,
                sport,
                added,
                competitor_type,
                external,
                feature_match,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                series_code,
                series_fixture_number,
                sort_by,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_list: %s\n" % e)
            raise

    @validate_arguments
    def fixture_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feature_match: Annotated[Optional[StrictBool], Field(description="Is this fixture a featured match?")] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        series_fixture_number: Annotated[
            Optional[StrictInt], Field(description="The number of the fixture in a series of fixtures")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures  # noqa: E501

        Return a list of fixtures for the season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_list_with_http_info(organization_id, season_id, sport, added, competitor_type, external, feature_match, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, series_code, series_fixture_number, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feature_match: Is this fixture a featured match?
        :type feature_match: bool
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param series_fixture_number: The number of the fixture in a series of fixtures
        :type series_fixture_number: int
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "added",
            "competitor_type",
            "external",
            "feature_match",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "series_code",
            "series_fixture_number",
            "sort_by",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("feature_match") is not None:  # noqa: E501
            _query_params.append(("featureMatch", _params["feature_match"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("series_code") is not None:  # noqa: E501
            _query_params.append(("seriesCode", _params["series_code"]))

        if _params.get("series_fixture_number") is not None:  # noqa: E501
            _query_params.append(("seriesFixtureNumber", _params["series_fixture_number"]))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_locking(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Locking fixture  # noqa: E501

        Locking a specific fixture record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_locking(fixture_id, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_locking_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_locking_with_http_info(
                fixture_id, organization_id, sport, body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_locking: %s\n" % e)
            raise

    @validate_arguments
    def fixture_locking_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Locking fixture  # noqa: E501

        Locking a specific fixture record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_locking_with_http_info(fixture_id, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["fixture_id", "organization_id", "sport", "body", "external", "fields", "hide_null", "include"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_locking" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/lock",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_reset(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Reset fixture  # noqa: E501

        Reset a specific fixture record. Removes statistics, events and PLAY-BY-PLAY records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_reset(fixture_id, organization_id, sport, body, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_reset_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_reset_with_http_info(
                fixture_id, organization_id, sport, body, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_reset: %s\n" % e)
            raise

    @validate_arguments
    def fixture_reset_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Reset fixture  # noqa: E501

        Reset a specific fixture record. Removes statistics, events and PLAY-BY-PLAY records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_reset_with_http_info(fixture_id, organization_id, sport, body, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "body",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_reset" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/reset",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_unlocking(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Unlock fixture  # noqa: E501

        Unlock a specific fixture record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_unlocking(fixture_id, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_unlocking_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_unlocking_with_http_info(
                fixture_id, organization_id, sport, body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_unlocking: %s\n" % e)
            raise

    @validate_arguments
    def fixture_unlocking_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, Any],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Unlock fixture  # noqa: E501

        Unlock a specific fixture record  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_unlocking_with_http_info(fixture_id, organization_id, sport, body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["fixture_id", "organization_id", "sport", "body", "external", "fields", "hide_null", "include"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_unlocking" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/unlock",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_update(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_put_body: FixturePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Update a fixture  # noqa: E501

        Change the information of a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_update(fixture_id, organization_id, sport, fixture_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_put_body: (required)
        :type fixture_put_body: FixturePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_update_with_http_info(
                fixture_id, organization_id, sport, fixture_put_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_update: %s\n" % e)
            raise

    @validate_arguments
    def fixture_update_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_put_body: FixturePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update a fixture  # noqa: E501

        Change the information of a specific fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_update_with_http_info(fixture_id, organization_id, sport, fixture_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_put_body: (required)
        :type fixture_put_body: FixturePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_put_body"] is not None:
            _body_params = _params["fixture_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_videostream_disable(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Disable a fixture live video stream  # noqa: E501

        Disable a specific fixture live video stream  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_disable(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_videostream_disable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_videostream_disable_with_http_info(
                fixture_id,
                organization_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_videostream_disable: %s\n" % e)
            raise

    @validate_arguments
    def fixture_videostream_disable_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Disable a fixture live video stream  # noqa: E501

        Disable a specific fixture live video stream  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_disable_with_http_info(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_videostream_disable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/streams/disable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_videostream_enable(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Enable a fixture live video stream  # noqa: E501

        Enable a specific fixture live video stream  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_enable(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_videostream_enable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_videostream_enable_with_http_info(
                fixture_id,
                organization_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_videostream_enable: %s\n" % e)
            raise

    @validate_arguments
    def fixture_videostream_enable_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Enable a fixture live video stream  # noqa: E501

        Enable a specific fixture live video stream  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_enable_with_http_info(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_videostream_enable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/streams/enable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_videostream_start(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Start a fixture live video stream recording  # noqa: E501

        Start a specific fixture live video stream recording  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_start(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_videostream_start_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_videostream_start_with_http_info(
                fixture_id,
                organization_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_videostream_start: %s\n" % e)
            raise

    @validate_arguments
    def fixture_videostream_start_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Start a fixture live video stream recording  # noqa: E501

        Start a specific fixture live video stream recording  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_start_with_http_info(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_videostream_start" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/streams/start",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_videostream_stop(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Stop a fixture live video stream recording  # noqa: E501

        Stop a specific fixture live video stream recording  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_stop(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_videostream_stop_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_videostream_stop_with_http_info(
                fixture_id,
                organization_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->fixture_videostream_stop: %s\n" % e)
            raise

    @validate_arguments
    def fixture_videostream_stop_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Stop a fixture live video stream recording  # noqa: E501

        Stop a specific fixture live video stream recording  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_videostream_stop_with_http_info(fixture_id, organization_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_videostream_stop" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/streams/stop",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def organization_fixture_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feature_match: Annotated[Optional[StrictBool], Field(description="Is this fixture a featured match?")] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        series_fixture_number: Annotated[
            Optional[StrictInt], Field(description="The number of the fixture in a series of fixtures")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Get a list of fixtures for the organization  # noqa: E501

        Return a list of fixtures for the organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.organization_fixture_list(organization_id, sport, added, competitor_type, external, feature_match, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, series_code, series_fixture_number, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feature_match: Is this fixture a featured match?
        :type feature_match: bool
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param series_fixture_number: The number of the fixture in a series of fixtures
        :type series_fixture_number: int
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the organization_fixture_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.organization_fixture_list_with_http_info(
                organization_id,
                sport,
                added,
                competitor_type,
                external,
                feature_match,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                season_id,
                series_code,
                series_fixture_number,
                sort_by,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->organization_fixture_list: %s\n" % e)
            raise

    @validate_arguments
    def organization_fixture_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feature_match: Annotated[Optional[StrictBool], Field(description="Is this fixture a featured match?")] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        series_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The series identifier within a season")
        ] = None,
        series_fixture_number: Annotated[
            Optional[StrictInt], Field(description="The number of the fixture in a series of fixtures")
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures for the organization  # noqa: E501

        Return a list of fixtures for the organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.organization_fixture_list_with_http_info(organization_id, sport, added, competitor_type, external, feature_match, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, series_code, series_fixture_number, sort_by, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feature_match: Is this fixture a featured match?
        :type feature_match: bool
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param series_code: The series identifier within a season
        :type series_code: str
        :param series_fixture_number: The number of the fixture in a series of fixtures
        :type series_fixture_number: int
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "competitor_type",
            "external",
            "feature_match",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "season_id",
            "series_code",
            "series_fixture_number",
            "sort_by",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method organization_fixture_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("feature_match") is not None:  # noqa: E501
            _query_params.append(("featureMatch", _params["feature_match"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("series_code") is not None:  # noqa: E501
            _query_params.append(("seriesCode", _params["series_code"]))

        if _params.get("series_fixture_number") is not None:  # noqa: E501
            _query_params.append(("seriesFixtureNumber", _params["series_fixture_number"]))

        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def orggroup_fixture_detail(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_group_code: Annotated[
            constr(strict=True, max_length=150, min_length=3),
            Field(..., description="The unique identifier of the organization group"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Get a single fixture for the organization group  # noqa: E501

        Return detailed information about a specific fixture for the organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.orggroup_fixture_detail(fixture_id, organization_group_code, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_group_code: The unique identifier of the organization group (required)
        :type organization_group_code: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the orggroup_fixture_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.orggroup_fixture_detail_with_http_info(
                fixture_id,
                organization_group_code,
                sport,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->orggroup_fixture_detail: %s\n" % e)
            raise

    @validate_arguments
    def orggroup_fixture_detail_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_group_code: Annotated[
            constr(strict=True, max_length=150, min_length=3),
            Field(..., description="The unique identifier of the organization group"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a single fixture for the organization group  # noqa: E501

        Return detailed information about a specific fixture for the organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.orggroup_fixture_detail_with_http_info(fixture_id, organization_group_code, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_group_code: The unique identifier of the organization group (required)
        :type organization_group_code: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_group_code",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method orggroup_fixture_detail" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_group_code"]:
            _path_params["organizationGroupCode"] = _params["organization_group_code"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/orgGroup/{organizationGroupCode}/fixtures/{fixtureId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def orggroup_fixture_list(
        self,
        organization_group_code: Annotated[
            constr(strict=True, max_length=150, min_length=3),
            Field(..., description="The unique identifier of the organization group"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> FixturesResponse:  # noqa: E501
        """Get a list of fixtures for the organization group  # noqa: E501

        Return a list of fixtures for the organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.orggroup_fixture_list(organization_group_code, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_group_code: The unique identifier of the organization group (required)
        :type organization_group_code: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the orggroup_fixture_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.orggroup_fixture_list_with_http_info(
                organization_group_code,
                sport,
                added,
                competitor_type,
                external,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                live_data_available,
                live_video_available,
                locked,
                offset,
                pool_code,
                round_code,
                round_number,
                season_id,
                stage_code,
                status,
                times_unconfirmed,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->orggroup_fixture_list: %s\n" % e)
            raise

    @validate_arguments
    def orggroup_fixture_list_with_http_info(
        self,
        organization_group_code: Annotated[
            constr(strict=True, max_length=150, min_length=3),
            Field(..., description="The unique identifier of the organization group"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competitor_type: Annotated[
            Optional[StrictStr],
            Field(description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person "),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live_data_available: Annotated[Optional[StrictBool], Field(description="Is live data available?")] = None,
        live_video_available: Annotated[Optional[StrictBool], Field(description="Is live video available ?")] = None,
        locked: Annotated[
            Optional[StrictBool], Field(description="Is the fixture locked (to prevent editing)?")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=200)],
            Field(
                description="Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled "
            ),
        ] = None,
        times_unconfirmed: Annotated[
            Optional[StrictBool], Field(description="Is the fixture time yet to be confirmed ?")
        ] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixtures for the organization group  # noqa: E501

        Return a list of fixtures for the organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.orggroup_fixture_list_with_http_info(organization_group_code, sport, added, competitor_type, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, include, limit, live_data_available, live_video_available, locked, offset, pool_code, round_code, round_number, season_id, stage_code, status, times_unconfirmed, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param organization_group_code: The unique identifier of the organization group (required)
        :type organization_group_code: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competitor_type: The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person
        :type competitor_type: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live_data_available: Is live data available?
        :type live_data_available: bool
        :param live_video_available: Is live video available ?
        :type live_video_available: bool
        :param locked: Is the fixture locked (to prevent editing)?
        :type locked: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param status: Fixture status. Can specify multiple, delimited by comma. >- `ABANDONED` Abandoned >- `BYE` Bye >- `CANCELLED` Cancelled >- `CONFIRMED` Confirmed >- `FINISHED` Finished >- `IF_NEEDED` If Needed >- `IN_PROGRESS` In Progress >- `PENDING` Pending >- `POSTPONED` Postponed >- `SCHEDULED` Scheduled
        :type status: str
        :param times_unconfirmed: Is the fixture time yet to be confirmed ?
        :type times_unconfirmed: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_group_code",
            "sport",
            "added",
            "competitor_type",
            "external",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "live_data_available",
            "live_video_available",
            "locked",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "season_id",
            "stage_code",
            "status",
            "times_unconfirmed",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method orggroup_fixture_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_group_code"]:
            _path_params["organizationGroupCode"] = _params["organization_group_code"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("competitor_type") is not None:  # noqa: E501
            _query_params.append(("competitorType", _params["competitor_type"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("from_time_local") is not None:  # noqa: E501
            if isinstance(_params["from_time_local"], datetime):
                _query_params.append(
                    (
                        "fromTimeLocal",
                        _params["from_time_local"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("fromTimeLocal", _params["from_time_local"]))

        if _params.get("from_time_utc") is not None:  # noqa: E501
            if isinstance(_params["from_time_utc"], datetime):
                _query_params.append(
                    ("fromTimeUTC", _params["from_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimeUTC", _params["from_time_utc"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("live_data_available") is not None:  # noqa: E501
            _query_params.append(("liveDataAvailable", _params["live_data_available"]))

        if _params.get("live_video_available") is not None:  # noqa: E501
            _query_params.append(("liveVideoAvailable", _params["live_video_available"]))

        if _params.get("locked") is not None:  # noqa: E501
            _query_params.append(("locked", _params["locked"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))

        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))

        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("times_unconfirmed") is not None:  # noqa: E501
            _query_params.append(("timesUnconfirmed", _params["times_unconfirmed"]))

        if _params.get("to_time_local") is not None:  # noqa: E501
            if isinstance(_params["to_time_local"], datetime):
                _query_params.append(
                    ("toTimeLocal", _params["to_time_local"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeLocal", _params["to_time_local"]))

        if _params.get("to_time_utc") is not None:  # noqa: E501
            if isinstance(_params["to_time_utc"], datetime):
                _query_params.append(
                    ("toTimeUTC", _params["to_time_utc"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimeUTC", _params["to_time_utc"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/orgGroup/{organizationGroupCode}/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_fixture_stages_pools_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        **kwargs
    ) -> SeasonFixtureStagesPoolsListResponse:  # noqa: E501
        """Get a list of stages and pools used by fixtures in the season  # noqa: E501

        Return a list of stages and pools used by fixtures for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_fixture_stages_pools_list(organization_id, season_id, sport, external, fields, fixture_type, hide_null, include, limit, offset, stage_code, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonFixtureStagesPoolsListResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_fixture_stages_pools_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_fixture_stages_pools_list_with_http_info(
                organization_id,
                season_id,
                sport,
                external,
                fields,
                fixture_type,
                hide_null,
                include,
                limit,
                offset,
                stage_code,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->season_fixture_stages_pools_list: %s\n" % e)
            raise

    @validate_arguments
    def season_fixture_stages_pools_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of stages and pools used by fixtures in the season  # noqa: E501

        Return a list of stages and pools used by fixtures for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_fixture_stages_pools_list_with_http_info(organization_id, season_id, sport, external, fields, fixture_type, hide_null, include, limit, offset, stage_code, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonFixtureStagesPoolsListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "include",
            "limit",
            "offset",
            "stage_code",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_fixture_stages_pools_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"].value))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonFixtureStagesPoolsListResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/fixtures/stages/pools",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_venue_videostream_disable(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the venue")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Disable season live video streams for all fixtures for a venue  # noqa: E501

        Disable live video stream for all fixtures in season for a venue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_venue_videostream_disable(organization_id, season_id, sport, venue_id, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param venue_id: The unique identifier of the venue (required)
        :type venue_id: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_venue_videostream_disable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_venue_videostream_disable_with_http_info(
                organization_id,
                season_id,
                sport,
                venue_id,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->season_venue_videostream_disable: %s\n" % e)
            raise

    @validate_arguments
    def season_venue_videostream_disable_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the venue")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Disable season live video streams for all fixtures for a venue  # noqa: E501

        Disable live video stream for all fixtures in season for a venue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_venue_videostream_disable_with_http_info(organization_id, season_id, sport, venue_id, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param venue_id: The unique identifier of the venue (required)
        :type venue_id: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "venue_id",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_venue_videostream_disable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        if _params["venue_id"]:
            _path_params["venueId"] = _params["venue_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/venues/{venueId}/video/streams/disable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_venue_videostream_enable(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the venue")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Enable season live video streams for all fixtures for a venue  # noqa: E501

        Enable live video stream for all fixtures in season for a venue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_venue_videostream_enable(organization_id, season_id, sport, venue_id, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param venue_id: The unique identifier of the venue (required)
        :type venue_id: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_venue_videostream_enable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_venue_videostream_enable_with_http_info(
                organization_id,
                season_id,
                sport,
                venue_id,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->season_venue_videostream_enable: %s\n" % e)
            raise

    @validate_arguments
    def season_venue_videostream_enable_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the venue")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Enable season live video streams for all fixtures for a venue  # noqa: E501

        Enable live video stream for all fixtures in season for a venue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_venue_videostream_enable_with_http_info(organization_id, season_id, sport, venue_id, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param venue_id: The unique identifier of the venue (required)
        :type venue_id: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "venue_id",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_venue_videostream_enable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        if _params["venue_id"]:
            _path_params["venueId"] = _params["venue_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/venues/{venueId}/video/streams/enable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_videostream_disable(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Disable season live video streams for all fixtures  # noqa: E501

        Disable live video stream for all fixtures in season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_videostream_disable(organization_id, season_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_videostream_disable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_videostream_disable_with_http_info(
                organization_id,
                season_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->season_videostream_disable: %s\n" % e)
            raise

    @validate_arguments
    def season_videostream_disable_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Disable season live video streams for all fixtures  # noqa: E501

        Disable live video stream for all fixtures in season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_videostream_disable_with_http_info(organization_id, season_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_videostream_disable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/video/streams/disable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_videostream_enable(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Enable season live video streams for all fixtures  # noqa: E501

        Enable live video stream for all fixtures in season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_videostream_enable(organization_id, season_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the season_videostream_enable_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.season_videostream_enable_with_http_info(
                organization_id,
                season_id,
                sport,
                fixture_videosteam_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturesApi->season_videostream_enable: %s\n" % e)
            raise

    @validate_arguments
    def season_videostream_enable_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_videosteam_post_body: FixtureVideosteamPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Enable season live video streams for all fixtures  # noqa: E501

        Enable live video stream for all fixtures in season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_videostream_enable_with_http_info(organization_id, season_id, sport, fixture_videosteam_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_videosteam_post_body: (required)
        :type fixture_videosteam_post_body: FixtureVideosteamPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "fixture_videosteam_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_videostream_enable" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_videosteam_post_body"] is not None:
            _body_params = _params["fixture_videosteam_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/video/streams/enable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
