# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.fixture_pbp_event_response import FixturePbpEventResponse
from atriumsports.datacore.openapi.models.fixture_pbp_post_body import FixturePbpPostBody
from atriumsports.datacore.openapi.models.fixture_pbp_response import FixturePbpResponse

logger = logging.getLogger("openapi")


class FixturePLAYBYPLAYApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def fixture_pbp_all_delete(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturePbpResponse:  # noqa: E501
        """Delete all play-by-play records for a fixture  # noqa: E501

        Delete all play-by-play records for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_all_delete(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturePbpResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_pbp_all_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_pbp_all_delete_with_http_info(
                fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturePLAYBYPLAYApi->fixture_pbp_all_delete: %s\n" % e)
            raise

    @validate_arguments
    def fixture_pbp_all_delete_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete all play-by-play records for a fixture  # noqa: E501

        Delete all play-by-play records for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_all_delete_with_http_info(fixture_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturePbpResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_pbp_all_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturePbpResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/playbyplay",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_pbp_delete(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        period_id: Annotated[StrictInt, Field(..., description="The identifier for the period")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        **kwargs
    ) -> FixturePbpResponse:  # noqa: E501
        """Delete a fixture play-by-play  # noqa: E501

        Delete a specific period play-by-play from a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_delete(fixture_id, organization_id, period_id, sport, external, fields, force_delete, hide_null, include, section, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param period_id: The identifier for the period (required)
        :type period_id: int
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturePbpResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_pbp_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_pbp_delete_with_http_info(
                fixture_id,
                organization_id,
                period_id,
                sport,
                external,
                fields,
                force_delete,
                hide_null,
                include,
                section,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturePLAYBYPLAYApi->fixture_pbp_delete: %s\n" % e)
            raise

    @validate_arguments
    def fixture_pbp_delete_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        period_id: Annotated[StrictInt, Field(..., description="The identifier for the period")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a fixture play-by-play  # noqa: E501

        Delete a specific period play-by-play from a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_delete_with_http_info(fixture_id, organization_id, period_id, sport, external, fields, force_delete, hide_null, include, section, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param period_id: The identifier for the period (required)
        :type period_id: int
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturePbpResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "period_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "section",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_pbp_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["period_id"]:
            _path_params["periodId"] = _params["period_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturePbpResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/periods/{periodId}/playbyplay",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_pbp_insert_update(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_pbp_post_body: FixturePbpPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> FixturePbpResponse:  # noqa: E501
        """Add or Update historical play-by-play records for a fixture  # noqa: E501

             Depending on primary keys, Add a fixture play-by-play or update an existing record.  This call operates     in bulk for all events in a specific period. <b>Note:</b>This call should only be used to import historical data.     Changes to current/live data show be peformed only via your live capture software.  If this call is used data may     become invalid as statistics/actions may not be recalculated.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_insert_update(fixture_id, organization_id, sport, fixture_pbp_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_pbp_post_body: (required)
        :type fixture_pbp_post_body: FixturePbpPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturePbpResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_pbp_insert_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_pbp_insert_update_with_http_info(
                fixture_id,
                organization_id,
                sport,
                fixture_pbp_post_body,
                external,
                fields,
                hide_null,
                include,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturePLAYBYPLAYApi->fixture_pbp_insert_update: %s\n" % e)
            raise

    @validate_arguments
    def fixture_pbp_insert_update_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        fixture_pbp_post_body: FixturePbpPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Add or Update historical play-by-play records for a fixture  # noqa: E501

             Depending on primary keys, Add a fixture play-by-play or update an existing record.  This call operates     in bulk for all events in a specific period. <b>Note:</b>This call should only be used to import historical data.     Changes to current/live data show be peformed only via your live capture software.  If this call is used data may     become invalid as statistics/actions may not be recalculated.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_insert_update_with_http_info(fixture_id, organization_id, sport, fixture_pbp_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param fixture_pbp_post_body: (required)
        :type fixture_pbp_post_body: FixturePbpPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturePbpResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "fixture_pbp_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method fixture_pbp_insert_update" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["fixture_pbp_post_body"] is not None:
            _body_params = _params["fixture_pbp_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturePbpResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/playbyplay/import",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_pbp_list(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        from_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent >= this value"),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=2000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        to_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent <= this value"),
        ] = None,
        **kwargs
    ) -> FixturePbpEventResponse:  # noqa: E501
        """Get a list play-by-play records for a fixture  # noqa: E501

        Return a list of play-by-play records for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_list(fixture_id, organization_id, sport, external, fields, from_timestamp, hide_null, include, limit, offset, period_id, to_timestamp, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param from_timestamp: Where the date/time (UTC) this play-by-play event was sent >= this value
        :type from_timestamp: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param to_timestamp: Where the date/time (UTC) this play-by-play event was sent <= this value
        :type to_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturePbpEventResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_pbp_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_pbp_list_with_http_info(
                fixture_id,
                organization_id,
                sport,
                external,
                fields,
                from_timestamp,
                hide_null,
                include,
                limit,
                offset,
                period_id,
                to_timestamp,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturePLAYBYPLAYApi->fixture_pbp_list: %s\n" % e)
            raise

    @validate_arguments
    def fixture_pbp_list_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        from_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent >= this value"),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=2000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        to_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent <= this value"),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list play-by-play records for a fixture  # noqa: E501

        Return a list of play-by-play records for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_list_with_http_info(fixture_id, organization_id, sport, external, fields, from_timestamp, hide_null, include, limit, offset, period_id, to_timestamp, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param from_timestamp: Where the date/time (UTC) this play-by-play event was sent >= this value
        :type from_timestamp: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param to_timestamp: Where the date/time (UTC) this play-by-play event was sent <= this value
        :type to_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturePbpEventResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "from_timestamp",
            "hide_null",
            "include",
            "limit",
            "offset",
            "period_id",
            "to_timestamp",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_pbp_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("from_timestamp") is not None:  # noqa: E501
            if isinstance(_params["from_timestamp"], datetime):
                _query_params.append(
                    ("fromTimestamp", _params["from_timestamp"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimestamp", _params["from_timestamp"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))

        if _params.get("to_timestamp") is not None:  # noqa: E501
            if isinstance(_params["to_timestamp"], datetime):
                _query_params.append(
                    ("toTimestamp", _params["to_timestamp"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimestamp", _params["to_timestamp"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturePbpEventResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/playbyplay",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def fixture_pbp_list_live(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        from_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent >= this value"),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=2000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        to_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent <= this value"),
        ] = None,
        **kwargs
    ) -> FixturePbpEventResponse:  # noqa: E501
        """Get a list of live play-by-play records for a fixture  # noqa: E501

             Return a list of live play-by-play records for a fixture. This call will return records of fixtures     still in-progress if available.  If the fixture is complete this call operates the same as the non 'live'     route.      Rate limited to 2 requests every minute - returns HTTP 429 Too Many Requests if called more often.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_list_live(fixture_id, organization_id, sport, external, fields, from_timestamp, hide_null, include, limit, offset, period_id, to_timestamp, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param from_timestamp: Where the date/time (UTC) this play-by-play event was sent >= this value
        :type from_timestamp: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param to_timestamp: Where the date/time (UTC) this play-by-play event was sent <= this value
        :type to_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FixturePbpEventResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the fixture_pbp_list_live_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.fixture_pbp_list_live_with_http_info(
                fixture_id,
                organization_id,
                sport,
                external,
                fields,
                from_timestamp,
                hide_null,
                include,
                limit,
                offset,
                period_id,
                to_timestamp,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling FixturePLAYBYPLAYApi->fixture_pbp_list_live: %s\n" % e)
            raise

    @validate_arguments
    def fixture_pbp_list_live_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        from_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent >= this value"),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=2000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        to_timestamp: Annotated[
            Optional[datetime],
            Field(description="Where the date/time (UTC) this play-by-play event was sent <= this value"),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of live play-by-play records for a fixture  # noqa: E501

             Return a list of live play-by-play records for a fixture. This call will return records of fixtures     still in-progress if available.  If the fixture is complete this call operates the same as the non 'live'     route.      Rate limited to 2 requests every minute - returns HTTP 429 Too Many Requests if called more often.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fixture_pbp_list_live_with_http_info(fixture_id, organization_id, sport, external, fields, from_timestamp, hide_null, include, limit, offset, period_id, to_timestamp, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param from_timestamp: Where the date/time (UTC) this play-by-play event was sent >= this value
        :type from_timestamp: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param to_timestamp: Where the date/time (UTC) this play-by-play event was sent <= this value
        :type to_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FixturePbpEventResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "from_timestamp",
            "hide_null",
            "include",
            "limit",
            "offset",
            "period_id",
            "to_timestamp",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method fixture_pbp_list_live" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("from_timestamp") is not None:  # noqa: E501
            if isinstance(_params["from_timestamp"], datetime):
                _query_params.append(
                    ("fromTimestamp", _params["from_timestamp"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("fromTimestamp", _params["from_timestamp"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))

        if _params.get("to_timestamp") is not None:  # noqa: E501
            if isinstance(_params["to_timestamp"], datetime):
                _query_params.append(
                    ("toTimestamp", _params["to_timestamp"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("toTimestamp", _params["to_timestamp"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "FixturePbpEventResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/playbyplay/live",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
