# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.video_file_post_body import VideoFilePostBody
from atriumsports.datacore.openapi.models.video_files_download_response import VideoFilesDownloadResponse
from atriumsports.datacore.openapi.models.video_files_response import VideoFilesResponse

logger = logging.getLogger("openapi")


class DownloadVideoApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def video_file_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_id: Annotated[StrictStr, Field(..., description="The unique identifier of the video file")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> VideoFilesDownloadResponse:  # noqa: E501
        """Delete a video file  # noqa: E501

        Delete a video file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_delete(organization_id, sport, video_id, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_id: The unique identifier of the video file (required)
        :type video_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoFilesDownloadResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the video_file_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.video_file_delete_with_http_info(
                organization_id, sport, video_id, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling DownloadVideoApi->video_file_delete: %s\n" % e)
            raise

    @validate_arguments
    def video_file_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_id: Annotated[StrictStr, Field(..., description="The unique identifier of the video file")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a video file  # noqa: E501

        Delete a video file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_delete_with_http_info(organization_id, sport, video_id, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_id: The unique identifier of the video file (required)
        :type video_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoFilesDownloadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "video_id",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method video_file_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        if _params["video_id"]:
            _path_params["videoId"] = _params["video_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoFilesDownloadResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/video/files/{videoId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def video_file_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_id: Annotated[StrictStr, Field(..., description="The unique identifier of the video file")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> VideoFilesDownloadResponse:  # noqa: E501
        """Download URL  # noqa: E501

        Generate a url to download a video file for a fixture. This link is only valid for 30 minutes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_detail(organization_id, sport, video_id, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_id: The unique identifier of the video file (required)
        :type video_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoFilesDownloadResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the video_file_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.video_file_detail_with_http_info(
                organization_id, sport, video_id, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling DownloadVideoApi->video_file_detail: %s\n" % e)
            raise

    @validate_arguments
    def video_file_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_id: Annotated[StrictStr, Field(..., description="The unique identifier of the video file")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Download URL  # noqa: E501

        Generate a url to download a video file for a fixture. This link is only valid for 30 minutes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_detail_with_http_info(organization_id, sport, video_id, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_id: The unique identifier of the video file (required)
        :type video_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoFilesDownloadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "video_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method video_file_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        if _params["video_id"]:
            _path_params["videoId"] = _params["video_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoFilesDownloadResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/video/files/{videoId}/url",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def video_file_insert(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_file_post_body: VideoFilePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> VideoFilesResponse:  # noqa: E501
        """Add a new video file  # noqa: E501

        Add a new video file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_insert(fixture_id, organization_id, sport, video_file_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_file_post_body: (required)
        :type video_file_post_body: VideoFilePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoFilesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the video_file_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.video_file_insert_with_http_info(
                fixture_id, organization_id, sport, video_file_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling DownloadVideoApi->video_file_insert: %s\n" % e)
            raise

    @validate_arguments
    def video_file_insert_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        video_file_post_body: VideoFilePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Add a new video file  # noqa: E501

        Add a new video file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_insert_with_http_info(fixture_id, organization_id, sport, video_file_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param video_file_post_body: (required)
        :type video_file_post_body: VideoFilePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoFilesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "video_file_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method video_file_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["video_file_post_body"] is not None:
            _body_params = _params["video_file_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoFilesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/files",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def video_file_list(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        content: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        format: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file "),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        origin: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="The origin of the video file >- `STREAM` Streamed >- `UPLOAD` Uploaded >- `VENUE` Recorded in venue "
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="What is the status of the file? >- `AVAILABLE` Available for access >- `BUILDABLE` Not currently available - but can be built on request >- `PENDING` Being added - some parts may be available "
            ),
        ] = None,
        storage_provider: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Where the video file is stored? >- `5STREAM` 5stream >- `KEEMOTION` Keemotion >- `SYNERGY` Synergy "
            ),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> VideoFilesResponse:  # noqa: E501
        """List available video files for a fixture  # noqa: E501

        List the video files for a fixture that are available for downloaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_list(fixture_id, organization_id, sport, added, content, external, feed_type, fields, format, hide_null, include, limit, locale, offset, origin, provider, source_number, status, storage_provider, updated, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param content: Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream
        :type content: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param format: The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file
        :type format: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param origin: The origin of the video file >- `STREAM` Streamed >- `UPLOAD` Uploaded >- `VENUE` Recorded in venue
        :type origin: str
        :param provider: The unique code for the video provider
        :type provider: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param status: What is the status of the file? >- `AVAILABLE` Available for access >- `BUILDABLE` Not currently available - but can be built on request >- `PENDING` Being added - some parts may be available
        :type status: str
        :param storage_provider: Where the video file is stored? >- `5STREAM` 5stream >- `KEEMOTION` Keemotion >- `SYNERGY` Synergy
        :type storage_provider: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoFilesResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the video_file_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.video_file_list_with_http_info(
                fixture_id,
                organization_id,
                sport,
                added,
                content,
                external,
                feed_type,
                fields,
                format,
                hide_null,
                include,
                limit,
                locale,
                offset,
                origin,
                provider,
                source_number,
                status,
                storage_provider,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling DownloadVideoApi->video_file_list: %s\n" % e)
            raise

    @validate_arguments
    def video_file_list_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        content: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream "
            ),
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        format: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(description="The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file "),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        origin: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="The origin of the video file >- `STREAM` Streamed >- `UPLOAD` Uploaded >- `VENUE` Recorded in venue "
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        status: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="What is the status of the file? >- `AVAILABLE` Available for access >- `BUILDABLE` Not currently available - but can be built on request >- `PENDING` Being added - some parts may be available "
            ),
        ] = None,
        storage_provider: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Where the video file is stored? >- `5STREAM` 5stream >- `KEEMOTION` Keemotion >- `SYNERGY` Synergy "
            ),
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """List available video files for a fixture  # noqa: E501

        List the video files for a fixture that are available for downloaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_file_list_with_http_info(fixture_id, organization_id, sport, added, content, external, feed_type, fields, format, hide_null, include, limit, locale, offset, origin, provider, source_number, status, storage_provider, updated, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param content: Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream
        :type content: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param format: The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file
        :type format: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param origin: The origin of the video file >- `STREAM` Streamed >- `UPLOAD` Uploaded >- `VENUE` Recorded in venue
        :type origin: str
        :param provider: The unique code for the video provider
        :type provider: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param status: What is the status of the file? >- `AVAILABLE` Available for access >- `BUILDABLE` Not currently available - but can be built on request >- `PENDING` Being added - some parts may be available
        :type status: str
        :param storage_provider: Where the video file is stored? >- `5STREAM` 5stream >- `KEEMOTION` Keemotion >- `SYNERGY` Synergy
        :type storage_provider: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoFilesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "added",
            "content",
            "external",
            "feed_type",
            "fields",
            "format",
            "hide_null",
            "include",
            "limit",
            "locale",
            "offset",
            "origin",
            "provider",
            "source_number",
            "status",
            "storage_provider",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method video_file_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("content") is not None:  # noqa: E501
            _query_params.append(("content", _params["content"].value))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("feed_type") is not None:  # noqa: E501
            _query_params.append(("feedType", _params["feed_type"].value))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("format") is not None:  # noqa: E501
            _query_params.append(("format", _params["format"].value))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("locale") is not None:  # noqa: E501
            _query_params.append(("locale", _params["locale"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("origin") is not None:  # noqa: E501
            _query_params.append(("origin", _params["origin"].value))

        if _params.get("provider") is not None:  # noqa: E501
            _query_params.append(("provider", _params["provider"]))

        if _params.get("source_number") is not None:  # noqa: E501
            _query_params.append(("sourceNumber", _params["source_number"]))

        if _params.get("status") is not None:  # noqa: E501
            _query_params.append(("status", _params["status"].value))

        if _params.get("storage_provider") is not None:  # noqa: E501
            _query_params.append(("storageProvider", _params["storage_provider"].value))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoFilesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/files",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
