# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


import io
import logging
import re  # noqa: F401
import warnings
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.api_response import ApiResponse
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.award_post_body import AwardPostBody
from atriumsports.datacore.openapi.models.award_put_body import AwardPutBody
from atriumsports.datacore.openapi.models.awards_response import AwardsResponse

logger = logging.getLogger("openapi")


class AwardsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def award_delete(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Delete an award  # noqa: E501

        Delete a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.award_delete(award_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the award_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.award_delete_with_http_info(
                award_id, organization_id, sport, external, fields, force_delete, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->award_delete: %s\n" % e)
            raise

    @validate_arguments
    def award_delete_with_http_info(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete an award  # noqa: E501

        Delete a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.award_delete_with_http_info(award_id, organization_id, sport, external, fields, force_delete, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "award_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method award_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["award_id"]:
            _path_params["awardId"] = _params["award_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards/{awardId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_detail(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Get an award  # noqa: E501

        Return detailed information about a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_detail(award_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_detail_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_detail_with_http_info(
                award_id, organization_id, sport, external, fields, hide_null, include, limit, offset, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_detail: %s\n" % e)
            raise

    @validate_arguments
    def awards_detail_with_http_info(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get an award  # noqa: E501

        Return detailed information about a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_detail_with_http_info(award_id, organization_id, sport, external, fields, hide_null, include, limit, offset, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "award_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method awards_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["award_id"]:
            _path_params["awardId"] = _params["award_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards/{awardId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        award_post_body: AwardPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Create an award  # noqa: E501

        Add a new award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_insert(organization_id, sport, award_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param award_post_body: (required)
        :type award_post_body: AwardPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_insert_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_insert_with_http_info(
                organization_id, sport, award_post_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_insert: %s\n" % e)
            raise

    @validate_arguments
    def awards_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        award_post_body: AwardPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create an award  # noqa: E501

        Add a new award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_insert_with_http_info(organization_id, sport, award_post_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param award_post_body: (required)
        :type award_post_body: AwardPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "sport", "award_post_body", "external", "fields", "hide_null", "include"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method awards_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["award_post_body"] is not None:
            _body_params = _params["award_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_list_fixtures(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Get a list of fixture awards  # noqa: E501

        Return a list of awards for the organization (linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_fixtures(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, fixture_id, hide_null, include, limit, offset, person_id, season_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_list_fixtures_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_list_fixtures_with_http_info(
                organization_id,
                sport,
                added,
                award,
                date_from_end,
                date_from_start,
                date_to_end,
                date_to_start,
                entity_id,
                external,
                fields,
                fixture_id,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                season_id,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_list_fixtures: %s\n" % e)
            raise

    @validate_arguments
    def awards_list_fixtures_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of fixture awards  # noqa: E501

        Return a list of awards for the organization (linked to fixtures)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_fixtures_with_http_info(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, fixture_id, hide_null, include, limit, offset, person_id, season_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "award",
            "date_from_end",
            "date_from_start",
            "date_to_end",
            "date_to_start",
            "entity_id",
            "external",
            "fields",
            "fixture_id",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "season_id",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method awards_list_fixtures" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("award") is not None:  # noqa: E501
            _query_params.append(("award", _params["award"].value))

        if _params.get("date_from_end") is not None:  # noqa: E501
            if isinstance(_params["date_from_end"], datetime):
                _query_params.append(
                    ("dateFromEnd", _params["date_from_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateFromEnd", _params["date_from_end"]))

        if _params.get("date_from_start") is not None:  # noqa: E501
            if isinstance(_params["date_from_start"], datetime):
                _query_params.append(
                    (
                        "dateFromStart",
                        _params["date_from_start"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("dateFromStart", _params["date_from_start"]))

        if _params.get("date_to_end") is not None:  # noqa: E501
            if isinstance(_params["date_to_end"], datetime):
                _query_params.append(
                    ("dateToEnd", _params["date_to_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToEnd", _params["date_to_end"]))

        if _params.get("date_to_start") is not None:  # noqa: E501
            if isinstance(_params["date_to_start"], datetime):
                _query_params.append(
                    ("dateToStart", _params["date_to_start"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToStart", _params["date_to_start"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fixture_id") is not None:  # noqa: E501
            _query_params.append(("fixtureId", _params["fixture_id"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards/in/fixtures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_list_non_fixtures(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Get a list of non-fixture awards  # noqa: E501

        Return a list of awards not linked to fixtures  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_non_fixtures(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_list_non_fixtures_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_list_non_fixtures_with_http_info(
                organization_id,
                sport,
                added,
                award,
                date_from_end,
                date_from_start,
                date_to_end,
                date_to_start,
                entity_id,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_list_non_fixtures: %s\n" % e)
            raise

    @validate_arguments
    def awards_list_non_fixtures_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of non-fixture awards  # noqa: E501

        Return a list of awards not linked to fixtures  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_non_fixtures_with_http_info(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "award",
            "date_from_end",
            "date_from_start",
            "date_to_end",
            "date_to_start",
            "entity_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method awards_list_non_fixtures" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("award") is not None:  # noqa: E501
            _query_params.append(("award", _params["award"].value))

        if _params.get("date_from_end") is not None:  # noqa: E501
            if isinstance(_params["date_from_end"], datetime):
                _query_params.append(
                    ("dateFromEnd", _params["date_from_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateFromEnd", _params["date_from_end"]))

        if _params.get("date_from_start") is not None:  # noqa: E501
            if isinstance(_params["date_from_start"], datetime):
                _query_params.append(
                    (
                        "dateFromStart",
                        _params["date_from_start"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("dateFromStart", _params["date_from_start"]))

        if _params.get("date_to_end") is not None:  # noqa: E501
            if isinstance(_params["date_to_end"], datetime):
                _query_params.append(
                    ("dateToEnd", _params["date_to_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToEnd", _params["date_to_end"]))

        if _params.get("date_to_start") is not None:  # noqa: E501
            if isinstance(_params["date_to_start"], datetime):
                _query_params.append(
                    ("dateToStart", _params["date_to_start"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToStart", _params["date_to_start"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_list_seasons(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Get a list of season awards  # noqa: E501

        Return a list of awards for the organization (linked to seasons)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_seasons(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, season_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_list_seasons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_list_seasons_with_http_info(
                organization_id,
                sport,
                added,
                award,
                date_from_end,
                date_from_start,
                date_to_end,
                date_to_start,
                entity_id,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                person_id,
                season_id,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_list_seasons: %s\n" % e)
            raise

    @validate_arguments
    def awards_list_seasons_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        award: Annotated[
            Optional[constr(strict=True, max_length=100)],
            Field(
                description="Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie "
            ),
        ] = None,
        date_from_end: Annotated[Optional[datetime], Field(description="Where dateFrom <= this value")] = None,
        date_from_start: Annotated[Optional[datetime], Field(description="Where dateFrom >= this value")] = None,
        date_to_end: Annotated[Optional[datetime], Field(description="Where dateTo <= this value")] = None,
        date_to_start: Annotated[Optional[datetime], Field(description="Where dateTo >= this value")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a list of season awards  # noqa: E501

        Return a list of awards for the organization (linked to seasons)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_list_seasons_with_http_info(organization_id, sport, added, award, date_from_end, date_from_start, date_to_end, date_to_start, entity_id, external, fields, hide_null, include, limit, offset, person_id, season_id, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param award: Award >- `6th_MAN` Sixth Man >- `ALL_TEAM` All first team >- `COACH` Coach Award >- `DEFENSIVE` Defensive Player >- `DEFENSIVE_TEAM` Defensive team >- `HALL` Hall of Fame >- `HONOUR` Honoured >- `MIP` Most Improved Player >- `MVP` Most Valuable Player >- `OTHER` Other >- `ROOKIE` Rookie
        :type award: str
        :param date_from_end: Where dateFrom <= this value
        :type date_from_end: datetime
        :param date_from_start: Where dateFrom >= this value
        :type date_from_start: datetime
        :param date_to_end: Where dateTo <= this value
        :type date_to_end: datetime
        :param date_to_start: Where dateTo >= this value
        :type date_to_start: datetime
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "award",
            "date_from_end",
            "date_from_start",
            "date_to_end",
            "date_to_start",
            "entity_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "person_id",
            "season_id",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method awards_list_seasons" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            if isinstance(_params["added"], datetime):
                _query_params.append(
                    ("added", _params["added"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("added", _params["added"]))

        if _params.get("award") is not None:  # noqa: E501
            _query_params.append(("award", _params["award"].value))

        if _params.get("date_from_end") is not None:  # noqa: E501
            if isinstance(_params["date_from_end"], datetime):
                _query_params.append(
                    ("dateFromEnd", _params["date_from_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateFromEnd", _params["date_from_end"]))

        if _params.get("date_from_start") is not None:  # noqa: E501
            if isinstance(_params["date_from_start"], datetime):
                _query_params.append(
                    (
                        "dateFromStart",
                        _params["date_from_start"].strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("dateFromStart", _params["date_from_start"]))

        if _params.get("date_to_end") is not None:  # noqa: E501
            if isinstance(_params["date_to_end"], datetime):
                _query_params.append(
                    ("dateToEnd", _params["date_to_end"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToEnd", _params["date_to_end"]))

        if _params.get("date_to_start") is not None:  # noqa: E501
            if isinstance(_params["date_to_start"], datetime):
                _query_params.append(
                    ("dateToStart", _params["date_to_start"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("dateToStart", _params["date_to_start"]))

        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))

        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))

        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))

        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))

        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))

        if _params.get("updated") is not None:  # noqa: E501
            if isinstance(_params["updated"], datetime):
                _query_params.append(
                    ("updated", _params["updated"].strftime(self.api_client.configuration.datetime_format))
                )
            else:
                _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards/in/seasons",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def awards_update(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        award_put_body: AwardPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> AwardsResponse:  # noqa: E501
        """Update an award  # noqa: E501

        Change the information of a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_update(award_id, organization_id, sport, award_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param award_put_body: (required)
        :type award_put_body: AwardPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AwardsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the awards_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        try:
            return self.awards_update_with_http_info(
                award_id, organization_id, sport, award_put_body, external, fields, hide_null, include, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling AwardsApi->awards_update: %s\n" % e)
            raise

    @validate_arguments
    def awards_update_with_http_info(
        self,
        award_id: Annotated[StrictStr, Field(..., description="The unique identifier of the award")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        award_put_body: AwardPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update an award  # noqa: E501

        Change the information of a specific award  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.awards_update_with_http_info(award_id, organization_id, sport, award_put_body, external, fields, hide_null, include, async_req=True)
        >>> result = thread.get()

        :param award_id: The unique identifier of the award (required)
        :type award_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param award_put_body: (required)
        :type award_put_body: AwardPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AwardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "award_id",
            "organization_id",
            "sport",
            "award_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method awards_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["award_id"]:
            _path_params["awardId"] = _params["award_id"]

        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]

        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))

        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))

        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["award_put_body"] is not None:
            _body_params = _params["award_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "AwardsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/awards/{awardId}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
