# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['volttron',
 'volttron.driver.interfaces.modbus_tk',
 'volttron.driver.interfaces.modbus_tk.utils',
 'volttron.driver.interfaces.modbus_tk.utils.maps']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'modbus-tk>=1.1.2,<2.0.0',
 'pyserial>=3.5,<4.0',
 'volttron-lib-base-driver>=0.2.0rc0,<0.3.0']

setup_kwargs = {
    'name': 'volttron-lib-modbustk-driver',
    'version': '0.1.1a1',
    'description': 'ModbusTK Driver supported and maintained by the Volttron team.',
    'long_description': '# volttron-lib-modbustk-driver\n\n![Passing?](https://github.com/VOLTTRON/volttron-lib-modbustk-driver/actions/workflows/run-tests.yml/badge.svg)\n[![pypi version](https://img.shields.io/pypi/v/volttron-lib-modbustk-driver.svg)](https://pypi.org/project/volttron-lib-modbustk-driver/)\n\nVOLTTRON’s Modbus-TK driver, built on the Python Modbus-TK library, is an alternative to the original VOLTTRON modbus driver. Unlike the original modbus driver, the Modbus-TK driver supports Modbus RTU as well as Modbus over TCP/IP.\n\n# Prerequisites\n\n* Python 3.8\n\n# Installation\n\n1. Create and activate a virtual environment.\n\n    ```shell\n    python -m venv env\n    source env/bin/activate\n    ```\n\n1. Install volttron and start the platform.\n\n    ```shell\n    pip install volttron\n\n    # Start platform with output going to volttron.log\n    volttron -vv -l volttron.log &\n    ```\n\n1. Install the volttron platform driver:\n\n    ```shell\n    vctl install volttron-platform-driver --vip-identity platform.driver --start\n    ```\n\n1. Install the volttron-lib-modbustk-driver library.\n\n    ```shell\n    pip install volttron-lib-modbustk-driver\n    ```\n\n1. Install the driver onto the Platform Driver.\n\n    Installing a driver in the Platform Driver Agent requires adding copies of the device configuration and registry configuration files to the Platform Driver’s configuration store.\n\n    Create a config directory and navigate to it:\n\n    ```shell\n    mkdir config\n    cd config\n    ```\n\n1. Add driver configurations to the Platform Driver.\n\n   The Modbus-TK driver is mostly backward-compatible with the parameter definitions in the original Modbus driver’s configuration (.config and .csv files). If the config file’s parameter names use the Modbus driver’s name conventions, they are translated to the Modbus-TK name conventions, e.g. a Modbus CSV file’s Point Address is interpreted as a Modbus-TK “Address”. Backward-compatibility exceptions are:\n\n        * If the config file has no port, the default is 0, not 502.\n\n        * If the config file has no slave_id, the default is 1, not 0.\n\n    The driver_config section of a Modbus-TK device configuration file supports a variety of parameter definitions, but only *device_address* is required:\n\n    * device_address (Required):  IP Address of the device.\n\n    * name (Optional) - Name of the device. Defaults to “UNKNOWN”.\n\n    * device_type (Optional) - Name of the device type. Defaults to “UNKNOWN”.\n\n    * port (Optional) - Port the device is listening on. Defaults to 0 (no port). Use port 0 for RTU transport.\n\n    * slave_id (Optional) - Slave ID of the device. Defaults to 1. Use ID 0 for no slave.\n\n    * baudrate (Optional) - Serial (RTU) baud rate. Defaults to 9600.\n\n    * bytesize (Optional) - Serial (RTU) byte size: 5, 6, 7, or 8. Defaults to 8.\n\n    * parity (Optional) - Serial (RTU) parity: none, even, odd, mark, or space. Defaults to None.\n\n    * stopbits (Optional) - Serial (RTU) stop bits: 1, 1.5, or 2. Defaults to 1.\n\n    * xonxoff (Optional) - Serial (RTU) flow control: 0 or 1. Defaults to 0.\n\n    * addressing (Optional) - Data address table: offset, offset_plus, or address. Defaults to offset.\n\n      * address: The exact value of the address without any offset value.\n\n      * offset: The value of the address plus the offset value.\n\n      * offset_plus: The value of the address plus the offset value plus one.\n\n      * : If an offset value is to be added, it is determined based on a point’s properties in the CSV file:\n\n        * Type=bool, Writable=TRUE: 0\n\n        * Type=bool, Writable=FALSE: 10000\n\n        * Type!=bool, Writable=TRUE: 30000\n\n        * Type!=bool, Writable=FALSE: 40000\n\n    * endian (Optional) - Byte order: big or little. Defaults to big.\n\n    * write_multiple_registers (Optional) - Write multiple coils or registers at a time. Defaults to true.\n\n      * If write_multiple_registers is set to false, only register types unsigned short (uint16) and boolean (bool) are supported. The exception raised during the configure process.\n\n    * register_map (Optional) - Register map csv of unchanged register variables. Defaults to registry_config csv.\n\n    This repo provides an example configuration in the file "modbus_tk_example.config".\n\n    Here is an example device configuration file:\n\n    ```json\n        {\n        "driver_config": {\n            "device_address": "10.1.1.2",\n            "port": "5020",\n            "register_map": "config://modbus_tk_test_map.csv"\n        },\n        "driver_type": "modbus_tk",\n        "registry_config": "config://modbus_tk_test.csv",\n        "interval": 60,\n        "timezone": "UTC",\n        "heart_beat_point": "heartbeat"\n        }\n    ```\n\n    After creating a driver configuration file named "modbus_tk_example.config", add it to the Configuration Store:\n\n    ```shell\n    vctl config store platform.driver devices/modbustk modbus_tk_example.config\n    ```\n\n1. Add a Modbus-TK Register Map CSV File to the Platform Driver.\n\n    Modbus TK requires an additional registry configuration file compared to the paradigm of most other drivers. The registry map file is an analogue to the typical registry configuration file. The registry configuration file is a simple file which maps device point names to user specified point names.\n\n    This repo provides an example configuration in the file "modbus_tk_test_map.csv".\n\n    The registry map file is a CSV file. Each row configures a register definition on the device.\n\n    Register Name (Required) - The field name in the modbus client. This field is distinct and unchangeable.\n\n    Address (Required) - The point’s modbus address. The addressing option in the driver configuration controls whether this is interpreted as an exact address or an offset.\n\n    Type (Required) - The point’s data type: bool, string[length], float, int16, int32, int64, uint16, uint32, or uint64.\n\n    Units (Optional) - Used for metadata when creating point information on a historian. Default is an empty string.\n\n    Writable (Optional) - TRUE/FALSE. Only points for which Writable=TRUE can be updated by a VOLTTRON agent. Default is FALSE.\n\n    Default Value (Optional) - The point’s default value. If it is reverted by an agent, it changes back to this value. If this value is missing, it will revert to the last known value not set by an agent.\n\n    Transform (Optional) - Scaling algorithm: scale(multiplier), scale_int(multiplier), scale_reg(register_name), scale_reg_power10(register_name), scale_decimal_int_signed(multiplier), mod10k(reverse), mod10k64(reverse), mod10k48(reveres) or none. Default is an empty string.\n\n    Table (Optional) - Standard modbus table name defining how information is stored in slave device. There are 4 different tables:\n\n    discrete_output_coils: read/write coil numbers 1-9999\n\n    discrete_input_contacts: read only coil numbers 10001-19999\n\n    analog_input_registers: read only register numbers 30001-39999\n\n    analog_output_holding_registers: read/write register numbers 40001-49999\n\n    If this field is empty, the modbus table will be defined by type and writable fields. By that, when user sets read only for read/write coils/registers or sets read/write for read only coils/registers, it will select wrong table, and therefore raise exception.\n\n    Mixed Endian (Optional) - TRUE/FALSE. If Mixed Endian is set to TRUE, the order of the Modbus registers will be reversed before parsing the value or writing it out to the device. By setting mixed endian, transform must be None (no op). Defaults to FALSE.\n\n    Description (Optional) - Additional information about the point. Default is an empty string.\n\n    Here is a sample Modbus-TK registry map:\n\n    ```csv\n    Register Name,Address,Type,Units,Writable,Default Value,Transform,Table\n    unsigned_short,0,uint16,None,TRUE,0,scale(10),analog_output_holding_registers\n    unsigned_int,1,uint32,None,TRUE,0,scale(10),analog_output_holding_registers\n    unsigned_long,3,uint64,None,TRUE,0,scale(10),analog_output_holding_registers\n    sample_short,7,int16,None,TRUE,0,scale(10),analog_output_holding_registers\n    sample_int,8,int32,None,TRUE,0,scale(10),analog_output_holding_registers\n    sample_float,10,float,None,TRUE,0.0,scale(10),analog_output_holding_registers\n    sample_long,12,int64,None,TRUE,0,scale(10),analog_output_holding_registers\n    sample_bool,16,bool,None,TRUE,False,,analog_output_holding_registers\n    sample_str,17,string[12],None,TRUE,hello world!,,analog_output_holding_registers\n    ```\n\n    After creating a registry map named "modbus_tk_test_map.csv", add it to the Configuration Store:\n\n    ```shell\n    vctl config store platform.driver modbus_tk_test_map.csv modbus_tk_test_map.csv --csv\n    ```\n\n1. Add a registry configuration to the PlatformDriver.\n\n    The registry configuration file is a CSV file. Each row configures a point on the device.\n\n        Volttron Point Name (Required) - The name by which the platform and agents refer to the point. For instance, if the Volttron Point Name is HeatCall1, then an agent would use my_campus/building2/hvac1/HeatCall1 to refer to the point when using the RPC interface of the actuator agent.\n\n        Register Name (Required) - The field name in the modbus client. It must be matched with the field name from register_map.\n\n    Any additional columns will override the existed fields from register_map.\n\n    Here is a sample Modbus-TK registry configuration with defined register_map:\n\n    ```csv\n    Volttron Point Name,Register Name\n    unsigned short,unsigned_short\n    unsigned int,unsigned_int\n    unsigned long,unsigned_long\n    sample short,sample_short\n    sample int,sample_int\n    sample float,sample_float\n    sample long,sample_long\n    sample bool,sample_bool\n    sample str,sample_str\n    ```\n\n    After creating a registry map named "modbus_tk_test.csv", add it to the Configuration Store:\n\n    ```shell\n    vctl config store platform.driver modbus_tk_test.csv modbus_tk_test.csv --csv\n    ```\n\n1. Observe Data\n\n    To see data being published to the bus, install a [Listener Agent](https://pypi.org/project/volttron-listener/):\n\n    ```\n    vctl install volttron-listener --start\n    ```\n\n    Once installed, you should see the data being published by viewing the Volttron logs file that was created in step 2.\n    To watch the logs, open a separate terminal and run the following command:\n\n    ```\n    tail -f <path to folder containing volttron.log>/volttron.log\n    ```\n\n# Modbus-TK Config Command Tool\n\n`config_cmd.py` is a command-line tool for creating and maintaining VOLTTRON driver configurations. The tool runs from the command line:\n\nconfig_cmd.py supports the following commands:\n\n* help - List all commands.\n\n* quit - Quit the command-line tool.\n\n* list_directories - List all setup directories, with an option to edit their paths.\n\n\nBy default, all directories are in this repo at the following folder: volttron/driver/interfaces/modbus_tk/utils/maps.\n\nIt is important to use the correct directories when adding/editing device types and driver configs, and when loading configurations into VOLTTRON.\n\n* map_dir: directory in which maps.yaml is stored.\n\n* config_dir: directory in which driver config files are stored.\n\n* csv_dir: directory in which registry config CSV files are stored.\n\n* edit_directories - Add/Edit map directory, driver config directory, and/or CSV config directory. Press <Enter> if no change is needed. Exits if the directory does not exist.\n\n* list_device_type_description - List all device type descriptions in maps.yaml. Option to edit device type descriptions.\n\n* list_all_device_types - List all device type information in maps.yaml. Option to add more device types.\n\n* device_type - List information for a selected device type. Option to select another device type.\n\n* add_device_type - Add a device type to maps.yaml. Option to add more than one device type. Each device type includes its name, CSV file, description, addressing, and endian, as explained in MODBUS-TK Driver Maps. If an invalid value is entered for addressing or endian, the default value is used instead.\n\n*edit_device_type - Edit an existing device type. If an invalid value is entered for addressing or endian, the previous value is left unchanged.\n\n* list_drivers - List all driver config names in config_dir.\n\n* driver_config <driver_name> - Get a driver config from config_dir. Option to select the driver if no driver is found with that name.\n\n* add_driver_config <driver_name> - Add/Edit <config_dir>/<driver name>.config. Option to select the driver if no driver is found with that name. Press <Enter> to exit.\n\n* load_volttron - Load a driver config and CSV into VOLTTRON. Option to add the config or CSV file to config_dir or to csv_dir. VOLTTRON must be running when this command is used.\n\n* delete_volttron_config - Delete a driver config from VOLTTRON. VOLTTRON must be running when this command is used.\n\n* delete_volttron_csv - Delete a registry csv config from VOLTTRON. VOLTTRON must be running when this command is used.\n\n# Development\n\nPlease see the following for contributing guidelines [contributing](https://github.com/eclipse-volttron/volttron-core/blob/develop/CONTRIBUTING.md).\n\nPlease see the following helpful guide about [developing modular VOLTTRON agents](https://github.com/eclipse-volttron/volttron-core/blob/develop/DEVELOPING_ON_MODULAR.md)\n\n\n# Disclaimer Notice\n\nThis material was prepared as an account of work sponsored by an agency of the\nUnited States Government.  Neither the United States Government nor the United\nStates Department of Energy, nor Battelle, nor any of their employees, nor any\njurisdiction or organization that has cooperated in the development of these\nmaterials, makes any warranty, express or implied, or assumes any legal\nliability or responsibility for the accuracy, completeness, or usefulness or any\ninformation, apparatus, product, software, or process disclosed, or represents\nthat its use would not infringe privately owned rights.\n\nReference herein to any specific commercial product, process, or service by\ntrade name, trademark, manufacturer, or otherwise does not necessarily\nconstitute or imply its endorsement, recommendation, or favoring by the United\nStates Government or any agency thereof, or Battelle Memorial Institute. The\nviews and opinions of authors expressed herein do not necessarily state or\nreflect those of the United States Government or any agency thereof.\n',
    'author': 'Mark Bonicillo',
    'author_email': 'volttron@pnnl.gov',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/VOLTTRON/volttron-drivers/volttron-lib-modbustk-driver',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
