"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const s3n = require("aws-cdk-lib/aws-s3-notifications");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const core_1 = require("@aws-solutions-constructs/core");
/**
 * @summary The S3ToSqs class.
 */
class S3ToSqs extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the S3ToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {S3ToSqsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the S3 bucket
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the queue
        [this.sqsQueue, this.encryptionKey] = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        // Setup the S3 bucket event types
        let s3EventTypes;
        if (!props.s3EventTypes) {
            s3EventTypes = defaults.defaultS3NotificationEventTypes;
        }
        else {
            s3EventTypes = props.s3EventTypes;
        }
        // Setup the S3 bucket event filters
        let s3Eventfilters = [];
        if (props.s3EventFilters) {
            s3Eventfilters = props.s3EventFilters;
        }
        // Setup the S3 bucket event notifications
        s3EventTypes.forEach(type => bucket.addEventNotification(type, new s3n.SqsDestination(this.sqsQueue), ...s3Eventfilters));
        core_1.addCfnNagS3BucketNotificationRulesToSuppress(aws_cdk_lib_1.Stack.of(this), 'BucketNotificationsHandler050a0587b7544547bf325f094a3db834');
    }
}
exports.S3ToSqs = S3ToSqs;
_a = JSII_RTTI_SYMBOL_1;
S3ToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-s3-sqs.S3ToSqs", version: "2.28.0" };
//# sourceMappingURL=data:application/json;base64,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