<p align="center">
<img alt="Logo" src="static/git_head.png"/ width="600">
</p>

<p align="center">
<a href="https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg"><img src="https://img.shields.io/badge/join-Slack-ff69b4"/></a>
<a href="https://docs.elementary-data.com/"><img src="https://img.shields.io/badge/docs-quickstart-orange"/></a>
<img alt="License" src="https://img.shields.io/badge/license-Apache--2.0-brightgreen"/>

## Use cases
Monitor your data warehouse in minutes:
* **Data anomalies monitoring as dbt tests**
* **Data lineage made simple, reliable, and automated**
* **dbt operational monitoring**
* **Slack alerts**
  
:star: Support us with a <a href="https://github.com/elementary-data/elementary-lineage/stargazers"><img src="static/star_github.png" width="40"/></a> :star:
 

## Quick start
  
[Quick start: Data monitoring as dbt tests in minutes](https://docs.elementary-data.com/quickstart). 

[Quick start: Data lineage](https://docs.elementary-data.com/quickstart-data-lineage/install-and-configure). 

Our full documentation is [available here](https://docs.elementary-data.com/). 

##
Join our [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) to learn more on Elementary.

(Not a dbt user? you can still use Elementary data monitoring, reach out to us on Slack and we will help).
  
  
## Data anomalies monitoring as dbt tests

Elementary delivers **data monitoring and anomaly detection as dbt tests.** 
  
Elementary dbt tests are data monitors that collect metrics and metadata over time. 
On each execution, the tests analyze the new data, compare it to historical metrics, and alert on anomalies and outliers. 
  
**Elementary data monitors as tests are configured and executed like native tests in your project!**


## Demo & sandbox

Data anomalies monitoring as dbt tests [demo video](https://www.elementary-data.com/demo).  
Try out our live lineage [sandbox here](https://www.elementary-data.com/live-demo).

<img alt="Slack" src="static/Slack_alerts_new_format.png" width="450">       <img alt="configuration" src="static/properties_yml_.png" width="320">
  



## Community & Support

For additional information and help, you can use one of these channels:

* [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) \(Live chat with the team, support, discussions, etc.\)
* [GitHub issues](https://github.com/elementary-data/elementary-lineage/issues) \(Bug reports, feature requests)
* [Roadmap](https://github.com/elementary-data/elementary-lineage/projects/1) \(Vote for features and add your inputs)
* [Twitter](https://twitter.com/ElementaryData) \(Updates on new releases and stuff)

## **Integrations**

* [x] **Snowflake** ![](static/snowflake-16.png) 
* [x] **BigQuery**  ![](static/bigquery-16.png) 
* [x] **Redshift**  ![](static/redshift-16.png) - Data monitoring

Ask us for integrations on [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) or as a [GitHub issue](https://github.com/elementary-data/elementary-lineage/issues/new).

## **License**

Elementary is licensed under Apache License 2.0. See the [LICENSE](https://github.com/elementary-data/elementary-lineage/blob/master/LICENSE) file for licensing information.
