"""Interface of Meta-RL ALgorithms."""
import abc

from garage.np.algos.rl_algorithm import RLAlgorithm


class MetaRLAlgorithm(RLAlgorithm, abc.ABC):
    """Base class for Meta-RL Algorithms."""

    @abc.abstractmethod
    def get_exploration_policy(self):
        """Return a policy used before adaptation to a specific task.

        Each time it is retrieved, this policy should only be evaluated in one
        task.

        Returns:
            Policy: The policy used to obtain samples, which are later used for
                meta-RL adaptation.

        """

    @abc.abstractmethod
    def adapt_policy(self, exploration_policy, exploration_episodes):
        """Produce a policy adapted for a task.

        Args:
            exploration_policy (Policy): A policy which was returned from
                get_exploration_policy(), and which generated
                exploration_trajectories by interacting with an environment.
                The caller may not use this object after passing it into this
                method.
            exploration_episodes (EpisodeBatch): Episodes with which to adapt.
                These are generated by exploration_policy while exploring the
                environment.

        Returns:
            Policy: A policy adapted to the task represented by the
                exploration_episodes.

        """
