# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.23.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.company_summary import CompanySummary  # noqa: F401,E501


class ZacksEPSGrowthRate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ticker': 'str',
        'company_name': 'str',
        'industry_group_number': 'str',
        'industry_group_name': 'str',
        'fiscal_year_0': 'int',
        'fiscal_year_1': 'int',
        'fiscal_year_2': 'int',
        'company_last_5_year_actual': 'float',
        'company_fiscal_year_1_vs_fiscal_year_0': 'float',
        'company_fiscal_year_2_vs_fiscal_year_1': 'float',
        'company_long_term_growth_mean': 'float',
        'company_fiscal_year_1_forward_price_to_earnings': 'float',
        'industry_last_5_year_actual': 'float',
        'industry_fiscal_year_1_vs_fiscal_year_0': 'float',
        'industry_fiscal_year_2_vs_fiscal_year_1': 'float',
        'industry_long_term_growth_mean': 'float',
        'industry_fiscal_year_1_forward_price_to_earnings': 'float',
        'sp500_last_5_year_actual': 'float',
        'sp500_fiscal_year_1_vs_fiscal_year_0': 'float',
        'sp500_fiscal_year_2_vs_fiscal_year_1': 'float',
        'sp500_long_term_growth': 'float',
        'sp500_fiscal_year_1_price_to_earnings': 'float',
        'company': 'CompanySummary'
    }

    attribute_map = {
        'ticker': 'ticker',
        'company_name': 'company_name',
        'industry_group_number': 'industry_group_number',
        'industry_group_name': 'industry_group_name',
        'fiscal_year_0': 'fiscal_year_0',
        'fiscal_year_1': 'fiscal_year_1',
        'fiscal_year_2': 'fiscal_year_2',
        'company_last_5_year_actual': 'company_last_5_year_actual',
        'company_fiscal_year_1_vs_fiscal_year_0': 'company_fiscal_year_1_vs_fiscal_year_0',
        'company_fiscal_year_2_vs_fiscal_year_1': 'company_fiscal_year_2_vs_fiscal_year_1',
        'company_long_term_growth_mean': 'company_long_term_growth_mean',
        'company_fiscal_year_1_forward_price_to_earnings': 'company_fiscal_year_1_forward_price_to_earnings',
        'industry_last_5_year_actual': 'industry_last_5_year_actual',
        'industry_fiscal_year_1_vs_fiscal_year_0': 'industry_fiscal_year_1_vs_fiscal_year_0',
        'industry_fiscal_year_2_vs_fiscal_year_1': 'industry_fiscal_year_2_vs_fiscal_year_1',
        'industry_long_term_growth_mean': 'industry_long_term_growth_mean',
        'industry_fiscal_year_1_forward_price_to_earnings': 'industry_fiscal_year_1_forward_price_to_earnings',
        'sp500_last_5_year_actual': 'sp500_last_5_year_actual',
        'sp500_fiscal_year_1_vs_fiscal_year_0': 'sp500_fiscal_year_1_vs_fiscal_year_0',
        'sp500_fiscal_year_2_vs_fiscal_year_1': 'sp500_fiscal_year_2_vs_fiscal_year_1',
        'sp500_long_term_growth': 'sp500_long_term_growth',
        'sp500_fiscal_year_1_price_to_earnings': 'sp500_fiscal_year_1_price_to_earnings',
        'company': 'company'
    }

    def __init__(self, ticker=None, company_name=None, industry_group_number=None, industry_group_name=None, fiscal_year_0=None, fiscal_year_1=None, fiscal_year_2=None, company_last_5_year_actual=None, company_fiscal_year_1_vs_fiscal_year_0=None, company_fiscal_year_2_vs_fiscal_year_1=None, company_long_term_growth_mean=None, company_fiscal_year_1_forward_price_to_earnings=None, industry_last_5_year_actual=None, industry_fiscal_year_1_vs_fiscal_year_0=None, industry_fiscal_year_2_vs_fiscal_year_1=None, industry_long_term_growth_mean=None, industry_fiscal_year_1_forward_price_to_earnings=None, sp500_last_5_year_actual=None, sp500_fiscal_year_1_vs_fiscal_year_0=None, sp500_fiscal_year_2_vs_fiscal_year_1=None, sp500_long_term_growth=None, sp500_fiscal_year_1_price_to_earnings=None, company=None):  # noqa: E501
        """ZacksEPSGrowthRate - a model defined in Swagger"""  # noqa: E501

        self._ticker = None
        self._company_name = None
        self._industry_group_number = None
        self._industry_group_name = None
        self._fiscal_year_0 = None
        self._fiscal_year_1 = None
        self._fiscal_year_2 = None
        self._company_last_5_year_actual = None
        self._company_fiscal_year_1_vs_fiscal_year_0 = None
        self._company_fiscal_year_2_vs_fiscal_year_1 = None
        self._company_long_term_growth_mean = None
        self._company_fiscal_year_1_forward_price_to_earnings = None
        self._industry_last_5_year_actual = None
        self._industry_fiscal_year_1_vs_fiscal_year_0 = None
        self._industry_fiscal_year_2_vs_fiscal_year_1 = None
        self._industry_long_term_growth_mean = None
        self._industry_fiscal_year_1_forward_price_to_earnings = None
        self._sp500_last_5_year_actual = None
        self._sp500_fiscal_year_1_vs_fiscal_year_0 = None
        self._sp500_fiscal_year_2_vs_fiscal_year_1 = None
        self._sp500_long_term_growth = None
        self._sp500_fiscal_year_1_price_to_earnings = None
        self._company = None
        self.discriminator = None

        if ticker is not None:
            self.ticker = ticker
        if company_name is not None:
            self.company_name = company_name
        if industry_group_number is not None:
            self.industry_group_number = industry_group_number
        if industry_group_name is not None:
            self.industry_group_name = industry_group_name
        if fiscal_year_0 is not None:
            self.fiscal_year_0 = fiscal_year_0
        if fiscal_year_1 is not None:
            self.fiscal_year_1 = fiscal_year_1
        if fiscal_year_2 is not None:
            self.fiscal_year_2 = fiscal_year_2
        if company_last_5_year_actual is not None:
            self.company_last_5_year_actual = company_last_5_year_actual
        if company_fiscal_year_1_vs_fiscal_year_0 is not None:
            self.company_fiscal_year_1_vs_fiscal_year_0 = company_fiscal_year_1_vs_fiscal_year_0
        if company_fiscal_year_2_vs_fiscal_year_1 is not None:
            self.company_fiscal_year_2_vs_fiscal_year_1 = company_fiscal_year_2_vs_fiscal_year_1
        if company_long_term_growth_mean is not None:
            self.company_long_term_growth_mean = company_long_term_growth_mean
        if company_fiscal_year_1_forward_price_to_earnings is not None:
            self.company_fiscal_year_1_forward_price_to_earnings = company_fiscal_year_1_forward_price_to_earnings
        if industry_last_5_year_actual is not None:
            self.industry_last_5_year_actual = industry_last_5_year_actual
        if industry_fiscal_year_1_vs_fiscal_year_0 is not None:
            self.industry_fiscal_year_1_vs_fiscal_year_0 = industry_fiscal_year_1_vs_fiscal_year_0
        if industry_fiscal_year_2_vs_fiscal_year_1 is not None:
            self.industry_fiscal_year_2_vs_fiscal_year_1 = industry_fiscal_year_2_vs_fiscal_year_1
        if industry_long_term_growth_mean is not None:
            self.industry_long_term_growth_mean = industry_long_term_growth_mean
        if industry_fiscal_year_1_forward_price_to_earnings is not None:
            self.industry_fiscal_year_1_forward_price_to_earnings = industry_fiscal_year_1_forward_price_to_earnings
        if sp500_last_5_year_actual is not None:
            self.sp500_last_5_year_actual = sp500_last_5_year_actual
        if sp500_fiscal_year_1_vs_fiscal_year_0 is not None:
            self.sp500_fiscal_year_1_vs_fiscal_year_0 = sp500_fiscal_year_1_vs_fiscal_year_0
        if sp500_fiscal_year_2_vs_fiscal_year_1 is not None:
            self.sp500_fiscal_year_2_vs_fiscal_year_1 = sp500_fiscal_year_2_vs_fiscal_year_1
        if sp500_long_term_growth is not None:
            self.sp500_long_term_growth = sp500_long_term_growth
        if sp500_fiscal_year_1_price_to_earnings is not None:
            self.sp500_fiscal_year_1_price_to_earnings = sp500_fiscal_year_1_price_to_earnings
        if company is not None:
            self.company = company

    @property
    def ticker(self):
        """Gets the ticker of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks common exchange ticker  # noqa: E501

        :return: The ticker of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._ticker
        
    @property
    def ticker_dict(self):
        """Gets the ticker of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks common exchange ticker as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ticker of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ticker': value }

        
        return result
        

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this ZacksEPSGrowthRate.

        The Zacks common exchange ticker  # noqa: E501

        :param ticker: The ticker of this ZacksEPSGrowthRate.  # noqa: E501
        :type: str
        """

        self._ticker = ticker

    @property
    def company_name(self):
        """Gets the company_name of this ZacksEPSGrowthRate.  # noqa: E501

        The company name  # noqa: E501

        :return: The company_name of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._company_name
        
    @property
    def company_name_dict(self):
        """Gets the company_name of this ZacksEPSGrowthRate.  # noqa: E501

        The company name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_name of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.company_name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_name': value }

        
        return result
        

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this ZacksEPSGrowthRate.

        The company name  # noqa: E501

        :param company_name: The company_name of this ZacksEPSGrowthRate.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    @property
    def industry_group_number(self):
        """Gets the industry_group_number of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks industry group number  # noqa: E501

        :return: The industry_group_number of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._industry_group_number
        
    @property
    def industry_group_number_dict(self):
        """Gets the industry_group_number of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks industry group number as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_group_number of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.industry_group_number
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_group_number': value }

        
        return result
        

    @industry_group_number.setter
    def industry_group_number(self, industry_group_number):
        """Sets the industry_group_number of this ZacksEPSGrowthRate.

        The Zacks industry group number  # noqa: E501

        :param industry_group_number: The industry_group_number of this ZacksEPSGrowthRate.  # noqa: E501
        :type: str
        """

        self._industry_group_number = industry_group_number

    @property
    def industry_group_name(self):
        """Gets the industry_group_name of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks industry group name  # noqa: E501

        :return: The industry_group_name of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._industry_group_name
        
    @property
    def industry_group_name_dict(self):
        """Gets the industry_group_name of this ZacksEPSGrowthRate.  # noqa: E501

        The Zacks industry group name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_group_name of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.industry_group_name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_group_name': value }

        
        return result
        

    @industry_group_name.setter
    def industry_group_name(self, industry_group_name):
        """Sets the industry_group_name of this ZacksEPSGrowthRate.

        The Zacks industry group name  # noqa: E501

        :param industry_group_name: The industry_group_name of this ZacksEPSGrowthRate.  # noqa: E501
        :type: str
        """

        self._industry_group_name = industry_group_name

    @property
    def fiscal_year_0(self):
        """Gets the fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The current fiscal year  # noqa: E501

        :return: The fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._fiscal_year_0
        
    @property
    def fiscal_year_0_dict(self):
        """Gets the fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The current fiscal year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.fiscal_year_0
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fiscal_year_0': value }

        
        return result
        

    @fiscal_year_0.setter
    def fiscal_year_0(self, fiscal_year_0):
        """Sets the fiscal_year_0 of this ZacksEPSGrowthRate.

        The current fiscal year  # noqa: E501

        :param fiscal_year_0: The fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: int
        """

        self._fiscal_year_0 = fiscal_year_0

    @property
    def fiscal_year_1(self):
        """Gets the fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The next fiscal year  # noqa: E501

        :return: The fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._fiscal_year_1
        
    @property
    def fiscal_year_1_dict(self):
        """Gets the fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The next fiscal year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.fiscal_year_1
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fiscal_year_1': value }

        
        return result
        

    @fiscal_year_1.setter
    def fiscal_year_1(self, fiscal_year_1):
        """Sets the fiscal_year_1 of this ZacksEPSGrowthRate.

        The next fiscal year  # noqa: E501

        :param fiscal_year_1: The fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: int
        """

        self._fiscal_year_1 = fiscal_year_1

    @property
    def fiscal_year_2(self):
        """Gets the fiscal_year_2 of this ZacksEPSGrowthRate.  # noqa: E501

        The fiscal year after the next fiscal year  # noqa: E501

        :return: The fiscal_year_2 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._fiscal_year_2
        
    @property
    def fiscal_year_2_dict(self):
        """Gets the fiscal_year_2 of this ZacksEPSGrowthRate.  # noqa: E501

        The fiscal year after the next fiscal year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fiscal_year_2 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.fiscal_year_2
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fiscal_year_2': value }

        
        return result
        

    @fiscal_year_2.setter
    def fiscal_year_2(self, fiscal_year_2):
        """Sets the fiscal_year_2 of this ZacksEPSGrowthRate.

        The fiscal year after the next fiscal year  # noqa: E501

        :param fiscal_year_2: The fiscal_year_2 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: int
        """

        self._fiscal_year_2 = fiscal_year_2

    @property
    def company_last_5_year_actual(self):
        """Gets the company_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The company's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The company_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._company_last_5_year_actual
        
    @property
    def company_last_5_year_actual_dict(self):
        """Gets the company_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The company's last 5 year actual percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.company_last_5_year_actual
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_last_5_year_actual': value }

        
        return result
        

    @company_last_5_year_actual.setter
    def company_last_5_year_actual(self, company_last_5_year_actual):
        """Sets the company_last_5_year_actual of this ZacksEPSGrowthRate.

        The company's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param company_last_5_year_actual: The company_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._company_last_5_year_actual = company_last_5_year_actual

    @property
    def company_fiscal_year_1_vs_fiscal_year_0(self):
        """Gets the company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The company's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._company_fiscal_year_1_vs_fiscal_year_0
        
    @property
    def company_fiscal_year_1_vs_fiscal_year_0_dict(self):
        """Gets the company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The company's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.company_fiscal_year_1_vs_fiscal_year_0
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_fiscal_year_1_vs_fiscal_year_0': value }

        
        return result
        

    @company_fiscal_year_1_vs_fiscal_year_0.setter
    def company_fiscal_year_1_vs_fiscal_year_0(self, company_fiscal_year_1_vs_fiscal_year_0):
        """Sets the company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.

        The company's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param company_fiscal_year_1_vs_fiscal_year_0: The company_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._company_fiscal_year_1_vs_fiscal_year_0 = company_fiscal_year_1_vs_fiscal_year_0

    @property
    def company_fiscal_year_2_vs_fiscal_year_1(self):
        """Gets the company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The company's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._company_fiscal_year_2_vs_fiscal_year_1
        
    @property
    def company_fiscal_year_2_vs_fiscal_year_1_dict(self):
        """Gets the company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The company's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.company_fiscal_year_2_vs_fiscal_year_1
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_fiscal_year_2_vs_fiscal_year_1': value }

        
        return result
        

    @company_fiscal_year_2_vs_fiscal_year_1.setter
    def company_fiscal_year_2_vs_fiscal_year_1(self, company_fiscal_year_2_vs_fiscal_year_1):
        """Sets the company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.

        The company's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param company_fiscal_year_2_vs_fiscal_year_1: The company_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._company_fiscal_year_2_vs_fiscal_year_1 = company_fiscal_year_2_vs_fiscal_year_1

    @property
    def company_long_term_growth_mean(self):
        """Gets the company_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501

        The company's long term growth rate mean estimate  # noqa: E501

        :return: The company_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._company_long_term_growth_mean
        
    @property
    def company_long_term_growth_mean_dict(self):
        """Gets the company_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501

        The company's long term growth rate mean estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.company_long_term_growth_mean
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_long_term_growth_mean': value }

        
        return result
        

    @company_long_term_growth_mean.setter
    def company_long_term_growth_mean(self, company_long_term_growth_mean):
        """Sets the company_long_term_growth_mean of this ZacksEPSGrowthRate.

        The company's long term growth rate mean estimate  # noqa: E501

        :param company_long_term_growth_mean: The company_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._company_long_term_growth_mean = company_long_term_growth_mean

    @property
    def company_fiscal_year_1_forward_price_to_earnings(self):
        """Gets the company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The company's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :return: The company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._company_fiscal_year_1_forward_price_to_earnings
        
    @property
    def company_fiscal_year_1_forward_price_to_earnings_dict(self):
        """Gets the company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The company's forward (current fiscal year) price-to-earnings (P/E) ratio as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.company_fiscal_year_1_forward_price_to_earnings
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_fiscal_year_1_forward_price_to_earnings': value }

        
        return result
        

    @company_fiscal_year_1_forward_price_to_earnings.setter
    def company_fiscal_year_1_forward_price_to_earnings(self, company_fiscal_year_1_forward_price_to_earnings):
        """Sets the company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.

        The company's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :param company_fiscal_year_1_forward_price_to_earnings: The company_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._company_fiscal_year_1_forward_price_to_earnings = company_fiscal_year_1_forward_price_to_earnings

    @property
    def industry_last_5_year_actual(self):
        """Gets the industry_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The industry_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._industry_last_5_year_actual
        
    @property
    def industry_last_5_year_actual_dict(self):
        """Gets the industry_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's last 5 year actual percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_last_5_year_actual
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_last_5_year_actual': value }

        
        return result
        

    @industry_last_5_year_actual.setter
    def industry_last_5_year_actual(self, industry_last_5_year_actual):
        """Sets the industry_last_5_year_actual of this ZacksEPSGrowthRate.

        The industry's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param industry_last_5_year_actual: The industry_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._industry_last_5_year_actual = industry_last_5_year_actual

    @property
    def industry_fiscal_year_1_vs_fiscal_year_0(self):
        """Gets the industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._industry_fiscal_year_1_vs_fiscal_year_0
        
    @property
    def industry_fiscal_year_1_vs_fiscal_year_0_dict(self):
        """Gets the industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_fiscal_year_1_vs_fiscal_year_0
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_fiscal_year_1_vs_fiscal_year_0': value }

        
        return result
        

    @industry_fiscal_year_1_vs_fiscal_year_0.setter
    def industry_fiscal_year_1_vs_fiscal_year_0(self, industry_fiscal_year_1_vs_fiscal_year_0):
        """Sets the industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.

        The industry's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param industry_fiscal_year_1_vs_fiscal_year_0: The industry_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._industry_fiscal_year_1_vs_fiscal_year_0 = industry_fiscal_year_1_vs_fiscal_year_0

    @property
    def industry_fiscal_year_2_vs_fiscal_year_1(self):
        """Gets the industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._industry_fiscal_year_2_vs_fiscal_year_1
        
    @property
    def industry_fiscal_year_2_vs_fiscal_year_1_dict(self):
        """Gets the industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_fiscal_year_2_vs_fiscal_year_1
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_fiscal_year_2_vs_fiscal_year_1': value }

        
        return result
        

    @industry_fiscal_year_2_vs_fiscal_year_1.setter
    def industry_fiscal_year_2_vs_fiscal_year_1(self, industry_fiscal_year_2_vs_fiscal_year_1):
        """Sets the industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.

        The industry's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param industry_fiscal_year_2_vs_fiscal_year_1: The industry_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._industry_fiscal_year_2_vs_fiscal_year_1 = industry_fiscal_year_2_vs_fiscal_year_1

    @property
    def industry_long_term_growth_mean(self):
        """Gets the industry_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's long term growth rate mean estimate  # noqa: E501

        :return: The industry_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._industry_long_term_growth_mean
        
    @property
    def industry_long_term_growth_mean_dict(self):
        """Gets the industry_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's long term growth rate mean estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_long_term_growth_mean
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_long_term_growth_mean': value }

        
        return result
        

    @industry_long_term_growth_mean.setter
    def industry_long_term_growth_mean(self, industry_long_term_growth_mean):
        """Sets the industry_long_term_growth_mean of this ZacksEPSGrowthRate.

        The industry's long term growth rate mean estimate  # noqa: E501

        :param industry_long_term_growth_mean: The industry_long_term_growth_mean of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._industry_long_term_growth_mean = industry_long_term_growth_mean

    @property
    def industry_fiscal_year_1_forward_price_to_earnings(self):
        """Gets the industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :return: The industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._industry_fiscal_year_1_forward_price_to_earnings
        
    @property
    def industry_fiscal_year_1_forward_price_to_earnings_dict(self):
        """Gets the industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The industry's forward (current fiscal year) price-to-earnings (P/E) ratio as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_fiscal_year_1_forward_price_to_earnings
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_fiscal_year_1_forward_price_to_earnings': value }

        
        return result
        

    @industry_fiscal_year_1_forward_price_to_earnings.setter
    def industry_fiscal_year_1_forward_price_to_earnings(self, industry_fiscal_year_1_forward_price_to_earnings):
        """Sets the industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.

        The industry's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :param industry_fiscal_year_1_forward_price_to_earnings: The industry_fiscal_year_1_forward_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._industry_fiscal_year_1_forward_price_to_earnings = industry_fiscal_year_1_forward_price_to_earnings

    @property
    def sp500_last_5_year_actual(self):
        """Gets the sp500_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The sp500_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._sp500_last_5_year_actual
        
    @property
    def sp500_last_5_year_actual_dict(self):
        """Gets the sp500_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's last 5 year actual percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sp500_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.sp500_last_5_year_actual
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sp500_last_5_year_actual': value }

        
        return result
        

    @sp500_last_5_year_actual.setter
    def sp500_last_5_year_actual(self, sp500_last_5_year_actual):
        """Sets the sp500_last_5_year_actual of this ZacksEPSGrowthRate.

        The S&P 500's last 5 year actual percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param sp500_last_5_year_actual: The sp500_last_5_year_actual of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._sp500_last_5_year_actual = sp500_last_5_year_actual

    @property
    def sp500_fiscal_year_1_vs_fiscal_year_0(self):
        """Gets the sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._sp500_fiscal_year_1_vs_fiscal_year_0
        
    @property
    def sp500_fiscal_year_1_vs_fiscal_year_0_dict(self):
        """Gets the sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.sp500_fiscal_year_1_vs_fiscal_year_0
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sp500_fiscal_year_1_vs_fiscal_year_0': value }

        
        return result
        

    @sp500_fiscal_year_1_vs_fiscal_year_0.setter
    def sp500_fiscal_year_1_vs_fiscal_year_0(self, sp500_fiscal_year_1_vs_fiscal_year_0):
        """Sets the sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.

        The S&P 500's current fiscal year / last fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param sp500_fiscal_year_1_vs_fiscal_year_0: The sp500_fiscal_year_1_vs_fiscal_year_0 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._sp500_fiscal_year_1_vs_fiscal_year_0 = sp500_fiscal_year_1_vs_fiscal_year_0

    @property
    def sp500_fiscal_year_2_vs_fiscal_year_1(self):
        """Gets the sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :return: The sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._sp500_fiscal_year_2_vs_fiscal_year_1
        
    @property
    def sp500_fiscal_year_2_vs_fiscal_year_1_dict(self):
        """Gets the sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.sp500_fiscal_year_2_vs_fiscal_year_1
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sp500_fiscal_year_2_vs_fiscal_year_1': value }

        
        return result
        

    @sp500_fiscal_year_2_vs_fiscal_year_1.setter
    def sp500_fiscal_year_2_vs_fiscal_year_1(self, sp500_fiscal_year_2_vs_fiscal_year_1):
        """Sets the sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.

        The S&P 500's next fiscal year / current fiscal year percentage earnings-per-share (EPS) growth rate  # noqa: E501

        :param sp500_fiscal_year_2_vs_fiscal_year_1: The sp500_fiscal_year_2_vs_fiscal_year_1 of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._sp500_fiscal_year_2_vs_fiscal_year_1 = sp500_fiscal_year_2_vs_fiscal_year_1

    @property
    def sp500_long_term_growth(self):
        """Gets the sp500_long_term_growth of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's long term growth rate mean estimate  # noqa: E501

        :return: The sp500_long_term_growth of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._sp500_long_term_growth
        
    @property
    def sp500_long_term_growth_dict(self):
        """Gets the sp500_long_term_growth of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's long term growth rate mean estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sp500_long_term_growth of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.sp500_long_term_growth
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sp500_long_term_growth': value }

        
        return result
        

    @sp500_long_term_growth.setter
    def sp500_long_term_growth(self, sp500_long_term_growth):
        """Sets the sp500_long_term_growth of this ZacksEPSGrowthRate.

        The S&P 500's long term growth rate mean estimate  # noqa: E501

        :param sp500_long_term_growth: The sp500_long_term_growth of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._sp500_long_term_growth = sp500_long_term_growth

    @property
    def sp500_fiscal_year_1_price_to_earnings(self):
        """Gets the sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :return: The sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._sp500_fiscal_year_1_price_to_earnings
        
    @property
    def sp500_fiscal_year_1_price_to_earnings_dict(self):
        """Gets the sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501

        The S&P 500's forward (current fiscal year) price-to-earnings (P/E) ratio as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.sp500_fiscal_year_1_price_to_earnings
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sp500_fiscal_year_1_price_to_earnings': value }

        
        return result
        

    @sp500_fiscal_year_1_price_to_earnings.setter
    def sp500_fiscal_year_1_price_to_earnings(self, sp500_fiscal_year_1_price_to_earnings):
        """Sets the sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.

        The S&P 500's forward (current fiscal year) price-to-earnings (P/E) ratio  # noqa: E501

        :param sp500_fiscal_year_1_price_to_earnings: The sp500_fiscal_year_1_price_to_earnings of this ZacksEPSGrowthRate.  # noqa: E501
        :type: float
        """

        self._sp500_fiscal_year_1_price_to_earnings = sp500_fiscal_year_1_price_to_earnings

    @property
    def company(self):
        """Gets the company of this ZacksEPSGrowthRate.  # noqa: E501


        :return: The company of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: CompanySummary
        """
        return self._company
        
    @property
    def company_dict(self):
        """Gets the company of this ZacksEPSGrowthRate.  # noqa: E501


        :return: The company of this ZacksEPSGrowthRate.  # noqa: E501
        :rtype: CompanySummary
        """

        result = None

        value = self.company
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company': value }

        
        return result
        

    @company.setter
    def company(self, company):
        """Sets the company of this ZacksEPSGrowthRate.


        :param company: The company of this ZacksEPSGrowthRate.  # noqa: E501
        :type: CompanySummary
        """

        self._company = company

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ZacksEPSGrowthRate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
