import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MediaPackage::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 * @external
 */
export interface CfnAssetProps {
    /**
     * `AWS::MediaPackage::Asset.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-id
     * @external
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::Asset.PackagingGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-packaginggroupid
     * @external
     */
    readonly packagingGroupId: string;
    /**
     * `AWS::MediaPackage::Asset.SourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcearn
     * @external
     */
    readonly sourceArn: string;
    /**
     * `AWS::MediaPackage::Asset.SourceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcerolearn
     * @external
     */
    readonly sourceRoleArn: string;
    /**
     * `AWS::MediaPackage::Asset.EgressEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-egressendpoints
     * @external
     */
    readonly egressEndpoints?: Array<CfnAsset.EgressEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::Asset.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-resourceid
     * @external
     */
    readonly resourceId?: string;
    /**
     * `AWS::MediaPackage::Asset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 * @external
 * @cloudformationResource AWS::MediaPackage::Asset
 */
export declare class CfnAsset extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Asset";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAsset;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * `AWS::MediaPackage::Asset.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-id
     * @external
     */
    id: string;
    /**
     * `AWS::MediaPackage::Asset.PackagingGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-packaginggroupid
     * @external
     */
    packagingGroupId: string;
    /**
     * `AWS::MediaPackage::Asset.SourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcearn
     * @external
     */
    sourceArn: string;
    /**
     * `AWS::MediaPackage::Asset.SourceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcerolearn
     * @external
     */
    sourceRoleArn: string;
    /**
     * `AWS::MediaPackage::Asset.EgressEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-egressendpoints
     * @external
     */
    egressEndpoints: Array<CfnAsset.EgressEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::Asset.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-resourceid
     * @external
     */
    resourceId: string | undefined;
    /**
     * `AWS::MediaPackage::Asset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::Asset`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 * @external
 * @cloudformationResource AWS::MediaPackage::Asset
 */
export declare namespace CfnAsset {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html
     * @external
     */
    interface EgressEndpointProperty {
        /**
         * `CfnAsset.EgressEndpointProperty.PackagingConfigurationId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html#cfn-mediapackage-asset-egressendpoint-packagingconfigurationid
         * @external
         */
        readonly packagingConfigurationId: string;
        /**
         * `CfnAsset.EgressEndpointProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html#cfn-mediapackage-asset-egressendpoint-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 * @external
 */
export interface CfnChannelProps {
    /**
     * `AWS::MediaPackage::Channel.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id
     * @external
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::Channel.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::MediaPackage::Channel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 * @external
 * @cloudformationResource AWS::MediaPackage::Channel
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Channel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnChannel;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaPackage::Channel.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id
     * @external
     */
    id: string;
    /**
     * `AWS::MediaPackage::Channel.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::MediaPackage::Channel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::Channel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 * @external
 * @cloudformationResource AWS::MediaPackage::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-hlsingest.html
     * @external
     */
    interface HlsIngestProperty {
        /**
         * `CfnChannel.HlsIngestProperty.ingestEndpoints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-hlsingest.html#cfn-mediapackage-channel-hlsingest-ingestendpoints
         * @external
         */
        readonly ingestEndpoints?: Array<CfnChannel.IngestEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 * @external
 * @cloudformationResource AWS::MediaPackage::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-ingestendpoint.html
     * @external
     */
    interface IngestEndpointProperty {
        /**
         * `CfnChannel.IngestEndpointProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-ingestendpoint.html#cfn-mediapackage-channel-ingestendpoint-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnChannel.IngestEndpointProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-ingestendpoint.html#cfn-mediapackage-channel-ingestendpoint-password
         * @external
         */
        readonly password?: string;
        /**
         * `CfnChannel.IngestEndpointProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-ingestendpoint.html#cfn-mediapackage-channel-ingestendpoint-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnChannel.IngestEndpointProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-ingestendpoint.html#cfn-mediapackage-channel-ingestendpoint-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 */
export interface CfnOriginEndpointProps {
    /**
     * `AWS::MediaPackage::OriginEndpoint.ChannelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-channelid
     * @external
     */
    readonly channelId: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-id
     * @external
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Authorization`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-authorization
     * @external
     */
    readonly authorization?: CfnOriginEndpoint.AuthorizationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.CmafPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-cmafpackage
     * @external
     */
    readonly cmafPackage?: CfnOriginEndpoint.CmafPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.DashPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-dashpackage
     * @external
     */
    readonly dashPackage?: CfnOriginEndpoint.DashPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.HlsPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-hlspackage
     * @external
     */
    readonly hlsPackage?: CfnOriginEndpoint.HlsPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ManifestName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-manifestname
     * @external
     */
    readonly manifestName?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.MssPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-msspackage
     * @external
     */
    readonly mssPackage?: CfnOriginEndpoint.MssPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Origination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-origination
     * @external
     */
    readonly origination?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.StartoverWindowSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-startoverwindowseconds
     * @external
     */
    readonly startoverWindowSeconds?: number;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::MediaPackage::OriginEndpoint.TimeDelaySeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-timedelayseconds
     * @external
     */
    readonly timeDelaySeconds?: number;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Whitelist`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-whitelist
     * @external
     */
    readonly whitelist?: string[];
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare class CfnOriginEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::OriginEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOriginEndpoint;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Url
     */
    readonly attrUrl: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ChannelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-channelid
     * @external
     */
    channelId: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-id
     * @external
     */
    id: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Authorization`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-authorization
     * @external
     */
    authorization: CfnOriginEndpoint.AuthorizationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.CmafPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-cmafpackage
     * @external
     */
    cmafPackage: CfnOriginEndpoint.CmafPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.DashPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-dashpackage
     * @external
     */
    dashPackage: CfnOriginEndpoint.DashPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.HlsPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-hlspackage
     * @external
     */
    hlsPackage: CfnOriginEndpoint.HlsPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ManifestName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-manifestname
     * @external
     */
    manifestName: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.MssPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-msspackage
     * @external
     */
    mssPackage: CfnOriginEndpoint.MssPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Origination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-origination
     * @external
     */
    origination: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.StartoverWindowSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-startoverwindowseconds
     * @external
     */
    startoverWindowSeconds: number | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaPackage::OriginEndpoint.TimeDelaySeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-timedelayseconds
     * @external
     */
    timeDelaySeconds: number | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Whitelist`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-whitelist
     * @external
     */
    whitelist: string[] | undefined;
    /**
     * Create a new `AWS::MediaPackage::OriginEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOriginEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html
     * @external
     */
    interface AuthorizationProperty {
        /**
         * `CfnOriginEndpoint.AuthorizationProperty.CdnIdentifierSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html#cfn-mediapackage-originendpoint-authorization-cdnidentifiersecret
         * @external
         */
        readonly cdnIdentifierSecret: string;
        /**
         * `CfnOriginEndpoint.AuthorizationProperty.SecretsRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html#cfn-mediapackage-originendpoint-authorization-secretsrolearn
         * @external
         */
        readonly secretsRoleArn: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html
     * @external
     */
    interface CmafEncryptionProperty {
        /**
         * `CfnOriginEndpoint.CmafEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html#cfn-mediapackage-originendpoint-cmafencryption-keyrotationintervalseconds
         * @external
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.CmafEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html#cfn-mediapackage-originendpoint-cmafencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html
     * @external
     */
    interface CmafPackageProperty {
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-encryption
         * @external
         */
        readonly encryption?: CfnOriginEndpoint.CmafEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.HlsManifests`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-hlsmanifests
         * @external
         */
        readonly hlsManifests?: Array<CfnOriginEndpoint.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.SegmentPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-segmentprefix
         * @external
         */
        readonly segmentPrefix?: string;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-streamselection
         * @external
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html
     * @external
     */
    interface DashEncryptionProperty {
        /**
         * `CfnOriginEndpoint.DashEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html#cfn-mediapackage-originendpoint-dashencryption-keyrotationintervalseconds
         * @external
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html#cfn-mediapackage-originendpoint-dashencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html
     * @external
     */
    interface DashPackageProperty {
        /**
         * `CfnOriginEndpoint.DashPackageProperty.AdTriggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-adtriggers
         * @external
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.DashPackageProperty.AdsOnDeliveryRestrictions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-adsondeliveryrestrictions
         * @external
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-encryption
         * @external
         */
        readonly encryption?: CfnOriginEndpoint.DashEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.ManifestLayout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-manifestlayout
         * @external
         */
        readonly manifestLayout?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.ManifestWindowSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-manifestwindowseconds
         * @external
         */
        readonly manifestWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.MinBufferTimeSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-minbuffertimeseconds
         * @external
         */
        readonly minBufferTimeSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.MinUpdatePeriodSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-minupdateperiodseconds
         * @external
         */
        readonly minUpdatePeriodSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.PeriodTriggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-periodtriggers
         * @external
         */
        readonly periodTriggers?: string[];
        /**
         * `CfnOriginEndpoint.DashPackageProperty.Profile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-profile
         * @external
         */
        readonly profile?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SegmentTemplateFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-segmenttemplateformat
         * @external
         */
        readonly segmentTemplateFormat?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-streamselection
         * @external
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SuggestedPresentationDelaySeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-suggestedpresentationdelayseconds
         * @external
         */
        readonly suggestedPresentationDelaySeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html
     * @external
     */
    interface HlsEncryptionProperty {
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.ConstantInitializationVector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-constantinitializationvector
         * @external
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.EncryptionMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-encryptionmethod
         * @external
         */
        readonly encryptionMethod?: string;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-keyrotationintervalseconds
         * @external
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.RepeatExtXKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-repeatextxkey
         * @external
         */
        readonly repeatExtXKey?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html
     * @external
     */
    interface HlsManifestProperty {
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-admarkers
         * @external
         */
        readonly adMarkers?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdTriggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-adtriggers
         * @external
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdsOnDeliveryRestrictions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-adsondeliveryrestrictions
         * @external
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.IncludeIframeOnlyStream`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-includeiframeonlystream
         * @external
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.ManifestName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-manifestname
         * @external
         */
        readonly manifestName?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.PlaylistType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-playlisttype
         * @external
         */
        readonly playlistType?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.PlaylistWindowSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-playlistwindowseconds
         * @external
         */
        readonly playlistWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-programdatetimeintervalseconds
         * @external
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html
     * @external
     */
    interface HlsPackageProperty {
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-admarkers
         * @external
         */
        readonly adMarkers?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdTriggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-adtriggers
         * @external
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdsOnDeliveryRestrictions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-adsondeliveryrestrictions
         * @external
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-encryption
         * @external
         */
        readonly encryption?: CfnOriginEndpoint.HlsEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.IncludeIframeOnlyStream`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-includeiframeonlystream
         * @external
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.PlaylistType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-playlisttype
         * @external
         */
        readonly playlistType?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.PlaylistWindowSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-playlistwindowseconds
         * @external
         */
        readonly playlistWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-programdatetimeintervalseconds
         * @external
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-streamselection
         * @external
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.UseAudioRenditionGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-useaudiorenditiongroup
         * @external
         */
        readonly useAudioRenditionGroup?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-mssencryption.html
     * @external
     */
    interface MssEncryptionProperty {
        /**
         * `CfnOriginEndpoint.MssEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-mssencryption.html#cfn-mediapackage-originendpoint-mssencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html
     * @external
     */
    interface MssPackageProperty {
        /**
         * `CfnOriginEndpoint.MssPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-encryption
         * @external
         */
        readonly encryption?: CfnOriginEndpoint.MssEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.ManifestWindowSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-manifestwindowseconds
         * @external
         */
        readonly manifestWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-streamselection
         * @external
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html
     * @external
     */
    interface SpekeKeyProviderProperty {
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-certificatearn
         * @external
         */
        readonly certificateArn?: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-resourceid
         * @external
         */
        readonly resourceId: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.SystemIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-systemids
         * @external
         */
        readonly systemIds: string[];
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html
     * @external
     */
    interface StreamSelectionProperty {
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.MaxVideoBitsPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-maxvideobitspersecond
         * @external
         */
        readonly maxVideoBitsPerSecond?: number;
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.MinVideoBitsPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-minvideobitspersecond
         * @external
         */
        readonly minVideoBitsPerSecond?: number;
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.StreamOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-streamorder
         * @external
         */
        readonly streamOrder?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 */
export interface CfnPackagingConfigurationProps {
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id
     * @external
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.PackagingGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid
     * @external
     */
    readonly packagingGroupId: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.CmafPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage
     * @external
     */
    readonly cmafPackage?: CfnPackagingConfiguration.CmafPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.DashPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage
     * @external
     */
    readonly dashPackage?: CfnPackagingConfiguration.DashPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.HlsPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage
     * @external
     */
    readonly hlsPackage?: CfnPackagingConfiguration.HlsPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.MssPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage
     * @external
     */
    readonly mssPackage?: CfnPackagingConfiguration.MssPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare class CfnPackagingConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackagingConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id
     * @external
     */
    id: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.PackagingGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid
     * @external
     */
    packagingGroupId: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.CmafPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage
     * @external
     */
    cmafPackage: CfnPackagingConfiguration.CmafPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.DashPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage
     * @external
     */
    dashPackage: CfnPackagingConfiguration.DashPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.HlsPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage
     * @external
     */
    hlsPackage: CfnPackagingConfiguration.HlsPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.MssPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage
     * @external
     */
    mssPackage: CfnPackagingConfiguration.MssPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::PackagingConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackagingConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafencryption.html
     * @external
     */
    interface CmafEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.CmafEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafencryption.html#cfn-mediapackage-packagingconfiguration-cmafencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html
     * @external
     */
    interface CmafPackageProperty {
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-encryption
         * @external
         */
        readonly encryption?: CfnPackagingConfiguration.CmafEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.HlsManifests`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-hlsmanifests
         * @external
         */
        readonly hlsManifests: Array<CfnPackagingConfiguration.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashencryption.html
     * @external
     */
    interface DashEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.DashEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashencryption.html#cfn-mediapackage-packagingconfiguration-dashencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html
     * @external
     */
    interface DashManifestProperty {
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.ManifestLayout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-manifestlayout
         * @external
         */
        readonly manifestLayout?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.ManifestName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-manifestname
         * @external
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.MinBufferTimeSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-minbuffertimeseconds
         * @external
         */
        readonly minBufferTimeSeconds?: number;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.Profile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-profile
         * @external
         */
        readonly profile?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-streamselection
         * @external
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html
     * @external
     */
    interface DashPackageProperty {
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.DashManifests`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-dashmanifests
         * @external
         */
        readonly dashManifests: Array<CfnPackagingConfiguration.DashManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-encryption
         * @external
         */
        readonly encryption?: CfnPackagingConfiguration.DashEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.PeriodTriggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-periodtriggers
         * @external
         */
        readonly periodTriggers?: string[];
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.SegmentTemplateFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-segmenttemplateformat
         * @external
         */
        readonly segmentTemplateFormat?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html
     * @external
     */
    interface HlsEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.ConstantInitializationVector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-constantinitializationvector
         * @external
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.EncryptionMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-encryptionmethod
         * @external
         */
        readonly encryptionMethod?: string;
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html
     * @external
     */
    interface HlsManifestProperty {
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.AdMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-admarkers
         * @external
         */
        readonly adMarkers?: string;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.IncludeIframeOnlyStream`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-includeiframeonlystream
         * @external
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.ManifestName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-manifestname
         * @external
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-programdatetimeintervalseconds
         * @external
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.RepeatExtXKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-repeatextxkey
         * @external
         */
        readonly repeatExtXKey?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-streamselection
         * @external
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html
     * @external
     */
    interface HlsPackageProperty {
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-encryption
         * @external
         */
        readonly encryption?: CfnPackagingConfiguration.HlsEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.HlsManifests`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-hlsmanifests
         * @external
         */
        readonly hlsManifests: Array<CfnPackagingConfiguration.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.UseAudioRenditionGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-useaudiorenditiongroup
         * @external
         */
        readonly useAudioRenditionGroup?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssencryption.html
     * @external
     */
    interface MssEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.MssEncryptionProperty.SpekeKeyProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssencryption.html#cfn-mediapackage-packagingconfiguration-mssencryption-spekekeyprovider
         * @external
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html
     * @external
     */
    interface MssManifestProperty {
        /**
         * `CfnPackagingConfiguration.MssManifestProperty.ManifestName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html#cfn-mediapackage-packagingconfiguration-mssmanifest-manifestname
         * @external
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.MssManifestProperty.StreamSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html#cfn-mediapackage-packagingconfiguration-mssmanifest-streamselection
         * @external
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html
     * @external
     */
    interface MssPackageProperty {
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-encryption
         * @external
         */
        readonly encryption?: CfnPackagingConfiguration.MssEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.MssManifests`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-mssmanifests
         * @external
         */
        readonly mssManifests: Array<CfnPackagingConfiguration.MssManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.SegmentDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-segmentdurationseconds
         * @external
         */
        readonly segmentDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html
     * @external
     */
    interface SpekeKeyProviderProperty {
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.SystemIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-systemids
         * @external
         */
        readonly systemIds: string[];
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html
     * @external
     */
    interface StreamSelectionProperty {
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.MaxVideoBitsPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-maxvideobitspersecond
         * @external
         */
        readonly maxVideoBitsPerSecond?: number;
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.MinVideoBitsPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-minvideobitspersecond
         * @external
         */
        readonly minVideoBitsPerSecond?: number;
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.StreamOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-streamorder
         * @external
         */
        readonly streamOrder?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::PackagingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 * @external
 */
export interface CfnPackagingGroupProps {
    /**
     * `AWS::MediaPackage::PackagingGroup.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-id
     * @external
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Authorization`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-authorization
     * @external
     */
    readonly authorization?: CfnPackagingGroup.AuthorizationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 */
export declare class CfnPackagingGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackagingGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Id`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-id
     * @external
     */
    id: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Authorization`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-authorization
     * @external
     */
    authorization: CfnPackagingGroup.AuthorizationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::PackagingGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackagingGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 */
export declare namespace CfnPackagingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html
     * @external
     */
    interface AuthorizationProperty {
        /**
         * `CfnPackagingGroup.AuthorizationProperty.CdnIdentifierSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html#cfn-mediapackage-packaginggroup-authorization-cdnidentifiersecret
         * @external
         */
        readonly cdnIdentifierSecret: string;
        /**
         * `CfnPackagingGroup.AuthorizationProperty.SecretsRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html#cfn-mediapackage-packaginggroup-authorization-secretsrolearn
         * @external
         */
        readonly secretsRoleArn: string;
    }
}
