import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Wisdom::Assistant`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html
 */
export interface CfnAssistantProps {
    /**
     * `AWS::Wisdom::Assistant.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-name
     */
    readonly name: string;
    /**
     * `AWS::Wisdom::Assistant.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-type
     */
    readonly type: string;
    /**
     * `AWS::Wisdom::Assistant.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-description
     */
    readonly description?: string;
    /**
     * `AWS::Wisdom::Assistant.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-serversideencryptionconfiguration
     */
    readonly serverSideEncryptionConfiguration?: CfnAssistant.ServerSideEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::Assistant.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Wisdom::Assistant`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::Assistant
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html
 */
export declare class CfnAssistant extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Wisdom::Assistant";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssistant;
    /**
     * @external
     * @cloudformationAttribute AssistantArn
     */
    readonly attrAssistantArn: string;
    /**
     * @external
     * @cloudformationAttribute AssistantId
     */
    readonly attrAssistantId: string;
    /**
     * `AWS::Wisdom::Assistant.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-name
     */
    name: string;
    /**
     * `AWS::Wisdom::Assistant.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-type
     */
    type: string;
    /**
     * `AWS::Wisdom::Assistant.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-description
     */
    description: string | undefined;
    /**
     * `AWS::Wisdom::Assistant.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-serversideencryptionconfiguration
     */
    serverSideEncryptionConfiguration: CfnAssistant.ServerSideEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Wisdom::Assistant.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html#cfn-wisdom-assistant-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Wisdom::Assistant`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssistantProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Wisdom::Assistant`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::Assistant
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html
 */
export declare namespace CfnAssistant {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-assistant-serversideencryptionconfiguration.html
     */
    interface ServerSideEncryptionConfigurationProperty {
        /**
         * `CfnAssistant.ServerSideEncryptionConfigurationProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-assistant-serversideencryptionconfiguration.html#cfn-wisdom-assistant-serversideencryptionconfiguration-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * Properties for defining a `AWS::Wisdom::AssistantAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html
 */
export interface CfnAssistantAssociationProps {
    /**
     * `AWS::Wisdom::AssistantAssociation.AssistantId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-assistantid
     */
    readonly assistantId: string;
    /**
     * `AWS::Wisdom::AssistantAssociation.Association`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-association
     */
    readonly association: CfnAssistantAssociation.AssociationDataProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::AssistantAssociation.AssociationType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-associationtype
     */
    readonly associationType: string;
    /**
     * `AWS::Wisdom::AssistantAssociation.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Wisdom::AssistantAssociation`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::AssistantAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html
 */
export declare class CfnAssistantAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Wisdom::AssistantAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssistantAssociation;
    /**
     * @external
     * @cloudformationAttribute AssistantArn
     */
    readonly attrAssistantArn: string;
    /**
     * @external
     * @cloudformationAttribute AssistantAssociationArn
     */
    readonly attrAssistantAssociationArn: string;
    /**
     * @external
     * @cloudformationAttribute AssistantAssociationId
     */
    readonly attrAssistantAssociationId: string;
    /**
     * `AWS::Wisdom::AssistantAssociation.AssistantId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-assistantid
     */
    assistantId: string;
    /**
     * `AWS::Wisdom::AssistantAssociation.Association`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-association
     */
    association: CfnAssistantAssociation.AssociationDataProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::AssistantAssociation.AssociationType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-associationtype
     */
    associationType: string;
    /**
     * `AWS::Wisdom::AssistantAssociation.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html#cfn-wisdom-assistantassociation-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Wisdom::AssistantAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssistantAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Wisdom::AssistantAssociation`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::AssistantAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html
 */
export declare namespace CfnAssistantAssociation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-assistantassociation-associationdata.html
     */
    interface AssociationDataProperty {
        /**
         * `CfnAssistantAssociation.AssociationDataProperty.KnowledgeBaseId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-assistantassociation-associationdata.html#cfn-wisdom-assistantassociation-associationdata-knowledgebaseid
         */
        readonly knowledgeBaseId: string;
    }
}
/**
 * Properties for defining a `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export interface CfnKnowledgeBaseProps {
    /**
     * `AWS::Wisdom::KnowledgeBase.KnowledgeBaseType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype
     */
    readonly knowledgeBaseType: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name
     */
    readonly name: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description
     */
    readonly description?: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.RenderingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration
     */
    readonly renderingConfiguration?: CfnKnowledgeBase.RenderingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::KnowledgeBase.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration
     */
    readonly serverSideEncryptionConfiguration?: CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::KnowledgeBase.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration
     */
    readonly sourceConfiguration?: CfnKnowledgeBase.SourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Wisdom::KnowledgeBase.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::KnowledgeBase
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export declare class CfnKnowledgeBase extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Wisdom::KnowledgeBase";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnKnowledgeBase;
    /**
     * @external
     * @cloudformationAttribute KnowledgeBaseArn
     */
    readonly attrKnowledgeBaseArn: string;
    /**
     * @external
     * @cloudformationAttribute KnowledgeBaseId
     */
    readonly attrKnowledgeBaseId: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.KnowledgeBaseType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype
     */
    knowledgeBaseType: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name
     */
    name: string;
    /**
     * `AWS::Wisdom::KnowledgeBase.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description
     */
    description: string | undefined;
    /**
     * `AWS::Wisdom::KnowledgeBase.RenderingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration
     */
    renderingConfiguration: CfnKnowledgeBase.RenderingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Wisdom::KnowledgeBase.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration
     */
    serverSideEncryptionConfiguration: CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Wisdom::KnowledgeBase.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration
     */
    sourceConfiguration: CfnKnowledgeBase.SourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Wisdom::KnowledgeBase.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Wisdom::KnowledgeBase`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnKnowledgeBaseProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::KnowledgeBase
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export declare namespace CfnKnowledgeBase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html
     */
    interface AppIntegrationsConfigurationProperty {
        /**
         * `CfnKnowledgeBase.AppIntegrationsConfigurationProperty.AppIntegrationArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-appintegrationarn
         */
        readonly appIntegrationArn: string;
        /**
         * `CfnKnowledgeBase.AppIntegrationsConfigurationProperty.ObjectFields`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-objectfields
         */
        readonly objectFields: string[];
    }
}
/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::KnowledgeBase
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export declare namespace CfnKnowledgeBase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html
     */
    interface RenderingConfigurationProperty {
        /**
         * `CfnKnowledgeBase.RenderingConfigurationProperty.TemplateUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html#cfn-wisdom-knowledgebase-renderingconfiguration-templateuri
         */
        readonly templateUri?: string;
    }
}
/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::KnowledgeBase
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export declare namespace CfnKnowledgeBase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html
     */
    interface ServerSideEncryptionConfigurationProperty {
        /**
         * `CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 *
 * @external
 * @cloudformationResource AWS::Wisdom::KnowledgeBase
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html
 */
export declare namespace CfnKnowledgeBase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html
     */
    interface SourceConfigurationProperty {
        /**
         * `CfnKnowledgeBase.SourceConfigurationProperty.AppIntegrations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html#cfn-wisdom-knowledgebase-sourceconfiguration-appintegrations
         */
        readonly appIntegrations?: CfnKnowledgeBase.AppIntegrationsConfigurationProperty | cdk.IResolvable;
    }
}
