# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CoreApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_deployment_requests_batch_delete(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment requests  # noqa: E501

         ### Description Delete multiple batch deployment requests for the default version of a deployment. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_delete(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_batch_delete_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment requests  # noqa: E501

         ### Description Delete multiple batch deployment requests for the default version of a deployment. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_batch_get(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests for the default version of a deployment. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to. - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_get(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_batch_get_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests for the default version of a deployment. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to. - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create batch deployment requests  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create batch deployment requests  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_delete(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete batch deployment requests  # noqa: E501

         ### Description Delete a batch deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_delete(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def batch_deployment_requests_delete_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete batch deployment requests  # noqa: E501

         ### Description Delete a batch deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_deployment_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_get(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get batch deployment request  # noqa: E501

         ### Description Get a batch request of the default version of a deployment. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_get(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_get_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def batch_deployment_requests_get_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get batch deployment request  # noqa: E501

         ### Description Get a batch request of the default version of a deployment. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_get_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_deployment_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List batch deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def batch_deployment_requests_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List batch deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `version`: Name of the version the request was made to - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the deployment request was successful - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `batch_deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `batch_deployment_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_batch_delete(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment version requests  # noqa: E501

         ### Description Delete multiple batch deployment requests for a deployment version. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_batch_delete(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_batch_delete_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment version requests  # noqa: E501

         ### Description Delete multiple batch deployment requests for a deployment version. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_version_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_batch_get(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment version request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests for a deployment version. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_batch_get(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_batch_get_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment version request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests for a deployment version. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_version_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create batch deployment version requests  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create batch deployment version requests  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_delete(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch deployment version requests  # noqa: E501

         ### Description Delete a batch deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_delete(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_delete_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch deployment version requests  # noqa: E501

         ### Description Delete a batch deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_get(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch deployment version request  # noqa: E501

         ### Description Get a batch request for a deployment version. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_get(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_get_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch deployment version request  # noqa: E501

         ### Description Get a batch request for a deployment version. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List batch deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_version_requests_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List batch deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `batch_deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `batch_deployment_version_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_batch_delete(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline requests  # noqa: E501

         ### Description Delete multiple batch pipeline requests for the default version of a pipeline. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_delete(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_batch_delete_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline requests  # noqa: E501

         ### Description Delete multiple batch pipeline requests for the default version of a pipeline. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_batch_get(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline request results  # noqa: E501

         ### Description Retrieve multiple batch pipeline requests for the default version of a pipeline. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],       \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_get(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_batch_get_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline request results  # noqa: E501

         ### Description Retrieve multiple batch pipeline requests for the default version of a pipeline. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],       \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create batch pipeline requests  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create batch pipeline requests  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_delete(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete batch pipeline requests  # noqa: E501

         ### Description Delete a batch request for the default version of a pipeline. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_delete(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def batch_pipeline_requests_delete_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete batch pipeline requests  # noqa: E501

         ### Description Delete a batch request for the default version of a pipeline. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_pipeline_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_get(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get batch pipeline request  # noqa: E501

         ### Description Get a batch request for the default version of a pipeline. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_get(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchPipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def batch_pipeline_requests_get_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get batch pipeline request  # noqa: E501

         ### Description Get a batch request for the default version of a pipeline. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchPipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_pipeline_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchPipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List batch pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def batch_pipeline_requests_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List batch pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `batch_pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `batch_pipeline_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_batch_delete(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline version requests  # noqa: E501

         ### Description Delete multiple batch requests for a pipeline version. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_batch_delete(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_batch_delete_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_batch_delete_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline version requests  # noqa: E501

         ### Description Delete multiple batch requests for a pipeline version. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_batch_delete_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_version_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_batch_get(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline version request results  # noqa: E501

         ### Description Retrieve multiple batch requests for a pipeline version. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline version requests can be retrieved with this method. The pipeline version requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],       \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_batch_get(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_batch_get_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_batch_get_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline version request results  # noqa: E501

         ### Description Retrieve multiple batch requests for a pipeline version. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline version requests can be retrieved with this method. The pipeline version requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [],       \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_batch_get_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_version_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create batch pipeline version requests  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create batch pipeline version requests  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_delete(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch pipeline version requests  # noqa: E501

         ### Description Delete a batch request for a pipeline version. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_delete(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_delete_with_http_info(project_name, pipeline_name, request_id, version, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_delete_with_http_info(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch pipeline version requests  # noqa: E501

         ### Description Delete a batch request for a pipeline version. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_delete_with_http_info(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_get(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch pipeline version request  # noqa: E501

         ### Description Get a batch request for a pipeline version. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline version request with the following fields:  - `id`: Unique identifier for the pipeline version request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_get(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchPipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_get_with_http_info(project_name, pipeline_name, request_id, version, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_get_with_http_info(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch pipeline version request  # noqa: E501

         ### Description Get a batch request for a pipeline version. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline version request with the following fields:  - `id`: Unique identifier for the pipeline version request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_get_with_http_info(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchPipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `batch_pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchPipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_list(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List batch pipeline version requests  # noqa: E501

         ### Description List all batch requests for a pipeline version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline version request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_list(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_version_requests_list_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_list_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List batch pipeline version requests  # noqa: E501

         ### Description List all batch requests for a pipeline version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline version request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_list_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `batch_pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `batch_pipeline_version_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_create(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The returned blob_id may be passed in a deployment or pipeline request as input.  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_create_with_http_info(project_name, file, **kwargs)  # noqa: E501

    def blobs_create_with_http_info(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The returned blob_id may be passed in a deployment or pipeline request as input.  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create_with_http_info(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_create`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_delete(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_delete_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_delete_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_delete`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_get(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_get_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_get_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_get`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_list(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 259200   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BlobList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def blobs_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 259200   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BlobList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'range', 'creation_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'range' in local_var_params
            and local_var_params['range'] is not None):  # noqa: E501
            if not isinstance(local_var_params['range'], int):  # noqa: E501
                raise ApiValueError("Parameter `range` must be an integer when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'creation_date' in local_var_params
            and local_var_params['creation_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['creation_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `creation_date` must be a string when calling `blobs_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'range' in local_var_params and local_var_params['range'] is not None:  # noqa: E501
            query_params.append(('range', local_var_params['range']))  # noqa: E501
        if 'creation_date' in local_var_params and local_var_params['creation_date'] is not None:  # noqa: E501
            query_params.append(('creation_date', local_var_params['creation_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlobList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_update(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_update_with_http_info(project_name, blob_id, file, **kwargs)  # noqa: E501

    def blobs_update_with_http_info(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update_with_http_info(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_get(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BuildList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.builds_get_with_http_info(project_name, build_id, deployment_name, version, **kwargs)  # noqa: E501

    def builds_get_with_http_info(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get_with_http_info(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BuildList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'build_id', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'build_id' is set
        if self.api_client.client_side_validation and ('build_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['build_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `build_id` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'build_id' in local_var_params
            and local_var_params['build_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['build_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `build_id` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'build_id' in local_var_params:
            path_params['build_id'] = local_var_params['build_id']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\"   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BuildList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.builds_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def builds_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'deploying', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\"   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BuildList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BuildList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_audit_events_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_audit_events_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_audit_events_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_audit_events_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_copy(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_copy_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_delete(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_get(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_get_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_environment_variables_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_update(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_update_with_http_info(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment requests  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment requests  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_copy(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_copy_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_delete(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_get(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_get_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_update(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_update_with_http_info(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version requests  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version requests  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** type field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a blob field ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  A plain deployment request ``` \"example-plain-data\" ```  ### Response Structure  Details of the created deployment request - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.5, python3.6, python3.7, python3.8 or r4.0. The default value is python3.7. - `memory_allocation`: Reserved memory for the version in MB. This value determines the memory allocated to the version: it should to be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 32768 respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5, the maximum value is 20. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```   ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"memory_allocation\": 512 } ```   ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `memory_allocation`: Reserved memory for the version in MB   - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"memory_allocation\": 512,   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_versions_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.5, python3.6, python3.7, python3.8 or r4.0. The default value is python3.7. - `memory_allocation`: Reserved memory for the version in MB. This value determines the memory allocated to the version: it should to be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 32768 respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5, the maximum value is 20. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```   ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"memory_allocation\": 512 } ```   ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `memory_allocation`: Reserved memory for the version in MB   - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"memory_allocation\": 512,   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_delete(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

          ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_delete_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_delete_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

          ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_get(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory for the version in MB  - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_get_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_get_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory for the version in MB  - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory usage for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"memory_allocation\": 512,     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"memory_allocation\": 256,     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentVersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_versions_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory usage for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"memory_allocation\": 512,     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"memory_allocation\": 256,     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentVersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployment_versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentVersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_update(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `version`: New name for the version - `memory_allocation`: New reserved memory for the version in MB - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples  ``` {   \"version\": \"new-version\" } ```   ``` {   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_versions_update_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `version`: New name for the version - `memory_allocation`: New reserved memory for the version in MB - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples  ``` {   \"version\": \"new-version\" } ```   ``` {   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `memory_allocation`: Reserved memory for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def deployments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_delete(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_delete_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_delete_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_get(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_get_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_get_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_list(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def deployments_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_update(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment. It is only possible to update the name, description and labels fields. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_update_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployments_update_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment. It is only possible to update the name, description and labels fields. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def metrics_get(self, project_name, metric, start_time, end_time, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline version   Metrics on deployment version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Time in seconds for a request to complete  - `instances`: Number of active deployment instances  - `gb_seconds`: Usage of GB seconds, calculated by multiplying the deployment memory sizes in GB by the number of seconds the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_time`: Starting time for the metric values to be returned. It should be provided in datetime isoformat. - `end_time`: Ending time for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `deployment_version` or `pipeline_version`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`.  ### Response Structure  - `start_time`: Timestamp denoting the start of the period over which the metric was measured - `end_time`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 12:03:00 ``` [   {     \"start_time\": \"2019-11-13T12:00:00+00:00\",     \"end_time\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_time\": \"2019-11-13T12:01:00+00:00\",     \"end_time\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_time\": \"2019-11-13T12:02:00+00:00\",     \"end_time\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 14:00:00 ``` [   {    \"start_time\": \"2019-11-13T12:00:00+00:00\",    \"end_time\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_time\": \"2019-11-13T13:00:00+00:00\",     \"end_time\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_time\": \"2019-11-13T14:00:00+00:00\",     \"end_time\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```   With interval as day, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-14 12:00:00 ``` [   {    \"start_time\": \"2019-11-13T00:00:00+00:00\",    \"end_time\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_time\": \"2019-11-14T00:00:00+00:00\",     \"end_time\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```   With interval as month, start_time as 2019-11-13 12:00:00 and end_time as 2019-12-13 12:00:00 ``` [   {    \"start_time\": \"2019-11-01T00:00:00+00:00\",    \"end_time\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get(project_name, metric, start_time, end_time, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_time: (required)
        :param str end_time: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Metrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.metrics_get_with_http_info(project_name, metric, start_time, end_time, object_type, **kwargs)  # noqa: E501

    def metrics_get_with_http_info(self, project_name, metric, start_time, end_time, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline version   Metrics on deployment version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Time in seconds for a request to complete  - `instances`: Number of active deployment instances  - `gb_seconds`: Usage of GB seconds, calculated by multiplying the deployment memory sizes in GB by the number of seconds the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_time`: Starting time for the metric values to be returned. It should be provided in datetime isoformat. - `end_time`: Ending time for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `deployment_version` or `pipeline_version`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`.  ### Response Structure  - `start_time`: Timestamp denoting the start of the period over which the metric was measured - `end_time`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 12:03:00 ``` [   {     \"start_time\": \"2019-11-13T12:00:00+00:00\",     \"end_time\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_time\": \"2019-11-13T12:01:00+00:00\",     \"end_time\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_time\": \"2019-11-13T12:02:00+00:00\",     \"end_time\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 14:00:00 ``` [   {    \"start_time\": \"2019-11-13T12:00:00+00:00\",    \"end_time\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_time\": \"2019-11-13T13:00:00+00:00\",     \"end_time\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_time\": \"2019-11-13T14:00:00+00:00\",     \"end_time\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```   With interval as day, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-14 12:00:00 ``` [   {    \"start_time\": \"2019-11-13T00:00:00+00:00\",    \"end_time\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_time\": \"2019-11-14T00:00:00+00:00\",     \"end_time\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```   With interval as month, start_time as 2019-11-13 12:00:00 and end_time as 2019-12-13 12:00:00 ``` [   {    \"start_time\": \"2019-11-01T00:00:00+00:00\",    \"end_time\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get_with_http_info(project_name, metric, start_time, end_time, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_time: (required)
        :param str end_time: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Metrics], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'metric', 'start_time', 'end_time', 'object_type', 'interval', 'object_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metrics_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'metric' is set
        if self.api_client.client_side_validation and ('metric' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'object_type' is set
        if self.api_client.client_side_validation and ('object_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_type` when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metric' in local_var_params
            and local_var_params['metric'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metric'], str):  # noqa: E501
                raise ApiValueError("Parameter `metric` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_time' in local_var_params
            and local_var_params['start_time'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_time'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_time` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_time' in local_var_params
            and local_var_params['end_time'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_time'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_time` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'object_type' in local_var_params
            and local_var_params['object_type'] is not None):  # noqa: E501
            if not isinstance(local_var_params['object_type'], str):  # noqa: E501
                raise ApiValueError("Parameter `object_type` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'interval' in local_var_params
            and local_var_params['interval'] is not None):  # noqa: E501
            if not isinstance(local_var_params['interval'], str):  # noqa: E501
                raise ApiValueError("Parameter `interval` must be a string when calling `metrics_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'object_id' in local_var_params
            and local_var_params['object_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['object_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `object_id` must be a string when calling `metrics_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'metric' in local_var_params:
            path_params['metric'] = local_var_params['metric']  # noqa: E501

        query_params = []
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('start_time', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('end_time', local_var_params['end_time']))  # noqa: E501
        if 'object_type' in local_var_params and local_var_params['object_type'] is not None:  # noqa: E501
            query_params.append(('object_type', local_var_params['object_type']))  # noqa: E501
        if 'object_id' in local_var_params and local_var_params['object_id'] is not None:  # noqa: E501
            query_params.append(('object_id', local_var_params['object_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/metrics/{metric}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Metrics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_usage_details_get(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage details  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per day.  ### Optional Parameters  - `month`: date indicating the month to fetch usage data for, formatted `YYYY-MM`. If omitted defaults to the current month  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `day`: Timestamp denoting the start of the day      - `value`: Aggregated metric value for the given unit over the given day  #### Response Examples ``` [   {     \"object_type\": \"version\",     \"metric\": \"gb_seconds\",     \"usage\": [       {         \"day\": \"2020-07-29T00:00:00Z\",         \"value\": 4200       },       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 840       },       {         \"day\": \"2020-07-30T00:00:00Z\",         \"value\": 960       }     ]   },   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 1098       },       {         \"day\": \"2020-07-06T00:00:00Z\",         \"value\": 18       },       {         \"day\": \"2020-07-16T00:00:00Z\",         \"value\": 9       },       {         \"day\": \"2020-07-15T00:00:00Z\",         \"value\": 117       },       {         \"day\": \"2020-07-08T00:00:00Z\",         \"value\": 90       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_details_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str month:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UsagePerDay]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_usage_details_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_usage_details_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage details  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per day.  ### Optional Parameters  - `month`: date indicating the month to fetch usage data for, formatted `YYYY-MM`. If omitted defaults to the current month  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `day`: Timestamp denoting the start of the day      - `value`: Aggregated metric value for the given unit over the given day  #### Response Examples ``` [   {     \"object_type\": \"version\",     \"metric\": \"gb_seconds\",     \"usage\": [       {         \"day\": \"2020-07-29T00:00:00Z\",         \"value\": 4200       },       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 840       },       {         \"day\": \"2020-07-30T00:00:00Z\",         \"value\": 960       }     ]   },   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 1098       },       {         \"day\": \"2020-07-06T00:00:00Z\",         \"value\": 18       },       {         \"day\": \"2020-07-16T00:00:00Z\",         \"value\": 9       },       {         \"day\": \"2020-07-15T00:00:00Z\",         \"value\": 117       },       {         \"day\": \"2020-07-08T00:00:00Z\",         \"value\": 90       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_details_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str month:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UsagePerDay], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'month']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_usage_details_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_usage_details_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_usage_details_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'month' in local_var_params
            and local_var_params['month'] is not None):  # noqa: E501
            if not isinstance(local_var_params['month'], str):  # noqa: E501
                raise ApiValueError("Parameter `month` must be a string when calling `organization_usage_details_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []
        if 'month' in local_var_params and local_var_params['month'] is not None:  # noqa: E501
            query_params.append(('month', local_var_params['month']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/usage/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UsagePerDay]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_usage_get(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str start_month:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UsagePerMonth]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_usage_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_usage_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str start_month:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UsagePerMonth], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'start_month']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_usage_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_usage_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_usage_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_month' in local_var_params
            and local_var_params['start_month'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_month'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_month` must be a string when calling `organization_usage_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []
        if 'start_month' in local_var_params and local_var_params['start_month'] is not None:  # noqa: E501
            query_params.append(('start_month', local_var_params['start_month']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UsagePerMonth]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_create(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_create_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organization_users_create_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_delete(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_delete_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_delete_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_get(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_get_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_get_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_get`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_list(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationUserDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_list_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_users_list_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationUserDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationUserDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_update(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_update_with_http_info(organization_name, user_id, data, **kwargs)  # noqa: E501

    def organization_users_update_with_http_info(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update_with_http_info(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organization_users_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'user_id' in local_var_params
            and local_var_params['user_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['user_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `user_id` must be a string when calling `organization_users_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_create(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year. **Provide a null value for this field to have no end date.**  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true,   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_create_with_http_info(data, **kwargs)  # noqa: E501

    def organizations_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year. **Provide a null value for this field to have no end date.**  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true,   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_get(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_list(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_list_with_http_info(**kwargs)  # noqa: E501

    def organizations_list_with_http_info(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_resource_usage(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_resource_usage_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_resource_usage_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceUsage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_resource_usage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_resource_usage`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_resource_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_update(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted upon upgrading the subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If the subscription_end_date was previously set, but should be removed, give a null value for this field.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_agreed\": true } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_agreed\": true } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_update_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organizations_update_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted upon upgrading the subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If the subscription_end_date was previously set, but should be removed, give a null value for this field.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_agreed\": true } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_agreed\": true } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'organization_name' in local_var_params
            and local_var_params['organization_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['organization_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `organization_name` must be a string when calling `organizations_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_list(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PermissionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_list_with_http_info(**kwargs)  # noqa: E501

    def permissions_list_with_http_info(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PermissionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_audit_events_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_audit_events_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline requests  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` \"example-plain-data\" ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `success`: A boolean value that indicates whether the pipeline request was successful - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"success\": false   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline requests  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` \"example-plain-data\" ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `success`: A boolean value that indicates whether the pipeline request was successful - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"success\": false   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_timeout' in local_var_params
            and local_var_params['pipeline_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_timeout' in local_var_params
            and local_var_params['deployment_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `deployment_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between objects in a pipeline version. An attachment can only be made between objects that have already been added to the pipeline version.  The objects where the attachment starts is called the source objects. The object that is linked is called the destination object. When attaching source objects to a destination object, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all output fields of all source objects need to be used in the mapping. It is also possible that one source output field links to multiple destination input fields.  The *pipeline_start* object can only be a source object.  In case of plain type of objects, the mapping `source_field_name` and `destination_field_name` must be omitted or given as null.  ### Required Parameters  - `destination_name`: Name of the destination object in the pipeline version - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name). Each item in the sources list must contain source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two structured deployments ``` {   \"destination_name\": \"deployment-2-v1\",   \"sources\": [     {       \"source_name\": \"deployment-1-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-output-field-1\",           \"destination_field_name\": \"deployment-2-input-field-1\"         },         {           \"source_field_name\": \"deployment-output-field-2\",           \"destination_field_name\": \"deployment-2-input-field-2\"         },         {           \"source_field_name\": \"deployment-output-field-3\",           \"destination_field_name\": \"deployment-2-input-field-3\"         }       ]     },   ] } ``` An attachment between two plain input/output type deployments ``` {   \"destination_name\": \"plain-deployment-v4\",   \"sources\": [     {       \"source_name\": \"plain-deployment-v3\",       \"mapping\": []     }   ] } ```   An attachment between a pipeline_start object and deployment ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```  ### Response Structure  Details of the created attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param AttachmentsCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttachmentsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between objects in a pipeline version. An attachment can only be made between objects that have already been added to the pipeline version.  The objects where the attachment starts is called the source objects. The object that is linked is called the destination object. When attaching source objects to a destination object, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all output fields of all source objects need to be used in the mapping. It is also possible that one source output field links to multiple destination input fields.  The *pipeline_start* object can only be a source object.  In case of plain type of objects, the mapping `source_field_name` and `destination_field_name` must be omitted or given as null.  ### Required Parameters  - `destination_name`: Name of the destination object in the pipeline version - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name). Each item in the sources list must contain source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two structured deployments ``` {   \"destination_name\": \"deployment-2-v1\",   \"sources\": [     {       \"source_name\": \"deployment-1-v1\",       \"mapping\": [         {           \"source_field_name\": \"deployment-output-field-1\",           \"destination_field_name\": \"deployment-2-input-field-1\"         },         {           \"source_field_name\": \"deployment-output-field-2\",           \"destination_field_name\": \"deployment-2-input-field-2\"         },         {           \"source_field_name\": \"deployment-output-field-3\",           \"destination_field_name\": \"deployment-2-input-field-3\"         }       ]     },   ] } ``` An attachment between two plain input/output type deployments ``` {   \"destination_name\": \"plain-deployment-v4\",   \"sources\": [     {       \"source_name\": \"plain-deployment-v3\",       \"mapping\": []     }   ] } ```   An attachment between a pipeline_start object and deployment ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```  ### Response Structure  Details of the created attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-2-v2\",   \"sources\": [     {       \"source_name\": \"pipeline_start\",       \"mapping\": [         {           \"source_field_name\": \"pipeline-input-field-1\",           \"destination_field_name\": \"deployment-input-field-1\"         },         {           \"source_field_name\": \"pipeline-input-field-2\",           \"destination_field_name\": \"deployment-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param AttachmentsCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttachmentsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttachmentsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_delete(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete object attachment  # noqa: E501

         ### Description  Delete an attachment in a pipeline version. The referenced and original objects of the attachment still exist in the pipeline version, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_delete(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_delete_with_http_info(project_name, attachment_id, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_delete_with_http_info(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete object attachment  # noqa: E501

         ### Description  Delete an attachment in a pipeline version. The referenced and original objects of the attachment still exist in the pipeline version, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_delete_with_http_info(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'attachment_id', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'attachment_id' is set
        if self.api_client.client_side_validation and ('attachment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attachment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attachment_id` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'attachment_id' in local_var_params
            and local_var_params['attachment_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['attachment_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `attachment_id` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'attachment_id' in local_var_params:
            path_params['attachment_id'] = local_var_params['attachment_id']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments/{attachment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_destination_get(self, project_name, destination_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List the attachments of a destination object  # noqa: E501

         ### Description  List attachments of a destination object in a pipeline version  ### Response Structure  A list of details of the attachments of the given destination object in the pipeline version - `destination_name`: Name of the destination object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   },     {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_destination_get(project_name, destination_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_destination_get_with_http_info(project_name, destination_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_destination_get_with_http_info(self, project_name, destination_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List the attachments of a destination object  # noqa: E501

         ### Description  List attachments of a destination object in a pipeline version  ### Response Structure  A list of details of the attachments of the given destination object in the pipeline version - `destination_name`: Name of the destination object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   },     {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {         \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-2-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-2-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_destination_get_with_http_info(project_name, destination_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'destination_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_destination_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'destination_name' is set
        if self.api_client.client_side_validation and ('destination_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['destination_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `destination_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'destination_name' in local_var_params
            and local_var_params['destination_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['destination_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `destination_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_destination_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'destination_name' in local_var_params:
            path_params['destination_name'] = local_var_params['destination_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{destination_name}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_get(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Get object attachment  # noqa: E501

         ### Description  Get the details of a single attachment in a pipeline  ### Response Structure  Details of the attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-3-v1\",   \"sources\": [     {       \"source_name\": \"deployment-2-v2\",       \"mapping\": [         {           \"source_field_name\": \"deployment-2-output-field-1\",           \"destination_field_name\": \"deployment-3-input-field-1\"         },         {           \"source_field_name\": \"deployment-2-output-field-2\",           \"destination_field_name\": \"deployment-3-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_get(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttachmentsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_get_with_http_info(project_name, attachment_id, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_get_with_http_info(self, project_name, attachment_id, pipeline_name, version, **kwargs):  # noqa: E501
        """Get object attachment  # noqa: E501

         ### Description  Get the details of a single attachment in a pipeline  ### Response Structure  Details of the attachment - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the link between a source object (source_name) and mapping of the source output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"destination_name\": \"deployment-3-v1\",   \"sources\": [     {       \"source_name\": \"deployment-2-v2\",       \"mapping\": [         {           \"source_field_name\": \"deployment-2-output-field-1\",           \"destination_field_name\": \"deployment-3-input-field-1\"         },         {           \"source_field_name\": \"deployment-2-output-field-2\",           \"destination_field_name\": \"deployment-3-input-field-2\"         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_get_with_http_info(project_name, attachment_id, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str attachment_id: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttachmentsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'attachment_id', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'attachment_id' is set
        if self.api_client.client_side_validation and ('attachment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attachment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attachment_id` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'attachment_id' in local_var_params
            and local_var_params['attachment_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['attachment_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `attachment_id` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'attachment_id' in local_var_params:
            path_params['attachment_id'] = local_var_params['attachment_id']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments/{attachment_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttachmentsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_attachments_list(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline version  ### Response Structure  A list of details of the attachments in the pipeline - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the source object(s) and mapping of the fields. One attachment can have multiple source objects.  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-2-v2\",     \"sources\": [       {         \"source_name\": \"pipeline_start\",         \"mapping\": [           {             \"source_field_name\": \"pipeline-input-field-1\",             \"destination_field_name\": \"deployment-input-field-1\"           },           {             \"source_field_name\": \"pipeline-input-field-2\",             \"destination_field_name\": \"deployment-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {          \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           },           {             \"source_field_name\": \"deployment-output-field-3\",             \"destination_field_name\": \"deployment-3-input-field-3\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_list(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_attachments_list_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_attachments_list_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline version  ### Response Structure  A list of details of the attachments in the pipeline - `destination_name`: Name of the destination pipeline object - `sources`: A list of dictionaries containing the source object(s) and mapping of the fields. One attachment can have multiple source objects.  #### Response Examples  ``` [   {     \"destination_name\": \"deployment-2-v2\",     \"sources\": [       {         \"source_name\": \"pipeline_start\",         \"mapping\": [           {             \"source_field_name\": \"pipeline-input-field-1\",             \"destination_field_name\": \"deployment-input-field-1\"           },           {             \"source_field_name\": \"pipeline-input-field-2\",             \"destination_field_name\": \"deployment-input-field-2\"           }         ]       }     ]   },   {     \"destination_name\": \"deployment-3-v1\",     \"sources\": [       {          \"source_name\": \"deployment-2-v2\",         \"mapping\": [           {             \"source_field_name\": \"deployment-output-field-1\",             \"destination_field_name\": \"deployment-3-input-field-1\"           },           {             \"source_field_name\": \"deployment-output-field-2\",             \"destination_field_name\": \"deployment-3-input-field-2\"           },           {             \"source_field_name\": \"deployment-output-field-3\",             \"destination_field_name\": \"deployment-3-input-field-3\"           }         ]       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_attachments_list_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_attachments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_attachments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_environment_variables_list(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_object_environment_variables_list_with_http_info(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline object  # noqa: E501

         ### Description  Create a pipeline object for a pipeline version. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline version. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline version as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline version. - `reference_name`: Name of the object it will reference - `version`: Version name of reference object. Do not provide this field to refer to the default version of the reference.  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_objects_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline object  # noqa: E501

         ### Description  Create a pipeline object for a pipeline version. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline version. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline version as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline version. - `reference_name`: Name of the object it will reference - `version`: Version name of reference object. Do not provide this field to refer to the default version of the reference.  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_delete(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline object  # noqa: E501

           ### Description  Delete a pipeline object. Only the reference in the pipeline version is deleted. The original object (deployment and version) still exists. If the object is attached to another object, the attachment is also deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_delete(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_delete_with_http_info(project_name, name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_objects_delete_with_http_info(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline object  # noqa: E501

           ### Description  Delete a pipeline object. Only the reference in the pipeline version is deleted. The original object (deployment and version) still exists. If the object is attached to another object, the attachment is also deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_delete_with_http_info(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_delete`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_objects_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_objects_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_get(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline object  # noqa: E501

         ### Description  Retrieve the details of a single pipeline object  ### Response Structure  Details of the pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A dictionary containing details of the pipeline object ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_get(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_get_with_http_info(project_name, name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_objects_get_with_http_info(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline object  # noqa: E501

         ### Description  Retrieve the details of a single pipeline object  ### Response Structure  Details of the pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A dictionary containing details of the pipeline object ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_get_with_http_info(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_get`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_objects_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_objects_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_list(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline objects  # noqa: E501

         ### Description  List all pipeline objects in a pipeline version  ### Response Structure  A list of details of the pipeline objects in the pipeline version - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A list of pipeline objects ``` [   {     \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",     \"name\": \"deployment-1-v1\",     \"reference_name\": \"deployment-1\",     \"version\": \"version-1\"   },   {     \"id\": \"1a4b0e28-3de1-442a-b1eb-947f22a69381\",     \"name\": \"deployment-2-v1\",     \"reference_name\": \"deployment-2\",     \"version\": \"v1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_list(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineVersionObjectList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_list_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_version_objects_list_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline objects  # noqa: E501

         ### Description  List all pipeline objects in a pipeline version  ### Response Structure  A list of details of the pipeline objects in the pipeline version - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A list of pipeline objects ``` [   {     \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",     \"name\": \"deployment-1-v1\",     \"reference_name\": \"deployment-1\",     \"version\": \"version-1\"   },   {     \"id\": \"1a4b0e28-3de1-442a-b1eb-947f22a69381\",     \"name\": \"deployment-2-v1\",     \"reference_name\": \"deployment-2\",     \"version\": \"v1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_list_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineVersionObjectList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineVersionObjectList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_objects_update(self, project_name, name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline object  # noqa: E501

         ### Description  Update a pipeline object. It is not possible to update the reference_name. All necessary fields are validated again.  ### Optional Parameters  - `name`: New name for the pipeline object - `version`: New version for the pipeline object. Since the input/output fields of different versions are the same, the version of a deployment pipeline object can be changed with another version of the same deployment. To use the default version of the reference deployment, provide NULL for this field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-object-name\" } ```   ``` {   \"name\": \"deployment-1-v2\"   \"version\": \"version-2\" } ```  ### Response Structure  Details of the updated pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v2\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-2\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_update(project_name, name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_objects_update_with_http_info(project_name, name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_objects_update_with_http_info(self, project_name, name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline object  # noqa: E501

         ### Description  Update a pipeline object. It is not possible to update the reference_name. All necessary fields are validated again.  ### Optional Parameters  - `name`: New name for the pipeline object - `version`: New version for the pipeline object. Since the input/output fields of different versions are the same, the version of a deployment pipeline object can be changed with another version of the same deployment. To use the default version of the reference deployment, provide NULL for this field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-object-name\" } ```   ``` {   \"name\": \"deployment-1-v2\"   \"version\": \"version-2\" } ```  ### Response Structure  Details of the updated pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v2\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-2\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_objects_update_with_http_info(project_name, name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionObjectUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_objects_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_objects_update`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_objects_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_objects_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_objects_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_objects_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_objects_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_objects_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_objects_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_objects_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline version requests  # noqa: E501

         ### Description  Make a direct request to a pipeline version. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` \"example-plain-data\" ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `success`: A boolean value that indicates whether the pipeline request was successful - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"success\": false   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_requests_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create pipeline version requests  # noqa: E501

         ### Description  Make a direct request to a pipeline version. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` \"example-plain-data\" ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `success`: A boolean value that indicates whether the pipeline request was successful - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"success\": false   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_timeout' in local_var_params
            and local_var_params['pipeline_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_timeout` must be an integer when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_timeout' in local_var_params
            and local_var_params['deployment_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `deployment_timeout` must be an integer when calling `pipeline_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline versions  # noqa: E501

         ### Description  Create a version for a pipeline. The first version of a pipeline is set as default.  ### Required Parameters  - `version`: Name of the version of the pipeline  ### Optional Parameters - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A pipeline version ``` {   \"version\": \"v1\" } ```  A pipeline version with description and labels ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   } } ```  ### Response Structure  Details of the created pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineVersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_versions_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_versions_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline versions  # noqa: E501

         ### Description  Create a version for a pipeline. The first version of a pipeline is set as default.  ### Required Parameters  - `version`: Name of the version of the pipeline  ### Optional Parameters - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A pipeline version ``` {   \"version\": \"v1\" } ```  A pipeline version with description and labels ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   } } ```  ### Response Structure  Details of the created pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineVersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_delete(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline version  # noqa: E501

         ### Description  Delete a pipeline version. This will also delete all objects and attachments in the pipeline version.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_delete(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_versions_delete_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_versions_delete_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline version  # noqa: E501

         ### Description  Delete a pipeline version. This will also delete all objects and attachments in the pipeline version.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_delete_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_get(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline version  # noqa: E501

         ### Description  Get the details of a single pipeline version  ### Response Structure  Details of the pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_get(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_versions_get_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_versions_get_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline version  # noqa: E501

         ### Description  Get the details of a single pipeline version  ### Response Structure  Details of the pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_get_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline versions  # noqa: E501

         ### Description  Pipeline versions can be filtered according to the labels they have by giving labels as a query parameter. Pipeline versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions of the pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineVersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_versions_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_versions_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline versions  # noqa: E501

         ### Description  Pipeline versions can be filtered according to the labels they have by giving labels as a query parameter. Pipeline versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions of the pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineVersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `pipeline_versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineVersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_update(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline version  # noqa: E501

         ### Description  Update a pipeline version. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  Updating a pipeline version with description and labels ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   } } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_update(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_versions_update_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_versions_update_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline version  # noqa: E501

         ### Description  Update a pipeline version. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  Updating a pipeline version with description and labels ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   } } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_update_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline. It can be either structured or plain. - `input_fields`: A list of fields with name and data_type. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```   A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"description\": \"my description\" } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```   ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def pipelines_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline. It can be either structured or plain. - `input_fields`: A list of fields with name and data_type. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```   A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"description\": \"my description\" } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```   ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipelines_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_delete(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete a pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all versions of the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_delete_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_delete_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete a pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all versions of the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipelines_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_get(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get details of a pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_get_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_get_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get details of a pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipelines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_list(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def pipelines_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `pipelines_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_update(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update a pipeline  # noqa: E501

              ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline - `default_version`: Name of a version of this pipeline which will be assigned as default  If the type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the type of pipeline is updated to structured, the old fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again.  **To delete the input fields of a pipeline**, provide an empty list for input_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```   ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_update_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipelines_update_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update a pipeline  # noqa: E501

              ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline - `default_version`: Name of a version of this pipeline which will be assigned as default  If the type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the type of pipeline is updated to structured, the old fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again.  **To delete the input fields of a pipeline**, provide an empty list for input_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```   ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required para