"""
This file defines constants needed to facilitate communication with the motor controller. Recognized commands,
bit indices, and values are defined here.
"""

# I2C Address
CONTROLLER_ADDRESS = 0x1

# Assorted Min and Max Values
SPEED_MIN = -100
SPEED_MAX = 100
BRAKE_MIN = -100
BRAKE_MAX = 100
BYTE_MAX = 255

# Command Bit Indexes
CHANNEL_1_BIT = 7
CHANNEL_2_BIT = 6
SPEED_BIT = 5
BRAKE_BIT = 4
MIXED_BIT = 3
TOGGLE_STATE_BIT = 2

# Command Bits
CHANNEL_1 = 0b10000000
CHANNEL_2 = 0b01000000
SPEED = 0b00100000
BRAKE = 0b00010000
MIXED = 0b00001000
TOGGLE_STATE = 0b00000100

# Recognized Commands
SET_CHANNEL_1_SPEED = (CHANNEL_1 | SPEED)
SET_CHANNEL_2_SPEED = (CHANNEL_2 | SPEED)
SET_BOTH_CHANNEL_SPEED = ((CHANNEL_1 | CHANNEL_2) | SPEED)
BRAKE_CHANNEL_1 = (CHANNEL_1 | BRAKE)
BRAKE_CHANNEL_2 = (CHANNEL_2 | BRAKE)
BRAKE_BOTH_CHANNELS = ((CHANNEL_1 | CHANNEL_2) | BRAKE)
MIXED_COMMAND = MIXED
TOGGLE_STATE_COMMAND = TOGGLE_STATE

# Motor Driver State
STANDBY = 0
ACTIVE = 1
